/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

final class ColorPickerUtils {
    private static final String[] _CSS16HEX = new String[]{"#FFFFFF", "#FF00FF", "#00FFFF", "#FFFF00", "#CCCCCC", "#990099", "#009999", "#00FF00", "#999999", "#FF0000", "#0000FF", "#999900", "#000000", "#990000", "#000099", "#009900"};
    private static final String[] _16HEX = new String[]{"#FFFFFF", "#C6C6C6", "#FF0000", "#F7F700", "#00FF00", "#00F7F7", "#0000FF", "#FF00FF", "#000000", "#848484", "#840000", "#848400", "#008400", "#008484", "#000084", "#840084"};
    private static final String[] _49HEX = new String[]{"#FFFFFF", "#FFB5B5", "#FFDEB5", "#FFFFB5", "#B5FFB5", "#C6D6FF", "#FFB5FF", "#C6C6C6", "#FF8484", "#FFB563", "#FFFF73", "#73FF73", "#84ADFF", "#FF73FF", "#949494", "#FF5252", "#FF9C31", "#F7F700", "#52FF52", "#3173FF", "#FF00FF", "#737373", "#FF0000", "#E77300", "#C6C600", "#00E700", "#0000FF", "#C600C6", "#424242", "#C60000", "#A55200", "#949400", "#00A500", "#0000A5", "#940094", "#313131", "#730000", "#844200", "#737300", "#008400", "#000084", "#730073", "#000000", "#520000", "#633100", "#525200", "#005200", "#000052", "#520052"};
    private static final String[] _OLD_49HEX = new String[]{"#FFFFFF", "#FFCCCC", "#FFCC99", "#FFFFCC", "#99FF99", "#CCFFFF", "#FFCCFF", "#F7F7E7", "#FF6666", "#FFCC33", "#FFFF99", "#66FF99", "#66FFFF", "#FF99FF", "#CCCCCC", "#FF0000", "#FF9900", "#FFFF00", "#33FF33", "#33CCFF", "#CC66CC", "#999999", "#CC0000", "#FF6600", "#FFCC00", "#00CC00", "#3366FF", "#CC33CC", "#666666", "#990000", "#CC6600", "#999900", "#009900", "#3333FF", "#993366", "#333333", "#660000", "#993300", "#666600", "#006600", "#000099", "#663366", "#000000", "#330000", "#663300", "#333300", "#003300", "#000066", "#330033"};
    private static final String[] _72HEX = new String[]{"#FFFFFF", "#FFB5B5", "#FFDEB5", "#FFFFB5", "#B5FFB5", "#B5FFFF", "#C6D6FF", "#FFB5FF", "#FFB5DE", "#C6C6C6", "#FF8484", "#FFB563", "#FFFF73", "#73FF73", "#73FFFF", "#84ADFF", "#FF73FF", "#FF84C6", "#949494", "#FF5252", "#FF9C31", "#F7F700", "#52FF52", "#00F7F7", "#528CFF", "#FF42FF", "#FF52AD", "#737373", "#FF0000", "#E77300", "#C6C600", "#00E700", "#00D6D6", "#3173FF", "#FF00FF", "#FF2194", "#636363", "#C60000", "#A55200", "#949400", "#00A500", "#009494", "#0000FF", "#C600C6", "#C60063", "#424242", "#940000", "#844200", "#737300", "#008400", "#008484", "#0000A5", "#940094", "#94004A", "#212121", "#730000", "#633100", "#636300", "#006300", "#006363", "#000084", "#730073", "#730039", "#000000", "#520000", "#522900", "#525200", "#005200", "#005252", "#000052", "#520052", "#520029"};
    private static final String[] _80HEX = new String[]{"#FFFFFF", "#FFCCCC", "#FFCC99", "#FFFFCC", "#CCFFCC", "#99FFCC", "#CCFFFF", "#99CCFF", "#CCCCFF", "#FFCCFF", "#F7F7E7", "#FF9999", "#FF9966", "#FFFF99", "#99FF99", "#66FFCC", "#99FFFF", "#66CCFF", "#9999FF", "#FF99FF", "#CCCCCC", "#FF6666", "#FF6633", "#FFFF66", "#66FF66", "#66CCCC", "#66FFFF", "#3399FF", "#9966FF", "#FF66FF", "#666666", "#FF0000", "#FF6600", "#FFFF33", "#00FF00", "#00CCCC", "#00CCFF", "#3366FF", "#9933FF", "#FF33CC", "#666666", "#CC0000", "#FF3300", "#FFFF00", "#009900", "#009999", "#0099FF", "#0000CC", "#9900CC", "#FF0099", "#333333", "#990000", "#CC3300", "#FFCC00", "#006600", "#006666", "#0066FF", "#000099", "#663399", "#CC0099", "#333333", "#660000", "#993300", "#CC9900", "#003300", "#336666", "#0033FF", "#000066", "#660099", "#990066", "#000000", "#330000", "#663300", "#996633", "#003300", "#003333", "#003399", "#000066", "#330066", "#660066"};
    private static final String[] _96HEX = new String[]{"#FFFFFF", "#F7F7E7", "#FDD9C7", "#FFCCCC", "#FFC4D4", "#FFCDE6", "#FFCCFF", "#E5CBFF", "#CBCBFD", "#CCCCFF", "#CEE7FF", "#CCFFFF", "#CDFFE6", "#CCFFCC", "#E7FFCE", "#FFCCCC", "#CCCCCC", "#FFCC99", "#FF9966", "#FF9999", "#FE8AA8", "#FF99CC", "#FF99FF", "#CC99FF", "#A4A4FC", "#9999FF", "#99CCFF", "#99FFFF", "#99FFCC", "#99FF99", "#CCFF99", "#FFFF99", "#999999", "#FFCC33", "#FF6633", "#FF3333", "#FF3366", "#FF33CC", "#FF33FF", "#CC33FF", "#6633FF", "#3366FF", "#33CCFF", "#33FFFF", "#33FFCC", "#33FF33", "#CCFF33", "#FFFF33", "#666666", "#FF9900", "#FF6600", "#FF0000", "#FF0066", "#FF0099", "#FF00FF", "#9900FF", "#6600FF", "#0000FF", "#0099FF", "#00FFFF", "#00FF99", "#00FF00", "#99FF00", "#FFFF00", "#333333", "#CC6600", "#CC3300", "#CC0000", "#CC0033", "#CC0066", "#CC00CC", "#6600CC", "#3300CC", "#0033CC", "#0066CC", "#00CCCC", "#00CC66", "#00CC00", "#66CC00", "#CCCC00", "#000000", "#663300", "#660000", "#660000", "#400010", "#660033", "#660066", "#330066", "#000066", "#000066", "#003366", "#006666", "#006633", "#336600", "#336600", "#666600"};
    private static final String[] _143HEX = new String[]{"#FFFFFF", "#FFD6D6", "#FFDED6", "#FFEFD6", "#F7FFD6", "#EFFFD6", "#D6FFD6", "#D6FFFF", "#D6F7FF", "#D6D6FF", "#EFD6FF", "#FFD6FF", "#FFD6EF", "#D6D6D6", "#FFA5A5", "#FFBDA5", "#FFD6A5", "#FFFF94", "#D6FF94", "#A5FFA5", "#A5FFFF", "#A5E7FF", "#A5A5FF", "#D6A5FF", "#FFA5FF", "#FFA5D6", "#B5B5B5", "#FF8484", "#FF9473", "#FFB563", "#FFFF42", "#C6FF63", "#73FF73", "#73FFFF", "#84D6FF", "#8484FF", "#C684FF", "#FF73FF", "#FF84C6", "#949494", "#FF5252", "#FF7342", "#FF9C31", "#F7F700", "#9CFF00", "#52FF52", "#00F7F7", "#52C6FF", "#6363FF", "#AD52FF", "#FF42FF", "#FF52AD", "#636363", "#FF2121", "#FF4200", "#E77300", "#C6C600", "#84D600", "#00E700", "#00D6D6", "#00ADFF", "#3131FF", "#9421FF", "#FF00FF", "#FF2194", "#525252", "#FF0000", "#E73900", "#D66B00", "#B5B500", "#73C600", "#00D600", "#00C6C6", "#0094E7", "#2121FF", "#8400FF", "#E700E7", "#FF0084", "#424242", "#E70000", "#C63100", "#B55A00", "#A5A500", "#63A500", "#00B500", "#00A5A5", "#0084C6", "#0000FF", "#7300E7", "#C600C6", "#E70073", "#313131", "#C60000", "#A52900", "#A55200", "#949400", "#5A9400", "#00A500", "#009494", "#006BA5", "#0000D6", "#6300C6", "#A500A5", "#C60063", "#212121", "#940000", "#942100", "#844200", "#737300", "#528400", "#008400", "#008484", "#006394", "#0000A5", "#4A0094", "#940094", "#94004A", "#101010", "#730000", "#731800", "#633100", "#636300", "#396300", "#006300", "#006363", "#004A73", "#000084", "#390073", "#730073", "#730039", "#000000", "#520000", "#521000", "#522900", "#525200", "#315200", "#005200", "#005252", "#003152", "#000052", "#290052", "#520052", "#520029"};
    private static final String[] _216HEX = new String[]{"#FFFFFF", "#FFFFCC", "#FFFF99", "#FFFF66", "#FFFF33", "#FFFF00", "#FFCCFF", "#FFCCCC", "#FFCC99", "#FFCC66", "#FFCC33", "#FFCC00", "#FF99FF", "#FF99CC", "#FF9999", "#FF9966", "#FF9933", "#FF9900", "#FF66FF", "#FF66CC", "#FF6699", "#FF6666", "#FF6633", "#FF6600", "#FF33FF", "#FF33CC", "#FF3399", "#FF3366", "#FF3333", "#FF3300", "#FF00FF", "#FF00CC", "#FF0099", "#FF0066", "#FF0033", "#FF0000", "#CCFFFF", "#CCFFCC", "#CCFF99", "#CCFF66", "#CCFF33", "#CCFF00", "#CCCCFF", "#CCCCCC", "#CCCC99", "#CCCC66", "#CCCC33", "#CCCC00", "#CC99FF", "#CC99CC", "#CC9999", "#CC9966", "#CC9933", "#CC9900", "#CC66FF", "#CC66CC", "#CC6699", "#CC6666", "#CC6633", "#CC6600", "#CC33FF", "#CC33CC", "#CC3399", "#CC3366", "#CC3333", "#CC3300", "#CC00FF", "#CC00CC", "#CC0099", "#CC0066", "#CC0033", "#CC0000", "#99FFFF", "#99FFCC", "#99FF99", "#99FF66", "#99FF33", "#99FF00", "#99CCFF", "#99CCCC", "#99CC99", "#99CC66", "#99CC33", "#99CC00", "#9999FF", "#9999CC", "#999999", "#999966", "#999933", "#999900", "#9966FF", "#9966CC", "#996699", "#996666", "#996633", "#996600", "#9933FF", "#9933CC", "#993399", "#993366", "#993333", "#993300", "#9900FF", "#9900CC", "#990099", "#990066", "#990033", "#990000", "#66FFFF", "#66FFCC", "#66FF99", "#66FF66", "#66FF33", "#66FF00", "#66CCFF", "#66CCCC", "#66CC99", "#66CC66", "#66CC33", "#66CC00", "#6699FF", "#6699CC", "#669999", "#669966", "#669933", "#669900", "#6666FF", "#6666CC", "#666699", "#666666", "#666633", "#666600", "#6633FF", "#6633CC", "#663399", "#663366", "#663333", "#663300", "#6600FF", "#6600CC", "#660099", "#660066", "#660033", "#660000", "#33FFFF", "#33FFCC", "#33FF99", "#33FF66", "#33FF33", "#33FF00", "#33CCFF", "#33CCCC", "#33CC99", "#33CC66", "#33CC33", "#33CC00", "#3399FF", "#3399CC", "#339999", "#339966", "#339933", "#339900", "#3366FF", "#3366CC", "#336699", "#336666", "#336633", "#336600", "#3333FF", "#3333CC", "#333399", "#333366", "#333333", "#333300", "#3300FF", "#3300CC", "#330099", "#330066", "#330033", "#330000", "#00FFFF", "#00FFCC", "#00FF99", "#00FF66", "#00FF33", "#00FF00", "#00CCFF", "#00CCCC", "#00CC99", "#00CC66", "#00CC33", "#00CC00", "#0099FF", "#0099CC", "#009999", "#009966", "#009933", "#009900", "#0066FF", "#0066CC", "#006699", "#006666", "#006633", "#006600", "#0033FF", "#0033CC", "#003399", "#003366", "#003333", "#003300", "#0000FF", "#0000CC", "#000099", "#000066", "#000033", "#000000", "#000000", "#000000", "#000000", "#000000", "#000000", "#000000", "#000000", "#000000"};
    private static final String[] _OLD_DEFAULTHEX = new String[]{"#990033", "#FF3366", "#CC0033", "#FF0033", "#FF0033", "#FF9999", "#CC3366", "#FFCCFF", "#CC3399", "#993366", "#993366", "#660033", "#CC3399", "#FF99CC", "#FF66CC", "#FF99FF", "#FF6699", "#CC0066", "#FF0066", "#FF3399", "#FF0099", "#FF33CC", "#FF00CC", "#FF66FF", "#FF33FF", "#FF00FF", "#CC0099", "#990066", "#CC66CC", "#CC33CC", "#CC99FF", "#CC66FF", "#CC33FF", "#993399", "#CC00CC", "#CC00FF", "#9900CC", "#990099", "#CC99CC", "#996699", "#663366", "#660099", "#9933CC", "#660066", "#9900FF", "#9933FF", "#9966CC", "#330033", "#663399", "#6696CC", "#6600CC", "#9966FF", "#330066", "#6600FF", "#6633FF", "#CCCCFF", "#9999FF", "#9999CC", "#6666CC", "#6666FF", "#666699", "#333366", "#333399", "#330099", "#3300CC", "#3300FF", "#3333FF", "#3333CC", "#0066FF", "#0066FF", "#3366FF", "#3366CC", "#000066", "#000033", "#0000FF", "#000099", "#0033CC", "#0000CC", "#336699", "#0066CC", "#99CCFF", "#6699FF", "#003366", "#6699CC", "#006699", "#3399CC", "#0099CC", "#66CCFF", "#3399FF", "#003399", "#0099FF", "#33CCFF", "#00CCFF", "#99FFFF", "#66FFFF", "#33FFFF", "#00FFFF", "#00CCCC", "#009999", "#669999", "#99CCCC", "#CCFFFF", "#33CCCC", "#66CCCC", "#339999", "#336666", "#006666", "#003333", "#00FFCC", "#33FFCC", "#33CC99", "#00CC99", "#66FFCC", "#99FFCC", "#00FF99", "#339966", "#006633", "#336633", "#669966", "#66CC66", "#99CC99", "#66FF66", "#339933", "#99CC99", "#66FF99", "#33FF99", "#33CC66", "#00CC66", "#66CC99", "#009966", "#009933", "#99CC99", "#00CC66", "#CCFFCC", "#CCFF99", "#99FF66", "#99FF33", "#00FF33", "#33FF33", "#00CC33", "#33CC33", "#66CC33", "#00FF00", "#66CC33", "#006600", "#003300", "#009900", "#33FF00", "#66FF00", "#99FF00", "#66CC00", "#00CC00", "#33CC00", "#339900", "#99CC66", "#669933", "#99CC33", "#336600", "#669900", "#99CC00", "#CCFF66", "#CCFF33", "#CCFF00", "#999900", "#CCCC00", "#CCCC33", "#333300", "#666600", "#999933", "#CCCC66", "#666633", "#999966", "#CCCC99", "#FFFFCC", "#FFFF99", "#FFFF66", "#FFFF33", "#FFFF00", "#FFCC00", "#FFCC66", "#FFCC33", "#CC9933", "#996600", "#CC9900", "#FF9900", "#CC6600", "#993300", "#CC6633", "#663300", "#FF9966", "#FF6633", "#FF9933", "#FF6600", "#CC3300", "#996633", "#330000", "#663333", "#996666", "#CC9999", "#993333", "#CC6666", "#FFCCCC", "#CC3333", "#CC3333", "#FF6666", "#660000", "#990000", "#CC0000", "#FF0000", "#FF3300", "#CC9966", "#FFCC99", "#FFFFFF", "#CCCCCC", "#999999", "#666666", "#333333", "#000000", "#F7F7E7", "#FFFFFF", "#FFFFFF", "#FFFFFF", "#FFFFFF", "#FFFFFF"};
    private static final String[] _256HEX = new String[]{"#FFFFFF", "#C6C6C6", "#848484", "#000000", "#FF0000", "#FFFF00", "#00FF00", "#00F7F7", "#0000FF", "#FF00FF", "#840000", "#848400", "#008400", "#008484", "#000084", "#840084", "#F7F7F7", "#FFD6D6", "#FFDED6", "#FFEFD6", "#FFF7D6", "#F7FFD6", "#E7FFD6", "#D6FFD6", "#D6FFEF", "#D6FFFF", "#D6F7FF", "#D6E7FF", "#D6D6FF", "#EFD6FF", "#FFD6FF", "#FFD6EF", "#E7E7E7", "#FFB5B5", "#FFC6B5", "#FFDEB5", "#FFEFB5", "#FFFFB5", "#E7FFB5", "#B5FFB5", "#B5FFDE", "#B5FFFF", "#B5E7FF", "#C6D6FF", "#C6C6FF", "#DEB5FF", "#FFB5FF", "#FFB5DE", "#D6D6D6", "#FFA5A5", "#FFBDA5", "#FFD6A5", "#FFE794", "#FFFF94", "#D6FF94", "#A5FFA5", "#A5FFD6", "#A5FFFF", "#A5E7FF", "#A5C6FF", "#A5A5FF", "#D6A5FF", "#FFA5FF", "#FFA5D6", "#C6C6C6", "#FF9494", "#FFA584", "#FFC684", "#FFDE73", "#FFFF73", "#D6FF84", "#94FF94", "#94FFCE", "#84FFFF", "#94DEFF", "#94B5FF", "#9494FF", "#CE94FF", "#FF84FF", "#FF94CE", "#B5B5B5", "#FF8484", "#FF9473", "#FFB563", "#FFDE63", "#FFFF42", "#C6FF63", "#73FF73", "#73FFBD", "#73FFFF", "#84D6FF", "#84ADFF", "#8484FF", "#C684FF", "#FF73FF", "#FF84C6", "#A5A5A5", "#FF6363", "#FF7B52", "#FFAD52", "#FFD642", "#FFFF00", "#B5FF42", "#63FF63", "#63FFB5", "#52FFFF", "#63CEFF", "#73A5FF", "#7373FF", "#B563FF", "#FF52FF", "#FF63B5", "#949494", "#FF5252", "#FF7342", "#FF9C31", "#FFC600", "#F7F700", "#9CFF00", "#52FF52", "#52FFAD", "#00FFFF", "#52C6FF", "#528CFF", "#6363FF", "#AD52FF", "#FF42FF", "#FF52AD", "#737373", "#FF4242", "#FF5A21", "#FF8400", "#F7B500", "#E7E700", "#94F700", "#00FF00", "#00FF84", "#00F7F7", "#42C6FF", "#4284FF", "#5252FF", "#A542FF", "#FF21FF", "#FF42A5", "#636363", "#FF2121", "#FF4200", "#E77300", "#D69C00", "#C6C600", "#84D600", "#00E700", "#00E773", "#00D6D6", "#00ADFF", "#3173FF", "#3131FF", "#9421FF", "#FF00FF", "#FF2194", "#525252", "#FF0000", "#E73900", "#D66B00", "#C69400", "#B5B500", "#73C600", "#00D600", "#00D66B", "#00C6C6", "#0094E7", "#0052FF", "#2121FF", "#8400FF", "#E700E7", "#FF0084", "#424242", "#E70000", "#C63100", "#B55A00", "#A57B00", "#A5A500", "#63A500", "#00B500", "#00B55A", "#00A5A5", "#0084C6", "#004AE7", "#0000FF", "#7300E7", "#C600C6", "#E70073", "#313131", "#C60000", "#A52900", "#A55200", "#946B00", "#949400", "#5A9400", "#00A500", "#00A552", "#009494", "#006BA5", "#0042C6", "#0000D6", "#6300C6", "#A500A5", "#C60063", "#212121", "#940000", "#942100", "#844200", "#846300", "#737300", "#528400", "#008400", "#008442", "#008484", "#006394", "#003194", "#0000A5", "#4A0094", "#940094", "#94004A", "#101010", "#730000", "#731800", "#633100", "#634A00", "#636300", "#396300", "#006300", "#006331", "#006363", "#004A73", "#002173", "#000084", "#390073", "#730073", "#730039", "#000000", "#520000", "#521000", "#522900", "#523900", "#525200", "#315200", "#005200", "#005229", "#005252", "#003152", "#001852", "#000052", "#290052", "#520052", "#520029"};
    private static Color[][] _sCSSPalette;
    private static Color[][] _s16Palette;
    private static Color[][] _s49Palette;
    private static Color[][] _sOld49Palette;
    private static Color[][] _s72Palette;
    private static Color[][] _s80Palette;
    private static Color[][] _s96Palette;
    private static Color[][] _s143Palette;
    private static Color[][] _s216Palette;
    private static Color[][] _sOldDefaultPalette;
    private static Color[][] _s256Palette;
    private static Painter _sSelectedColorPainter;

    ColorPickerUtils() {
    }

    public static final Insets getDefaultButtonMargin() {
        return UIManager.getInsets("EWTColorChoice.margin");
    }

    public static final void copyModel(TwoDModel source, TwoDModel destination) {
        int columns = source.getColumnCount();
        int rows = source.getRowCount();
        for (int i = 0; i < columns; ++i) {
            for (int j = 0; j < rows; ++j) {
                destination.setData(i, j, source.getData(i, j));
            }
        }
    }

    public static final void paintFocus(Graphics g, int x, int y, int width, int height) {
        ColorPickerUtils._drawFocusLine(g, x, y, width);
        ColorPickerUtils._drawFocusLine(g, x, y + height - 1, width);
    }

    public static final Painter getSelectedColorPainter() {
        if (_sSelectedColorPainter == null) {
            _sSelectedColorPainter = new SelectedColorPainter();
        }
        return _sSelectedColorPainter;
    }

    public static final ImageFilter createColorFilter(Color colorToFilter) {
        return new ColorFilter(colorToFilter);
    }

    public static final Image createFilteredImage(Image image, ImageFilter filter, Color colorToReplace) {
        if (filter instanceof ColorFilter) {
            ((ColorFilter)filter).setColor(colorToReplace);
        }
        return ImageUtils.createFilteredImage(image, filter);
    }

    public static final Color[][] getCSS16ColorPalette() {
        if (_sCSSPalette == null) {
            _sCSSPalette = ColorPickerUtils._createPalette(4, 4, _CSS16HEX);
        }
        return _sCSSPalette;
    }

    public static final Color[][] get16ColorPalette() {
        if (_s16Palette == null) {
            _s16Palette = ColorPickerUtils._createPalette(8, 2, _16HEX);
        }
        return _s16Palette;
    }

    public static final Color[][] get49ColorPalette() {
        if (_s49Palette == null) {
            _s49Palette = ColorPickerUtils._createPalette(7, 7, _49HEX);
        }
        return _s49Palette;
    }

    public static final Color[][] get72ColorPalette() {
        if (_s72Palette == null) {
            _s72Palette = ColorPickerUtils._createPalette(9, 8, _72HEX);
        }
        return _s72Palette;
    }

    public static final Color[][] get80ColorPalette() {
        if (_s80Palette == null) {
            _s80Palette = ColorPickerUtils._createPalette(10, 8, _80HEX);
        }
        return _s80Palette;
    }

    public static final Color[][] getOlaf96ColorPalette() {
        if (_s96Palette == null) {
            _s96Palette = ColorPickerUtils._createPalette(16, 6, _96HEX);
        }
        return _s96Palette;
    }

    public static final Color[][] get143ColorPalette() {
        if (_s143Palette == null) {
            _s143Palette = ColorPickerUtils._createPalette(13, 11, _143HEX);
        }
        return _s143Palette;
    }

    public static final Color[][] getWebSafe216ColorPalette() {
        if (_s216Palette == null) {
            _s216Palette = ColorPickerUtils._createPalette(16, 14, _216HEX);
        }
        return _s216Palette;
    }

    public static final Color[][] get256ColorPalette() {
        if (_s256Palette == null) {
            _s256Palette = ColorPickerUtils._createPalette(16, 16, _256HEX);
        }
        return _s256Palette;
    }

    public static final boolean isColorInOldPalettes(int type, Color c) {
        if (c == null) {
            return false;
        }
        Color[][] palette = null;
        if (type == 2) {
            if (_sOld49Palette == null) {
                _sOld49Palette = ColorPickerUtils._createPalette(7, 7, _OLD_49HEX);
            }
            palette = _sOld49Palette;
        } else if (type == 0) {
            if (_sOldDefaultPalette == null) {
                _sOldDefaultPalette = ColorPickerUtils._createPalette(16, 14, _OLD_DEFAULTHEX);
            }
            palette = _sOldDefaultPalette;
        }
        if (palette == null) {
            return false;
        }
        for (int i = 0; i < palette.length; ++i) {
            for (int j = 0; j < palette[i].length; ++j) {
                if (!c.equals(palette[i][j])) continue;
                return true;
            }
        }
        return false;
    }

    private static void _drawFocusLine(Graphics g, int x, int y, int width) {
        int numDashes = width / 3;
        int intWidth = numDashes * 3;
        int endX = x + intWidth;
        while (x < endX) {
            g.drawLine(x, y, x + 1, y);
            x += 3;
        }
        if ((width -= intWidth) > 0) {
            if (width > 2) {
                width = 2;
            }
            g.drawLine(x, y, x + width - 1, y);
        }
    }

    private static Color[][] _createPalette(int columns, int rows, String[] html) {
        Color[][] palette = new Color[rows][columns];
        int index = 0;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                String hex = html[index];
                palette[i][j] = ColorUtils.htmlToColor(hex);
                ++index;
            }
        }
        return palette;
    }

    private static class SelectedColorPainter
    extends AbstractPainter {
        private static final Dimension _SIZE = new Dimension(13, 13);

        private SelectedColorPainter() {
        }

        @Override
        public Dimension getMinimumSize(PaintContext context) {
            return _SIZE;
        }

        @Override
        public int getRepaintFlags(PaintContext context) {
            return 1024;
        }

        @Override
        public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
            int y1;
            Color oldColor = g.getColor();
            Color selectedColor = context.getPaintForeground();
            int x1 = x;
            int y2 = y1 = y + height / 2;
            while (x1 < x + width) {
                if (y1 != y2) {
                    g.setColor(selectedColor);
                    g.drawLine(x1, y1 + 1, x1, y2 - 1);
                }
                g.setColor(Color.black);
                g.drawLine(x1, y1, x1, y1);
                if (y1 != y2) {
                    g.drawLine(x1, y2, x1, y2);
                }
                if (++x1 <= x + width / 2) {
                    --y1;
                    ++y2;
                    continue;
                }
                ++y1;
                --y2;
            }
            g.setColor(oldColor);
        }
    }

    private static class ColorFilter
    extends RGBImageFilter {
        private int _color;
        private int _colorToFilter;

        public ColorFilter(Color colorToFilter) {
            this._colorToFilter = colorToFilter == null ? 0 : colorToFilter.getRGB();
            this.canFilterIndexColorModel = true;
        }

        public void setColor(Color c) {
            this._color = c == null ? 0 : c.getRGB();
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            if (rgb == this._colorToFilter) {
                return this._color;
            }
            return rgb;
        }
    }
}

