/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;
import java.text.MessageFormat;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.border.BorderAdapter;
import oracle.bali.ewt.chooser.color.BaseColorEditor;
import oracle.bali.ewt.chooser.color.ColorPickerUtils;
import oracle.bali.ewt.imageCanvas.ImageCanvas;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.FixedBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.share.util.IntegerUtils;

class ImageComponent
extends BaseColorEditor {
    private static final String _KEY_LABEL = "COLORCHOOSER.COLOR_SELECTOR";
    private static final String _KEY_BRI_DESC = "COLORCHOOSER.BRIGHTNESS_DESCRIPTION";
    private static final String _KEY_COLOR_VALUE = "COLORPALETTE.TOOLTIP";
    private static final int _WIDTH = 175;
    private static final int _HEIGHT = 175;
    private static final int _RIGHT = 174;
    private static final int _BOTTOM = 174;
    private static final int _IMAGE_SIZE = 30625;
    private static final int _BRI_WIDTH = 19;
    private static final int _BRI_IMAGE_SIZE = 3325;
    private static final int _GAUGE_WIDTH = 5;
    private static final int _HALF_ARROW_HEIGHT = 4;
    private static final Dimension _SIZE_GAUGE = new Dimension(5, 183);
    private static final int _MIN_BRI_VALUE = 0;
    private static final int _MAX_BRI_VALUE = 100;
    private static final int _IMAGE_CANVAS = 0;
    private static final int _BRI_CANVAS = 1;
    private static final int _BRI_COMP = 2;
    private static final Border[] _BORDER = new Border[3];
    private static final String _COLOR_CANVAS_NAME = "All_Colors_Canvas";
    private static final String _BRIGHTNESS_SLIDER_NAME = "Brightness_Selector_Slider";
    private float _x = 0.0f;
    private float _y = 0.0f;
    private float _brightness = 174.0f;
    private JLabel _label = new JLabel("");
    private Canvas _imageCanvas = new Canvas();
    private BrightnessComponent _briComponent;

    public ImageComponent() {
        this._label.setLabelFor(this._imageCanvas);
        this._imageCanvas.setName(_COLOR_CANVAS_NAME);
        this._briComponent = new BrightnessComponent();
        this._briComponent.setName(_BRIGHTNESS_SLIDER_NAME);
        JPanel content = new JPanel(new BorderLayout(1, 0));
        content.add((Component)this._imageCanvas, "West");
        content.add((Component)this._briComponent, "Center");
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)content, "North");
        this.setLayout(new BorderLayout(0, 3));
        this.add((Component)this._label, "North");
        this.add((Component)temp, "West");
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._label.setEnabled(enabled);
        this._imageCanvas.setEnabled(enabled);
        this._briComponent.setEnabled(enabled);
    }

    @Override
    protected void colorChanged(Color newColor) {
        this._updateLocation(newColor);
    }

    @Override
    protected void updateLabels(Locale newLocale) {
        String translatedText = ImageComponent.__getTranslatedString(newLocale, _KEY_LABEL);
        this._label.setText(StringUtils.stripMnemonic((String)translatedText));
        this._label.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
    }

    @Override
    protected void updateAccessibleNames() {
        String accName = this.__getTranslatedString(_KEY_BRI_DESC);
        this._briComponent.getAccessibleContext().setAccessibleName(accName);
    }

    int __getImageCanvasWidth() {
        return this._imageCanvas.getPreferredSize().width;
    }

    private static Border _getBorder(int index) {
        Border border = _BORDER[index];
        if (border == null) {
            AbstractBorderPainter painter = null;
            if (index == 0) {
                painter = new FocusPainter(new FixedBorderPainter(new ImageCanvasBorder(), 3, 0, 2, 0));
            } else if (index == 1) {
                painter = new FixedBorderPainter(new BrightnessCanvasBorder(), 3, 0, 2, 0);
            } else if (index == 2) {
                painter = new FocusPainter(null);
            }
            ImageComponent._BORDER[index] = border = new BorderAdapter(painter);
        }
        return border;
    }

    private boolean _updateColor(Object source, float x, float y) {
        if (y < 0.0f) {
            y = 0.0f;
        } else if (y > 174.0f) {
            y = 174.0f;
        }
        if (source == this._imageCanvas) {
            if (x < 0.0f) {
                x = 0.0f;
            } else if (x > 174.0f) {
                x = 174.0f;
            }
        }
        if (source == this._imageCanvas && x == this._x && y == this._y || source == this._briComponent && y == this._brightness) {
            return false;
        }
        String oldAccName = this._imageCanvas.getCurrentAccessibleName();
        float oldBri = this._brightness;
        if (source == this._imageCanvas) {
            this._x = x;
            this._y = y;
        } else {
            this._brightness = y;
        }
        Color c = Color.getHSBColor(1.0f - this._x / 174.0f, this._y / 174.0f, 1.0f - this._brightness / 174.0f);
        this.storeColor(c);
        if (source == this._imageCanvas) {
            String newAccName = this._imageCanvas.getCurrentAccessibleName();
            this._imageCanvas.fireAccessibleEvent(oldAccName, newAccName);
            this._imageCanvas.repaint();
            this._briComponent.setBrightnessImage();
        } else {
            this._briComponent.fireAccessibleEvent(oldBri, this._brightness);
            this._briComponent.repaint();
        }
        return true;
    }

    private void _updateLocation(Color c) {
        float oldX = this._x;
        float oldY = this._y;
        float oldBri = this._brightness;
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        this._x = 174.0f - hsb[0] * 174.0f;
        this._y = hsb[1] * 174.0f;
        this._brightness = 174.0f - hsb[2] * 174.0f;
        if (oldX != this._x || oldY != this._y) {
            this._imageCanvas.repaint();
            this._briComponent.setBrightnessImage();
        }
        if (oldBri != this._brightness) {
            this._briComponent.repaint();
        }
    }

    private void _handleKeyEvent(KeyEvent ke) {
        if (ke.getID() != 401 || ke.isConsumed() || !this.isEnabled() || ke.getModifiers() != 0) {
            return;
        }
        Component source = ke.getComponent();
        float x = this._x;
        float y = source == this._imageCanvas ? this._y : this._brightness;
        switch (ke.getKeyCode()) {
            case 38: {
                y -= 1.0f;
                break;
            }
            case 40: {
                y += 1.0f;
                break;
            }
            case 37: {
                if (source == this._imageCanvas) {
                    x -= 1.0f;
                    break;
                }
                return;
            }
            case 39: {
                if (source == this._imageCanvas) {
                    x += 1.0f;
                    break;
                }
                return;
            }
            default: {
                return;
            }
        }
        if (this._updateColor(source, x, y)) {
            ke.consume();
        }
    }

    private void _handleMouseEvents(MouseEvent me) {
        int id = me.getID();
        if (id != 501 && id != 506 && id != 502 || !SwingUtilities.isLeftMouseButton(me) || !this.isEnabled() || me.isConsumed()) {
            return;
        }
        Component source = me.getComponent();
        int x = me.getX();
        int y = me.getY();
        Insets inset = this._getImageInset();
        x -= inset.left;
        y -= inset.top;
        if (id == 501 && !source.hasFocus()) {
            source.requestFocus();
        }
        if (this._updateColor(source, x, y)) {
            me.consume();
        }
    }

    private Insets _getImageInset() {
        return this._imageCanvas.getInsets();
    }

    private class BrightnessComponent
    extends LWComponent
    implements Accessible {
        private ImageCanvas _briCanvas;
        private Gauge _briGauge = new Gauge();

        public BrightnessComponent() {
            this._briCanvas = new ImageCanvas();
            this._briCanvas.setBorder(ImageComponent._getBorder(1));
            this.setBorder(ImageComponent._getBorder(2));
            this.setBrightnessImage();
            this.setLayout(new BorderLayout());
            this.add((Component)this._briCanvas, "West");
            this.add((Component)this._briGauge, "Center");
            this.enableEvents(60L);
        }

        public void setBrightnessImage() {
            int[] pixels = new int[3325];
            int index = 0;
            float hue = 1.0f - ImageComponent.this._x / 174.0f;
            float sat = ImageComponent.this._y / 174.0f;
            float currBri = 1.0f;
            float step = 0.0057142857f;
            for (int y = 0; y < 175; ++y) {
                int pixel = Color.HSBtoRGB(hue, sat, currBri);
                for (int x = 0; x < 19; ++x) {
                    pixels[index++] = pixel;
                }
                currBri -= step;
            }
            MemoryImageSource source = new MemoryImageSource(19, 175, pixels, 0, 19);
            Image image = this.createImage(source);
            this._briCanvas.setImage(image);
        }

        public void fireAccessibleEvent(float oldBri, float newBri) {
            if (this.accessibleContext != null) {
                int oldValue = (int)((1.0f - oldBri / 174.0f) * 100.0f);
                int newValue = (int)((1.0f - newBri / 174.0f) * 100.0f);
                this.accessibleContext.firePropertyChange("AccessibleValue", IntegerUtils.getInteger((int)oldValue), IntegerUtils.getInteger((int)newValue));
            }
        }

        @Override
        public void setEnabled(boolean enable) {
            super.setEnabled(enable);
            this._briGauge.setEnabled(enable);
            this._briCanvas.setEnabled(enable);
        }

        @Override
        public boolean isFocusTraversable() {
            return true;
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new Access();
            }
            return this.accessibleContext;
        }

        @Override
        protected void processComponentKeyEvent(KeyEvent ke) {
            super.processComponentKeyEvent(ke);
            ImageComponent.this._handleKeyEvent(ke);
        }

        @Override
        protected void processMouseEvent(MouseEvent me) {
            super.processMouseEvent(me);
            ImageComponent.this._handleMouseEvents(me);
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent me) {
            super.processMouseMotionEvent(me);
            ImageComponent.this._handleMouseEvents(me);
        }

        @Override
        protected void processFocusEvent(FocusEvent fe) {
            super.processFocusEvent(fe);
            this.repaint();
        }

        private class Access
        extends JComponent.AccessibleJComponent
        implements AccessibleValue {
            private Access() {
                super(BrightnessComponent.this);
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.SLIDER;
            }

            @Override
            public AccessibleValue getAccessibleValue() {
                return this;
            }

            @Override
            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleStateSet states = super.getAccessibleStateSet();
                states.add(AccessibleState.VERTICAL);
                return states;
            }

            @Override
            public Number getCurrentAccessibleValue() {
                int value = (int)((1.0f - ImageComponent.this._brightness / 174.0f) * 100.0f);
                return IntegerUtils.getInteger((int)value);
            }

            @Override
            public Number getMaximumAccessibleValue() {
                return IntegerUtils.getInteger((int)100);
            }

            @Override
            public Number getMinimumAccessibleValue() {
                return IntegerUtils.getInteger((int)0);
            }

            @Override
            public boolean setCurrentAccessibleValue(Number n) {
                ImageComponent.this._updateColor(BrightnessComponent.this, ImageComponent.this._x, n.floatValue());
                return true;
            }
        }

        private class Gauge
        extends JPanel {
            public Gauge() {
                this.setPreferredSize(_SIZE_GAUGE);
            }

            @Override
            public void paintComponent(Graphics g) {
                Color oldColor = g.getColor();
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(Color.black);
                int y = (int)ImageComponent.this._brightness + 4;
                g.drawLine(0, y, 0, y);
                g.drawLine(1, y - 1, 1, y + 1);
                g.drawLine(2, y - 2, 2, y + 2);
                g.drawLine(3, y - 3, 3, y + 3);
                g.drawLine(4, y - 4, 4, y + 4);
                g.setColor(oldColor);
            }
        }
    }

    private class Canvas
    extends ImageCanvas {
        public Canvas() {
            this.setBorder(ImageComponent._getBorder(0));
            this.setImage(this._createImage());
            this.enableEvents(60L);
        }

        public String getCurrentAccessibleName() {
            if (this.accessibleContext != null) {
                return this.accessibleContext.getAccessibleName();
            }
            return null;
        }

        public void fireAccessibleEvent(String oldName, String newName) {
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleName", oldName, newName);
            }
        }

        @Override
        public void paintCanvasInterior(Graphics g) {
            super.paintCanvasInterior(g);
            Color oldColor = g.getColor();
            int x = (int)ImageComponent.this._x;
            int y = (int)ImageComponent.this._y;
            g.setColor(Color.black);
            g.fillRect(x - 1, y - 11, 3, 7);
            g.fillRect(x - 1, y + 5, 3, 7);
            g.fillRect(x - 9, y - 1, 7, 3);
            g.fillRect(x + 3, y - 1, 7, 3);
            g.setColor(oldColor);
        }

        @Override
        public boolean isFocusTraversable() {
            return true;
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new Access();
            }
            return this.accessibleContext;
        }

        @Override
        protected void processComponentKeyEvent(KeyEvent ke) {
            super.processComponentKeyEvent(ke);
            ImageComponent.this._handleKeyEvent(ke);
        }

        @Override
        protected void processMouseEvent(MouseEvent me) {
            super.processMouseEvent(me);
            ImageComponent.this._handleMouseEvents(me);
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent me) {
            super.processMouseMotionEvent(me);
            ImageComponent.this._handleMouseEvents(me);
        }

        @Override
        protected void processFocusEvent(FocusEvent fe) {
            super.processFocusEvent(fe);
            this.repaint();
        }

        private Image _createImage() {
            int[] pixels = new int[30625];
            int index = 0;
            float step = 0.0057142857f;
            float currSat = 0.0f;
            for (int y = 0; y < 175; ++y) {
                float currHue = 1.0f;
                for (int x = 0; x < 175; ++x) {
                    pixels[index++] = Color.HSBtoRGB(currHue, currSat, 1.0f);
                    currHue -= step;
                }
                currSat += step;
            }
            MemoryImageSource source = new MemoryImageSource(175, 175, pixels, 0, 175);
            return this.createImage(source);
        }

        private class Access
        extends ImageCanvas.AccessibleImageCanvas {
            private Access() {
                super(Canvas.this);
            }

            @Override
            public String getAccessibleName() {
                String accName = super.getAccessibleName();
                if (accName == null) {
                    accName = "";
                }
                String accPattern = ImageComponent.this.__getAccessTranslatedString(ImageComponent._KEY_COLOR_VALUE);
                Color c = ImageComponent.this.getColor();
                Object[] args = new Object[]{IntegerUtils.getInteger((int)c.getRed()), IntegerUtils.getInteger((int)c.getGreen()), IntegerUtils.getInteger((int)c.getBlue())};
                String colorValue = MessageFormat.format(accPattern, args);
                return accName + " " + colorValue;
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.PANEL;
            }
        }
    }

    private static class FocusPainter
    extends AbstractBorderPainter {
        private static final ImmInsets _INSET = new ImmInsets(2, 0, 2, 0);

        public FocusPainter(Painter wrappedPainter) {
            super(wrappedPainter);
        }

        @Override
        protected ImmInsets getOwnInsets(PaintContext context) {
            return _INSET;
        }

        @Override
        protected Painter getContentPainterAt(PaintContext context, int availableWidth, int availableHeight, int x, int y, Painter proxyPainter) {
            Painter contentPainter = super.getContentPainterAt(context, availableWidth, availableHeight, x, y, proxyPainter);
            if (proxyPainter == this && contentPainter != null || contentPainter == null && x >= 0 && y >= 0 && x < availableWidth && y < availableHeight) {
                contentPainter = this;
            }
            return contentPainter;
        }

        @Override
        protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
            if ((context.getPaintState() & 0x40) != 0) {
                Color oldColor = g.getColor();
                g.setColor(Color.black);
                ColorPickerUtils.paintFocus(g, x, y, width, height);
                g.setColor(oldColor);
            }
        }

        @Override
        protected boolean isBorderTransparent(PaintContext context) {
            return true;
        }

        @Override
        protected ImmInsets getOwnFillInsets(PaintContext context) {
            return ImmInsets.getEmptyInsets();
        }
    }

    private static class BrightnessCanvasBorder
    extends AbstractBorderPainter {
        private static final ImmInsets _INSET = new ImmInsets(1, 2, 2, 1);

        private BrightnessCanvasBorder() {
        }

        @Override
        protected ImmInsets getOwnInsets(PaintContext context) {
            return _INSET;
        }

        @Override
        protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
            Color oldColor = g.getColor();
            int state = context.getPaintState();
            boolean inactive = (state & 4) != 0;
            UIDefaults defaults = context.getPaintUIDefaults();
            Color controlShadow = defaults.getColor(LookAndFeel.CONTROL_SHADOW);
            Color control = defaults.getColor(LookAndFeel.CONTROL);
            int bottom = y + height - 1;
            int right = x + width - 1;
            g.setColor(inactive ? controlShadow : control);
            g.drawLine(x, y + 1, x, bottom - 1);
            g.setColor(inactive ? control : controlShadow);
            g.drawLine(x + 1, y + 1, x + 1, bottom - 1);
            g.setColor(inactive ? control : Color.white);
            g.drawLine(x + 2, bottom - 1, right - 1, bottom - 1);
            g.setColor(inactive ? controlShadow : control);
            g.drawLine(x + 1, bottom, right, bottom);
            if (inactive) {
                g.setColor(controlShadow);
                g.drawLine(x, y, x, y);
                g.drawLine(x, bottom, x, bottom);
            }
            g.setColor(inactive ? controlShadow : Color.white);
            g.drawLine(right, y, right, bottom - 1);
            g.setColor(controlShadow);
            g.drawLine(x + 1, y, right - 1, y);
            g.setColor(oldColor);
        }

        @Override
        protected boolean isBorderTransparent(PaintContext context) {
            return false;
        }

        @Override
        protected ImmInsets getOwnFillInsets(PaintContext context) {
            return ImmInsets.getEmptyInsets();
        }
    }

    private static class ImageCanvasBorder
    extends AbstractBorderPainter {
        private static final ImmInsets _INSET = new ImmInsets(1, 2, 2, 2);

        private ImageCanvasBorder() {
        }

        @Override
        protected ImmInsets getOwnInsets(PaintContext context) {
            return _INSET;
        }

        @Override
        protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
            Color oldColor = g.getColor();
            int state = context.getPaintState();
            boolean inactive = (state & 4) != 0;
            UIDefaults defaults = context.getPaintUIDefaults();
            Color controlShadow = defaults.getColor(LookAndFeel.CONTROL_SHADOW);
            Color controlDarkShadow = defaults.getColor(LookAndFeel.CONTROL_DK_SHADOW);
            Color control = defaults.getColor(LookAndFeel.CONTROL);
            int bottom = y + height - 1;
            int right = x + width - 1;
            g.setColor(controlShadow);
            g.drawLine(x, y, x, bottom);
            g.setColor(inactive ? control : controlDarkShadow);
            g.drawLine(x + 1, y + 1, x + 1, bottom - 1);
            g.setColor(control);
            g.drawLine(x + 2, bottom - 1, right - 1, bottom - 1);
            g.setColor(inactive ? controlShadow : Color.white);
            g.drawLine(x + 1, bottom, right, bottom);
            g.setColor(control);
            g.drawLine(right - 1, y + 1, right - 1, bottom - 2);
            g.setColor(inactive ? controlShadow : Color.white);
            g.drawLine(right, y + 1, right, bottom - 1);
            g.setColor(inactive ? controlShadow : controlDarkShadow);
            g.drawLine(x + 1, y, right - 2, y);
            g.setColor(controlShadow);
            if (inactive) {
                g.drawLine(right - 1, y, right, y);
            } else {
                g.drawLine(right - 1, y, right - 1, y);
            }
            g.setColor(oldColor);
        }

        @Override
        protected boolean isBorderTransparent(PaintContext context) {
            return false;
        }

        @Override
        protected ImmInsets getOwnFillInsets(PaintContext context) {
            return ImmInsets.getEmptyInsets();
        }
    }
}

