/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import java.awt.Dimension;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import javax.swing.Icon;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeExplicitParent;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeItemEvent;
import oracle.bali.ewt.dTree.DTreeItemValidateEvent;
import oracle.bali.ewt.dTree.DTreeSimpleChild;

public class DTreeSimpleParent
extends DTreeSimpleChild
implements DTreeExplicitParent {
    private static final long serialVersionUID = -7133055331596216079L;
    private DTreeItem[] _children;
    private int _nchildren;
    private transient int _subheight;
    private transient int _subwidth;
    private boolean _expanded;

    public DTreeSimpleParent(String label, Icon icon) {
        super(label, icon);
    }

    public final void addItem(DTreeItem item) {
        this.addItem(item, -1);
    }

    public final void addItem(DTreeItem item, int index) {
        if (item == null) {
            throw new NullPointerException();
        }
        DTreeItem[] itemarr = new DTreeItem[]{item};
        this.addItems(itemarr, index);
    }

    @Override
    public void addItems(DTreeItem[] items, int index) {
        int i;
        int count = items.length;
        if (count <= 0) {
            return;
        }
        int oldcount = this.getItemCount();
        if (index < 0 || index > oldcount) {
            index = oldcount;
        }
        if (this._children == null) {
            this._children = new DTreeItem[count];
        } else if (this._children.length < count + oldcount) {
            DTreeItem[] tmpchildren = new DTreeItem[count + oldcount];
            System.arraycopy(this._children, 0, tmpchildren, 0, index);
            System.arraycopy(this._children, index, tmpchildren, index + count, oldcount - index);
            this._children = tmpchildren;
        } else {
            System.arraycopy(this._children, index, this._children, index + count, oldcount - index);
        }
        System.arraycopy(items, 0, this._children, index, count);
        this._nchildren = oldcount + count;
        for (i = index; i < index + count; ++i) {
            this._children[i].itemAdded(this, i);
        }
        while (i < this._nchildren) {
            this._children[i].setIndex(i);
            ++i;
        }
        DTree tree = this.getTree();
        if (tree != null) {
            tree.itemsAdded(this, index, count);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DTreeSimpleParent newitem = (DTreeSimpleParent)super.clone();
        newitem._nchildren = 0;
        newitem.itemRemoved();
        DTreeItem[] newchildren = new DTreeItem[this._nchildren];
        for (int i = 0; i < this._nchildren; ++i) {
            DTreeItem newchild;
            newchildren[i] = newchild = (DTreeItem)this._children[i].clone();
            newchild.itemAdded(newitem, newchild.getIndex());
        }
        newitem._children = newchildren;
        newitem._nchildren = newchildren.length;
        return newitem;
    }

    @Override
    public DTreeItem getItem(int index) {
        if (index >= this._nchildren) {
            return null;
        }
        return this._children[index];
    }

    @Override
    public DTreeItem getItemAt(int x, int y) {
        int subheight = this.getSubTreeHeight();
        if (y > subheight) {
            return null;
        }
        int itemht = this.getSize().height;
        if (y < itemht) {
            return this;
        }
        if (this.isExpanded() && this._nchildren > 0) {
            int itemy = this.getY();
            for (int i = 0; i < this._nchildren; ++i) {
                DTreeItem child = this.getItem(i);
                int childy = child.getY() - itemy;
                if (y >= childy && y < childy + child.getSubTreeHeight()) {
                    return child.getItemAt(x, y - childy);
                }
                if (y >= childy) continue;
                return null;
            }
        }
        return null;
    }

    @Override
    public int getItemCount() {
        return this._nchildren;
    }

    @Override
    public DTreeItem getNextExpandedChild(DTreeItem child) {
        int i;
        int n = i = child == null ? 0 : child.getIndex() + 1;
        while (i < this._nchildren) {
            DTreeItem item = this._children[i];
            if (item.isExpanded()) {
                return item;
            }
            ++i;
        }
        return null;
    }

    @Override
    public int getSubTreeHeight() {
        return this._subheight;
    }

    @Override
    public int getSubTreeWidth() {
        return this._subwidth;
    }

    @Override
    public boolean isExpandable() {
        return this.getItemCount() > 0;
    }

    @Override
    public boolean isExpanded() {
        return this._expanded;
    }

    @Override
    public void layout(int x, int y) {
        super.layout(x, y);
        Dimension dim = this.getSize();
        int subht = dim.height;
        this._subwidth = dim.width;
        if (this._expanded && this._nchildren != 0) {
            DTreeItem parent = this.getParent();
            DTree tree = this.getTree();
            int indentwd = parent == null ? 0 : tree.getIndentWidth();
            int childx = x;
            int childy = y + this.getChildrenYOffset(subht);
            childx += this.getChildrenXOffset(indentwd);
            for (int i = 0; i < this._nchildren; ++i) {
                DTreeItem child = this.getItem(i);
                child.layout(childx, childy);
                childy += child.getSubTreeHeight();
                this._subwidth = Math.max(this._subwidth, child.getSubTreeWidth() + indentwd);
            }
            subht = childy - y;
        }
        this._subheight = subht;
    }

    @Override
    public void removeItems(int startIndex, int count) {
        int i;
        if (count == 0) {
            return;
        }
        for (i = startIndex; i < startIndex + count; ++i) {
            DTreeItem child = this._children[i];
            child.itemRemoved();
        }
        System.arraycopy(this._children, startIndex + count, this._children, startIndex, this._nchildren - (startIndex + count));
        this._nchildren -= count;
        for (i = startIndex; i < this._nchildren; ++i) {
            this._children[i].setIndex(i);
        }
        DTree tree = this.getTree();
        if (tree != null) {
            tree.itemsRemoved(this, startIndex, count);
        }
    }

    @Override
    public void setExpanded(boolean isExpanded) {
        if (isExpanded == this.isExpanded()) {
            return;
        }
        DTree tree = this.getTree();
        if (!this._fireExpansionChanging(tree, isExpanded)) {
            this._expanded = isExpanded;
            this._fireExpansionChanged(tree, isExpanded);
        }
    }

    protected int getChildrenXOffset(int indentWidth) {
        return indentWidth;
    }

    protected int getChildrenYOffset(int itemHeight) {
        return itemHeight;
    }

    protected void setSubTreeHeight(int subTreeHeight) {
        this._subheight = subTreeHeight;
    }

    private boolean _fireExpansionChanging(DTree tree, boolean isExpanded) {
        if (tree == null) {
            return false;
        }
        int evtID = isExpanded ? 2000 : 2002;
        DTreeItemValidateEvent evt = new DTreeItemValidateEvent(tree, evtID, this);
        tree.dispatchEvent(evt);
        return evt.isCancelled();
    }

    private void _fireExpansionChanged(DTree tree, boolean isExpanded) {
        if (tree == null) {
            return;
        }
        int evtID = isExpanded ? 2001 : 2003;
        DTreeItemEvent evt = new DTreeItemEvent(tree, evtID, this);
        tree.dispatchEvent(evt);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException, NotActiveException {
        ois.defaultReadObject();
        for (int i = 0; i < this._nchildren; ++i) {
            this._children[i].itemAdded(this, i);
        }
    }
}

