/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

public class PivotHeaderGridSeparator
extends AbstractPainter
implements UIResource {
    private boolean _horizontal;
    private static Painter _sHorizontal;
    private static Painter _sVertical;

    public static Painter getHorizontalSeparator() {
        if (_sHorizontal == null) {
            _sHorizontal = new PivotHeaderGridSeparator(true);
        }
        return _sHorizontal;
    }

    public static Painter getVerticalSeparator() {
        if (_sVertical == null) {
            _sVertical = new PivotHeaderGridSeparator(false);
        }
        return _sVertical;
    }

    @Override
    public Dimension getMinimumSize(PaintContext context) {
        return new Dimension(1, 1);
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        return 1;
    }

    @Override
    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        String key;
        Object data;
        Color savedColor = g.getColor();
        UIDefaults defaults = context.getPaintUIDefaults();
        int state = context.getPaintState();
        boolean enabled = (state & 1) == 0;
        Color color = null;
        if (enabled && (data = context.getPaintData(key = this._horizontal ? "horizontalSeparatorColor" : "verticalSeparatorColor")) instanceof Color) {
            color = (Color)data;
        }
        if (color == null) {
            color = (state & 4) == 0 ? defaults.getColor("EWTPivot.darkShadow") : defaults.getColor("controlShadow");
        }
        g.setColor(color);
        if (this._horizontal) {
            this._paintHorizontal(context, g, x, y, width, height, enabled);
        } else {
            this._paintVertical(context, g, x, y, width, height, enabled);
        }
        if (savedColor != null) {
            g.setColor(savedColor);
        }
    }

    private void _paintHorizontal(PaintContext context, Graphics g, int x, int y, int width, int height, boolean enabled) {
        int right = x + width - 1;
        if (enabled) {
            g.drawLine(x, y, right, y);
        } else {
            Color c = g.getColor();
            Color bg = context.getPaintUIDefaults().getColor("Grid.disabledBackground");
            for (int i = x; i <= right; i += 2) {
                g.setColor(c);
                g.drawLine(i, y, i, y);
                g.setColor(bg);
                g.drawLine(i + 1, y, i + 1, y);
            }
        }
    }

    private void _paintVertical(PaintContext context, Graphics g, int x, int y, int width, int height, boolean enabled) {
        int bottom = y + height - 1;
        if (enabled) {
            g.drawLine(x, y, x, bottom);
        } else {
            Color c = g.getColor();
            Color bg = context.getPaintUIDefaults().getColor("Grid.disabledBackground");
            for (int i = y; i <= bottom; i += 2) {
                g.setColor(c);
                g.drawLine(x, i, x, i);
                g.setColor(bg);
                g.drawLine(x, i + 1, x, i + 1);
            }
        }
    }

    private PivotHeaderGridSeparator(boolean horizontal) {
        this._horizontal = horizontal;
    }
}

