/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.motif;

import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicCheckBoxMenuItemUI;
import oracle.bali.ewt.elaf.EWTToggleMenuItemUI;
import oracle.bali.ewt.elaf.ToggleMenuItemUIUtils;

public class MotifEWTToggleMenuItemUI
extends BasicCheckBoxMenuItemUI
implements EWTToggleMenuItemUI {
    protected ChangeListener changeListener;

    public static ComponentUI createUI(JComponent c) {
        return new MotifEWTToggleMenuItemUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.changeListener = this.createChangeListener(this.menuItem);
        this.menuItem.addChangeListener(this.changeListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menuItem.removeChangeListener(this.changeListener);
    }

    protected ChangeListener createChangeListener(JComponent c) {
        return new ChangeHandler();
    }

    @Override
    protected void doClick(MenuSelectionManager msm) {
        ToggleMenuItemUIUtils.doClick(msm, this.menuItem, this.getPropertyPrefix() + ".commandSound");
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ToggleMenuItemUIUtils.installActionMap(this.menuItem);
    }

    @Override
    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new CustomMouseInputHandler();
    }

    protected class CustomMouseInputHandler
    implements MouseInputListener {
        protected CustomMouseInputHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.setSelectedPath(MotifEWTToggleMenuItemUI.this.getPath());
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            MenuSelectionManager.defaultManager().processMouseEvent(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            JMenuItem menuItem = (JMenuItem)e.getComponent();
            Point p = e.getPoint();
            if (p.x >= 0 && p.x < menuItem.getWidth() && p.y >= 0 && p.y < menuItem.getHeight()) {
                menuItem.doClick(0);
            } else {
                manager.processMouseEvent(e);
            }
        }
    }

    protected class ChangeHandler
    implements ChangeListener {
        protected ChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JMenuItem c = (JMenuItem)e.getSource();
            LookAndFeel.installProperty(c, "borderPainted", c.isArmed());
        }
    }
}

