/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.grid.Grid;

public abstract class CellInputHandler {
    public boolean validateFocus(Grid grid, int column, int row) {
        return true;
    }

    public void updateUI() {
    }

    public void mousePressed(MouseEvent mouseEvent, Grid grid, int column, int row) {
        boolean requestAccepted;
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && !(requestAccepted = grid.requestFocus(column, row, mouseEvent))) {
            mouseEvent.consume();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent, Grid grid, int column, int row) {
    }

    public void mouseReleased(MouseEvent mouseEvent, Grid grid, int column, int row) {
    }

    public void mouseEntered(MouseEvent mouseEvent, Grid grid, int column, int row) {
    }

    public void mouseExited(MouseEvent mouseEvent, Grid grid, int column, int row) {
    }

    public void mouseDragged(MouseEvent mouseEvent, Grid grid, int column, int row) {
    }

    public void mouseMoved(MouseEvent mouseEvent, Grid grid, int column, int row) {
    }

    public void keyPressed(KeyEvent keyEvent, Grid grid, int column, int row) {
        if (keyEvent.getKeyCode() == 113 && keyEvent.getModifiers() == 0) {
            grid.startCellEdit(column, row);
            keyEvent.consume();
        }
    }

    public void keyTyped(KeyEvent keyEvent, Grid grid, int column, int row) {
        grid.startCellEdit(column, row);
        keyEvent.consume();
    }

    public void keyReleased(KeyEvent keyEvent, Grid grid, int column, int row) {
    }

    public void focusGained(AWTEvent why, Grid grid, int column, int row) {
    }

    public void focusLost(AWTEvent why, Grid grid, int column, int row) {
    }

    public Component getEditControl(Grid grid, int column, int row) {
        return null;
    }

    public Rectangle getEditControlBounds(Grid grid, int column, int row) {
        return null;
    }

    public boolean isDirty(Grid grid, int column, int row) {
        return true;
    }

    public void startEdit(Grid grid, int column, int row, Object data) {
    }

    public void cancelEdit(Grid grid, int column, int row) {
    }

    public Object commitEdit(Grid grid, int column, int row) {
        return grid.getModel().getData(column, row);
    }

    public Component[] getFocusableComponents(Grid grid, int focusColumn, int focusRow) {
        Component editControl = this.getEditControl(grid, focusColumn, focusRow);
        if (editControl == null) {
            return new Component[0];
        }
        return new Component[]{editControl};
    }
}

