/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.UIManager;
import oracle.bali.ewt.elaf.EWTPivotGridGridUI;
import oracle.bali.ewt.elaf.EWTPivotGridHeaderUI;
import oracle.bali.ewt.elaf.EWTPivotGridUI;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.model.NullOneDModel;
import oracle.bali.ewt.model.NullTwoDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.model.TwoDModelAdapter;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.pivot.PivotGridLayout;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotTable;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.table.TableEvent;

public class PivotGrid
extends SpreadTable {
    private int _dragItem;
    private boolean _horizontal;
    private boolean _resizing;
    private PivotTable _pivotTable;
    private _DSListen _modelListener = new _DSListen();
    private PropertyChangeListener _focusChangeListener = new FocusChangeListener();

    public PivotGrid(TwoDModel ds) {
        Grid grid = this.getGrid();
        this.setModel(ds);
        grid.setUpperLeft(false);
        grid.setUpperRight(false);
        grid.setLowerLeft(false);
        grid.setLowerRight(true);
        GeneralGridSelectionManager sm = new GeneralGridSelectionManager(2, 2, 2);
        grid.setGridSelectionManager(sm);
        grid.setVerticalSeparatorsVisible(true);
        grid.setHorizontalSeparatorsVisible(true);
        grid.setDrawFocusCellHighlite(true);
        Header header = this.getColumnHeader();
        GeneralHeaderSelectionManager hsm = new GeneralHeaderSelectionManager(2);
        header.setHeaderSelectionManager(hsm);
        header.setCanMoveItems(false);
        header.addPropertyChangeListener(this._focusChangeListener);
        header = this.getRowHeader();
        hsm = new GeneralHeaderSelectionManager(2);
        header.setHeaderSelectionManager(hsm);
        header.setCanMoveItems(false);
        header.addPropertyChangeListener(this._focusChangeListener);
        this._dragItem = -1;
        this.updateUI();
    }

    @Override
    public void dispose() {
        this.setModel(null);
        this._modelListener = null;
        this._focusChangeListener = null;
        super.dispose();
    }

    @Override
    public String getUIClassID() {
        return "EWTPivotGridUI";
    }

    public final TwoDModel getModel() {
        return this.getGrid().getModel();
    }

    public void setModel(TwoDModel ds) {
        TwoDModel oldModel = this.getModel();
        if (oldModel != null) {
            oldModel.removeModelListener(this._modelListener);
        }
        if (ds == null) {
            ds = NullTwoDModel.getTwoDModel();
        }
        this.setModels(ds, new NullOneDModel(ds.getColumnCount()), new NullOneDModel(ds.getRowCount()));
        ds.addModelListener(this._modelListener);
    }

    public final AppearanceManager getAppearanceManager() {
        return this.getGrid().getAppearanceManager();
    }

    public final void setAppearanceManager(AppearanceManager manager) {
        this.getGrid().setAppearanceManager(manager);
    }

    public final PivotTable getPivotTable() {
        return this._pivotTable;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = this.getGrid().getPreferredSize();
        size.height += this.getColumnHeaderHeight();
        size.width += this.getRowHeaderWidth();
        return this.convertInnerToOuterSize(size.width, size.height);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = this.getGrid().getMinimumSize();
        size.height += this.getColumnHeaderHeight();
        size.width += this.getRowHeaderWidth();
        return this.convertInnerToOuterSize(size.width, size.height);
    }

    @Override
    public void updateUI() {
        this.setUI((EWTPivotGridUI)UIManager.getUI(this));
        this.getGrid().setOverlayBorderVisible(false);
        this.getGrid().setBorder(null);
        if (this.getPivotTable() != null) {
            this.updateLayout();
            this.getPivotTable().__updateHorizontalSizes();
            this.getPivotTable().__updateVerticalSizes();
        }
    }

    @Override
    public void setDrawRaised(boolean raised) {
        super.setDrawRaised(raised);
        this.getRowHeader().setDrawRaised(raised);
        this.getColumnHeader().setDrawRaised(raised);
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new PivotGridLayout();
    }

    @Override
    protected void processResizeEvent(TableEvent e) {
        super.processResizeEvent(e);
        if (e instanceof Cancelable && ((Cancelable)((Object)e)).isCancelled()) {
            return;
        }
        int id = e.getID();
        switch (id) {
            case 2001: {
                this._dragItem = e.getColumn();
                this._horizontal = true;
                break;
            }
            case 2003: {
                this._dragItem = e.getRow();
                this._horizontal = false;
                break;
            }
            case 2002: {
                this._dragItem = -1;
                break;
            }
            case 2004: {
                this._dragItem = -1;
            }
        }
        PivotTable table = this.getPivotTable();
        if (this._horizontal) {
            table.getColumnPivotHeader().setResizeItem(this._dragItem);
        } else {
            table.getRowPivotHeader().setResizeItem(this._dragItem);
        }
    }

    @Override
    protected boolean isSelectAllEnabled() {
        Grid grid = this.getGrid();
        return this.isColumnHeaderVisible() && this.isRowHeaderVisible() && grid.getColumnCount() != 0 && grid.getRowCount() != 0;
    }

    protected final EWTPivotGridUI getPivotGridUI() {
        return (EWTPivotGridUI)this.ui;
    }

    @Override
    protected final Header createColumnHeader(OneDModel model) {
        return this.createPivotGridColumnHeader(model);
    }

    protected PivotGridHeader createPivotGridColumnHeader(OneDModel model) {
        return new PivotGridHeader(model, 0);
    }

    @Override
    protected final Header createRowHeader(OneDModel model) {
        return this.createPivotGridRowHeader(model);
    }

    protected PivotGridHeader createPivotGridRowHeader(OneDModel model) {
        return new PivotGridHeader(model, 1);
    }

    @Override
    protected final Grid createGrid(TwoDModel model) {
        return this.createPivotGridGrid(model);
    }

    protected PivotGridGrid createPivotGridGrid(TwoDModel model) {
        return new PivotGridGrid(model);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
    }

    void setPivotTable(PivotTable table) {
        this._pivotTable = table;
    }

    void setCurrentlyResizing(boolean resizing) {
        this._resizing = resizing;
    }

    boolean currentlyResizing() {
        return this._resizing;
    }

    void checkColumnHeader(int newOriginX) {
        PivotTable table = this.getPivotTable();
        PivotHeader header = table.getColumnPivotHeader();
        int y = header.getGrid().getCanvasOriginY();
        header.getGrid().setCanvasOrigin(newOriginX, y);
    }

    void checkRowHeader(int newOriginY) {
        PivotTable table = this.getPivotTable();
        PivotHeader header = table.getRowPivotHeader();
        int x = header.getGrid().getCanvasOriginX();
        header.getGrid().setCanvasOrigin(x, newOriginY);
    }

    void updateFeedback() {
        if (this._dragItem != -1) {
            PivotTable table = this.getPivotTable();
            if (this._horizontal) {
                int width = this.getColumnHeader().getItemSize(this._dragItem);
                table.setColumnWidth(this._dragItem, width);
            } else {
                int height = this.getRowHeader().getItemSize(this._dragItem);
                table.setRowHeight(this._dragItem, height);
            }
        }
    }

    private class FocusChangeListener
    implements PropertyChangeListener {
        private FocusChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("focusItem".equals(evt.getPropertyName())) {
                // empty if block
            }
        }
    }

    private class _DSListen
    extends TwoDModelAdapter {
        private _DSListen() {
        }

        @Override
        public void rowsAdded(TwoDModelEvent e) {
            NullOneDModel ds = (NullOneDModel)PivotGrid.this.getRowHeader().getModel();
            ds.addItems(e.getRowStartIndex(), e.getRowCount());
        }

        @Override
        public void rowsRemoved(TwoDModelEvent e) {
            NullOneDModel ds = (NullOneDModel)PivotGrid.this.getRowHeader().getModel();
            ds.removeItems(e.getRowStartIndex(), e.getRowCount());
        }

        @Override
        public void columnsAdded(TwoDModelEvent e) {
            NullOneDModel ds = (NullOneDModel)PivotGrid.this.getColumnHeader().getModel();
            ds.addItems(e.getColumnStartIndex(), e.getColumnCount());
        }

        @Override
        public void columnsRemoved(TwoDModelEvent e) {
            NullOneDModel ds = (NullOneDModel)PivotGrid.this.getColumnHeader().getModel();
            ds.removeItems(e.getColumnStartIndex(), e.getColumnCount());
        }
    }

    public class PivotGridHeader
    extends Header {
        public PivotGridHeader(OneDModel ds, int orientation) {
            super(ds, orientation);
            this.updateUI();
        }

        @Override
        public String getUIClassID() {
            return "EWTPivotGridHeaderUI";
        }

        @Override
        public final void setCanvasOrigin(int x, int y) {
            if (!PivotGrid.this.currentlyResizing()) {
                super.setCanvasOrigin(x, y);
            }
        }

        @Override
        public final Insets getAutoscrollInsets() {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        protected final Component getScrollParent() {
            return this.getParent();
        }

        @Override
        protected final void paintExtraCanvas(Graphics g, PaintContext context, int x, int y, int width, int height) {
        }

        @Override
        protected final void processMouseMotionEvent(MouseEvent e) {
            PivotTable table = PivotGrid.this.getPivotTable();
            if (table != null) {
                table.freezeRepaints();
            }
            try {
                super.processMouseMotionEvent(e);
                if (e.getID() == 506) {
                    PivotGrid.this.updateFeedback();
                }
            }
            finally {
                if (table != null) {
                    table.unfreezeRepaints();
                }
            }
        }

        @Override
        public void updateUI() {
            this.setUI((EWTPivotGridHeaderUI)UIManager.getUI(this));
        }
    }

    public class PivotGridGrid
    extends Grid {
        public PivotGridGrid(TwoDModel ds) {
            super(ds);
            this.updateUI();
        }

        @Override
        public String getUIClassID() {
            return "EWTPivotGridGridUI";
        }

        @Override
        public final void updateUI() {
            this.setUI((EWTPivotGridGridUI)UIManager.getUI(this));
        }

        @Override
        public final Insets getAutoscrollInsets() {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        protected final Component getScrollParent() {
            return PivotGrid.this.getPivotTable() == null ? super.getScrollParent() : PivotGrid.this.getPivotTable();
        }

        @Override
        public final void setCanvasOrigin(int x, int y) {
            if (!PivotGrid.this.currentlyResizing()) {
                super.setCanvasOrigin(x, y);
            }
        }

        @Override
        public final void setVerticalSeparatorPainter(Painter painter) {
            super.setVerticalSeparatorPainter(painter);
            if (PivotGrid.this != null && PivotGrid.this.getPivotTable() != null) {
                PivotGrid.this.getPivotTable().__updateVerticalSizes();
            }
        }

        @Override
        public final void setVerticalSeparatorsVisible(boolean visible) {
            super.setVerticalSeparatorsVisible(visible);
            if (PivotGrid.this != null && PivotGrid.this.getPivotTable() != null) {
                PivotGrid.this.getPivotTable().__updateVerticalSizes();
            }
        }

        @Override
        public final void setHorizontalSeparatorPainter(Painter painter) {
            super.setHorizontalSeparatorPainter(painter);
            if (PivotGrid.this != null && PivotGrid.this.getPivotTable() != null) {
                PivotGrid.this.getPivotTable().__updateHorizontalSizes();
            }
        }

        @Override
        public final void setHorizontalSeparatorsVisible(boolean visible) {
            super.setHorizontalSeparatorsVisible(visible);
            if (PivotGrid.this != null && PivotGrid.this.getPivotTable() != null) {
                PivotGrid.this.getPivotTable().__updateHorizontalSizes();
            }
        }

        @Override
        public final Dimension layoutCanvas() {
            int beforeX = this.getCanvasOriginX();
            int beforeY = this.getCanvasOriginY();
            Dimension d = super.layoutCanvas();
            int afterX = this.getCanvasOriginX();
            int afterY = this.getCanvasOriginY();
            if (beforeX != afterX) {
                PivotGrid.this.checkColumnHeader(afterX);
            }
            if (beforeY != afterY) {
                PivotGrid.this.checkRowHeader(afterY);
            }
            return d;
        }
    }
}

