/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.print;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Dictionary;
import javax.swing.JComponent;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.painter.JPaintContext;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.PaintContextProxy;
import oracle.bali.ewt.print.PrinterUtils;
import oracle.bali.share.util.IntegerUtils;

public class PrintPaintContext
extends PaintContextProxy {
    private JComponent _printee;
    private Dictionary _printProperties;
    private transient PaintContext _printContext;
    private transient Graphics _printGraphics;
    private transient int _currPage;
    private transient int _currXPage;
    private transient int _currYPage;

    public PrintPaintContext(JComponent printee, Dictionary printProperties) {
        this._printee = printee;
        this._printProperties = printProperties;
    }

    public void updatePage(Graphics newGraphics, int newPageNum, int newXPage, int newYPage) {
        if (newGraphics == null) {
            throw new IllegalArgumentException();
        }
        this._printContext = this._printee instanceof LWComponent ? ((LWComponent)this._printee).getPrintPaintContext(newGraphics) : new JPaintContext(this._printee);
        this._printGraphics = newGraphics;
        this._currPage = newPageNum;
        this._currXPage = newXPage;
        this._currYPage = newYPage;
    }

    @Override
    public Color getSurroundingColor() {
        return Color.white;
    }

    @Override
    public Object getPaintData(Object key) {
        if (key == PrinterUtils.PAGE_KEY) {
            return IntegerUtils.getInteger((int)this._currPage);
        }
        if (key == PrinterUtils.XYPAGE_KEY) {
            return new Point(this._currXPage, this._currYPage);
        }
        Object result = null;
        if (this._printProperties != null && key != null) {
            result = this._printProperties.get(key);
        }
        if (result == null) {
            result = this.getPaintContext().getPaintData(key);
        }
        return result;
    }

    @Override
    protected PaintContext getPaintContext() {
        return this._printContext;
    }
}

