/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.config.setup;

import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import oracle.dbtools.common.config.Configurations;
import oracle.dbtools.common.config.ConfigurationsBuilder;
import oracle.dbtools.common.config.MutableConfigurations;
import oracle.dbtools.common.di.Factory;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Files;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.common.util.SortedProperties;
import oracle.dbtools.plugin.api.cmdline.CommandProvider;
import oracle.dbtools.plugin.api.cmdline.annotations.Command;
import oracle.dbtools.plugin.api.cmdline.annotations.Option;
import oracle.dbtools.plugin.api.conf.Configuration;
import oracle.dbtools.plugin.api.di.annotations.Provides;
import oracle.dbtools.plugin.api.i18n.annotations.TranslatableText;
import oracle.dbtools.rt.config.setup.ConfigurationBuilder;
import oracle.dbtools.rt.config.setup.InstallParams;
import oracle.dbtools.rt.config.setup.SchemaSetup;
import oracle.dbtools.rt.config.setup.Setting;
import oracle.dbtools.rt.config.setup.SetupMessages;

@Provides
@Command(name="setup", description=@TranslatableText(type=SetupMessages.class, id="DESCRIPTION"), options={@Option(name="database", description=@TranslatableText(type=SetupMessages.class, id="DB_OPTION")), @Option(name="parameterFile", description=@TranslatableText(type=SetupMessages.class, id="PARAMETERFILE")), @Option(name="logDir", description=@TranslatableText(type=SetupMessages.class, id="INSTALL_LOGDIR")), @Option(name="silent", hasArgument=false, description=@TranslatableText(type=SetupMessages.class, id="SILENT_OPTION")), @Option(name="configOnly", hasArgument=false, description=@TranslatableText(type=SetupMessages.class, id="CONFIG_ONLY_OPTION")), @Option(name="schemaOnly", hasArgument=false, description=@TranslatableText(type=SetupMessages.class, id="SCHEMA_ONLY_OPTION")), @Option(name="restart", hasArgument=false, description=@TranslatableText(type=SetupMessages.class, id="RESTART_ONLY_OPTION")), @Option(name="restartFile", description=@TranslatableText(type=SetupMessages.class, id="RESTART_FILE")), @Option(name="preserveParamFile", hasArgument=false, description=@TranslatableText(type=SetupMessages.class, id="PRESERVEPARAMFILE_OPTION"))})
public class Setup
implements CommandProvider {
    private final MutableConfigurations confs;
    private final Factory factory;
    private final File war;
    static final String APEX_PUBLIC_USER = "APEX_PUBLIC_USER";
    static final String MD_SUFFIX = "_md";
    static final String AL_SUFFIX = "_al";
    static final String ORDS_PUBLIC_USER = "ORDS_PUBLIC_USER";
    private static Setting PASSWORD = Setting.setting("DB_PWD", "db.password", null, true, new String[0]);
    private static Setting PORT = Setting.setting("DB_SERVER_PORT", "db.port", "1521");
    static final String RT_SUFFIX = "_rt";
    static final String PU_SUFFIX = "_pu";
    static final String WWV_FLOW_EPG_INCLUDE_MOD = "wwv_flow_epg_include_modules.authorize";
    static final String TYPE_PLSQL = "plsql";
    private static Setting SERVER = Setting.setting("DB_SERVER_NAME", "db.hostname", "localhost");
    private static Setting SERVICE_NAME = Setting.setting("DB_SERVICE_NAME", "db.servicename", null);
    private static final Setting SERVICE_OR_SID = Setting.setting("DB_CHOOSE_SID_OR_SERVICE", null, "1", false, "1", "2");
    private static Setting SID = Setting.setting("DB_SERVICE_ID", "db.sid", "xe");
    private static final Setting PROMPT_USE_APEX_REST = Setting.setting("PROMPT_REST_CREDENTIALS", null, "1", false, "1", "2");
    private static final Setting PROMPT_USE_PLSQL_GATEWAY = Setting.setting("PROMPT_PLSQL_GATEWAY", null, "1", false, "1", "2");
    private static final Setting PROMPT_INSTALL_ORDS_SCHEMA = Setting.setting("PROMPT_ORDS_SCHEMA", null, "1", false, "1", "2");
    private static Setting PROMPT_ENTER_GATEWAY_USER = Setting.setting("PLSQL_GATEWAY_USER", "db.username", "APEX_PUBLIC_USER");
    private static boolean isSimpleInstall;

    @Inject
    Setup(MutableConfigurations confs, @Named(value="war") File war, Factory factory) {
        this.confs = confs;
        this.war = war;
        this.factory = factory;
    }

    public void execute(Map<String, Object> values) throws Exception {
        Map<String, String> installParams;
        String paramFile;
        int cntOptions = 0;
        String confName = (String)values.get("database");
        if (confName == null) {
            confName = "apex";
        }
        confName = confName.toLowerCase();
        boolean preserveParamFile = false;
        if (values.get("preserveParamFile") != null) {
            preserveParamFile = (Boolean)values.get("preserveParamFile");
        }
        boolean configOnly = false;
        if (values.get("configOnly") != null && (configOnly = ((Boolean)values.get("configOnly")).booleanValue())) {
            ++cntOptions;
        }
        boolean schemaOnly = false;
        if (values.get("schemaOnly") != null && (schemaOnly = ((Boolean)values.get("schemaOnly")).booleanValue())) {
            ++cntOptions;
            if (values.containsKey("database")) {
                ++cntOptions;
            }
        }
        boolean restart = false;
        if (values.get("restart") != null && (restart = ((Boolean)values.get("restart")).booleanValue())) {
            ++cntOptions;
            if (values.containsKey("database")) {
                ++cntOptions;
            }
        }
        if (cntOptions > 1) {
            StringBuilder optList = new StringBuilder();
            if (values.containsKey("database")) {
                optList.append("--database ");
            }
            if (configOnly) {
                optList.append("--configOnly ");
            }
            if (schemaOnly) {
                optList.append("--schemaOnly ");
            }
            if (restart) {
                optList.append("--restart");
            }
            throw new Exception(SetupMessages.format("ERR_MULTIPLE_OPTIONS", optList.toString()));
        }
        String installType = (String)values.get("installtype");
        if (NullOrEmpty.nullOrEmpty((CharSequence)installType)) {
            installType = values.get("silent") != null && (Boolean)values.get("silent") != false ? "simple" : "advanced";
        }
        if (NullOrEmpty.nullOrEmpty((CharSequence)(paramFile = (String)values.get("paramfile")))) {
            paramFile = (String)values.get("parameterFile");
        }
        if ((installParams = InstallParams.getInstallParameters(this.war, installType, paramFile, (String)values.get("logDir"))) == null) {
            throw new Exception(SetupMessages.getString("ERR_INSTALL_PARAMS"));
        }
        isSimpleInstall = InstallParams.simpleInstall(installParams);
        Console console = System.console();
        if (schemaOnly) {
            this.setupSchemaOnly(console, (Class)values.get("installer"), installParams);
            return;
        }
        if (restart) {
            String restartFile = (String)values.get("restartFile");
            if (NullOrEmpty.nullOrEmpty((CharSequence)restartFile)) {
                throw new Exception(SetupMessages.getString("ERR_MISSING_RESTART_FILE"));
            }
            installParams.put("restart.file", restartFile);
            this.setupRestartOnly(console, (Class)values.get("installer"), installParams);
            return;
        }
        if (installParams.get("service.type") != null && installParams.get("service.type").equals("exadata")) {
            installParams.put("rest.services.ords.add", "true");
            installParams.put("rest.services.apex.add", "true");
            installParams.put("plsql.gateway.add", "false");
        }
        MutableConfigurations existing = this.confs;
        Configurations basicConfs = this.databaseConf(console, (Configurations)existing, confName, installParams);
        Configurations ordsConfigs = Setup.restfulServicesConf(console, basicConfs, confName, installParams, configOnly);
        boolean isInstallSchema = Boolean.valueOf(installParams.get("rest.services.ords.add"));
        if (!configOnly && isInstallSchema) {
            SchemaSetup.schemaParams(console, this.war, installParams);
        }
        Configurations plsqlGatewayConf = this.plsqlGatewayConfig(console, ordsConfigs, confName, installParams);
        Configurations apexRestfulServicesConf = Setup.apexRestfulServicesConf(console, plsqlGatewayConf, confName, installParams);
        boolean hasPlsqlGateway = Boolean.valueOf(installParams.get("plsql.gateway.add"));
        Configurations fullConf = hasPlsqlGateway ? apexRestfulServicesConf : this.removePlsqlGatewayConf(apexRestfulServicesConf, confName);
        this.confs.update(fullConf);
        if (!preserveParamFile) {
            InstallParams.writeInstallProperties(installParams);
        }
        if (!configOnly && isInstallSchema) {
            SchemaSetup.install(installParams, (Class)values.get("installer"), this.factory);
        }
    }

    private Configurations removePlsqlGatewayConf(Configurations existing, String confName) {
        ConfigurationsBuilder confs = ConfigurationsBuilder.builder((Configurations)existing);
        confs.remove(confName);
        return confs.build();
    }

    private Configurations databaseConf(Console console, Configurations existing, String confName, Map<String, String> installParams) throws Exception {
        ConfigurationBuilder defaults = ConfigurationBuilder.defaults(existing);
        ConfigurationBuilder conf = ConfigurationBuilder.builder(defaults, existing, confName);
        Setup.settingValue(console, conf, installParams, "db.hostname", SERVER);
        Setup.settingValue(console, conf, installParams, "db.port", PORT);
        this.sidOrServiceName(console, conf, installParams);
        if (!NullOrEmpty.nullOrEmpty((CharSequence)installParams.get("security.verifySSL"))) {
            conf.add("security.verifySSL", installParams.get("security.verifySSL"));
        }
        ConfigurationsBuilder cb = ConfigurationsBuilder.builder((Configurations)existing);
        cb.configuration("defaults", defaults.build());
        cb.configuration(confName, conf.build());
        Configurations basicConfs = cb.build();
        return basicConfs;
    }

    private void sidOrServiceName(Console console, ConfigurationBuilder conf, Map<String, String> installParams) throws Exception {
        if (!NullOrEmpty.nullOrEmpty((CharSequence)installParams.get("db.servicename")) && isSimpleInstall) {
            Setup.settingValue(console, conf, installParams, "db.servicename", SERVICE_NAME);
        } else if (!NullOrEmpty.nullOrEmpty((CharSequence)installParams.get("db.sid")) && isSimpleInstall) {
            Setup.settingValue(console, conf, installParams, "db.sid", SID);
        } else if (console != null) {
            String choice = SERVICE_OR_SID.prompt(console, new String[0]);
            if ("1".equals(choice)) {
                Setup.settingValue(console, conf, installParams, "db.servicename", SERVICE_NAME);
                installParams.remove("db.sid");
            } else {
                Setup.settingValue(console, conf, installParams, "db.sid", SID);
                installParams.remove("db.servicename");
            }
        } else {
            if (isSimpleInstall) {
                String keys = "db.servicename or db.sid";
                throw new Exception(SetupMessages.format("ERR_MISSING_VALUE_SIMPLE", keys));
            }
            throw new Exception(SetupMessages.getString("ERR_NO_CONSOLE_ADVANCED"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Configurations plsqlGatewayConfig(Console console, Configurations existing, String confName, Map<String, String> installParams) throws Exception {
        String isAddGateway;
        boolean promptPlsqlGateway = true;
        if (isSimpleInstall && !NullOrEmpty.nullOrEmpty((CharSequence)(isAddGateway = installParams.get("plsql.gateway.add")))) {
            if (!isAddGateway.equals("true")) return existing;
            promptPlsqlGateway = false;
        }
        if (promptPlsqlGateway) {
            if (console == null) return existing;
            String choice = PROMPT_USE_PLSQL_GATEWAY.prompt(console, new String[0]);
            if ("1".equals(choice)) {
                installParams.put("plsql.gateway.add", "true");
            } else {
                installParams.put("plsql.gateway.add", "false");
                return existing;
            }
        }
        ConfigurationBuilder gatewayConf = Setup.configurationBuilder(existing, confName, null);
        String userName = Setup.settingValue(console, gatewayConf, installParams, "db.username", PROMPT_ENTER_GATEWAY_USER);
        Setup.settingValue(console, gatewayConf, installParams, "db.password", PASSWORD, true, userName);
        if (!userName.toUpperCase().trim().equals(APEX_PUBLIC_USER)) return ConfigurationsBuilder.builder((Configurations)existing).configuration(confName, gatewayConf.build());
        String validationFunc = existing.get("defaults").get("security.requestValidationFunction");
        if (NullOrEmpty.nullOrEmpty((CharSequence)validationFunc) || validationFunc.trim().length() == 0) {
            ConfigurationBuilder defaults = ConfigurationBuilder.defaults(existing);
            defaults.add("security.requestValidationFunction", WWV_FLOW_EPG_INCLUDE_MOD);
            defaults.add("security.validationFunctionType", TYPE_PLSQL);
            return ConfigurationsBuilder.builder((Configurations)existing).configuration("defaults", defaults.build()).configuration(confName, gatewayConf.build());
        }
        if (validationFunc.equalsIgnoreCase(WWV_FLOW_EPG_INCLUDE_MOD)) return ConfigurationsBuilder.builder((Configurations)existing).configuration(confName, gatewayConf.build());
        gatewayConf.add("security.requestValidationFunction", WWV_FLOW_EPG_INCLUDE_MOD);
        gatewayConf.add("security.validationFunctionType", TYPE_PLSQL);
        return ConfigurationsBuilder.builder((Configurations)existing).configuration(confName, gatewayConf.build());
    }

    static Configurations restfulServicesConf(Console console, Configurations existing, String confName, Map<String, String> installParams) throws Exception {
        return Setup.restfulServicesConf(console, existing, confName, installParams, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Configurations restfulServicesConf(Console console, Configurations existing, String confName, Map<String, String> installParams, boolean configOnly) throws Exception {
        isSimpleInstall = InstallParams.simpleInstall(installParams);
        if (!configOnly) {
            String isInstallSchema;
            boolean promptInstallSchema = true;
            if (isSimpleInstall && !NullOrEmpty.nullOrEmpty((CharSequence)(isInstallSchema = installParams.get("rest.services.ords.add")))) {
                if (!isInstallSchema.equals("true")) return existing;
                promptInstallSchema = false;
            }
            if (promptInstallSchema) {
                if (console == null) return existing;
                String choice = PROMPT_INSTALL_ORDS_SCHEMA.prompt(console, new String[0]);
                if ("1".equals(choice)) {
                    installParams.put("rest.services.ords.add", "true");
                } else {
                    installParams.put("rest.services.ords.add", "false");
                    return existing;
                }
            }
        }
        ConfigurationBuilder pu = Setup.configurationBuilder(existing, confName, PU_SUFFIX);
        pu.add("db.username", ORDS_PUBLIC_USER);
        installParams.put("user.name.public", ORDS_PUBLIC_USER);
        Setup.settingValue(console, pu, installParams, "db.password", PASSWORD, true, ORDS_PUBLIC_USER);
        String puConfName = confName + PU_SUFFIX;
        return ConfigurationsBuilder.builder((Configurations)existing).configuration(puConfName, pu.build());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Configurations apexRestfulServicesConf(Console console, Configurations existing, String confName, Map<String, String> installParams) throws Exception {
        String isAddAPEXRest;
        boolean hasExadata;
        boolean hasPlsqlGateway = Boolean.valueOf(installParams.get("plsql.gateway.add"));
        boolean bl = hasExadata = installParams.get("service.type") != null && installParams.get("service.type").equals("exadata");
        if (!hasPlsqlGateway && !hasExadata) {
            installParams.put("rest.services.apex.add", "false");
            return existing;
        }
        boolean promptUseApex = true;
        if (isSimpleInstall && !NullOrEmpty.nullOrEmpty((CharSequence)(isAddAPEXRest = installParams.get("rest.services.apex.add")))) {
            if (!isAddAPEXRest.equals("true")) return existing;
            promptUseApex = false;
        }
        if (promptUseApex) {
            if (console == null) return existing;
            String choice = PROMPT_USE_APEX_REST.prompt(console, new String[0]);
            if ("1".equals(choice)) {
                installParams.put("rest.services.apex.add", "true");
            } else {
                installParams.put("rest.services.apex.add", "false");
                return existing;
            }
        }
        ConfigurationBuilder al = Setup.configurationBuilder(existing, confName, AL_SUFFIX);
        ConfigurationBuilder rt = Setup.configurationBuilder(existing, confName, RT_SUFFIX);
        al.add("db.username", "APEX_LISTENER");
        installParams.put("user.name.apex.listener", "APEX_LISTENER");
        Setup.settingValue(console, al, installParams, "db.password", PASSWORD, true, "APEX_LISTENER");
        rt.add("db.username", "APEX_REST_PUBLIC_USER");
        installParams.put("user.name.apex.restpublic", "APEX_REST_PUBLIC_USER");
        Setup.settingValue(console, rt, installParams, "db.password", PASSWORD, true, "APEX_REST_PUBLIC_USER");
        String alConfName = confName + AL_SUFFIX;
        String rtConfName = confName + RT_SUFFIX;
        if (!hasExadata) return ConfigurationsBuilder.builder((Configurations)existing).configuration(alConfName, al.build()).configuration(rtConfName, rt.build());
        rt.add("db.proxyPlSqlGateway", "true");
        String validationFunc = existing.get("defaults").get("security.requestValidationFunction");
        if (NullOrEmpty.nullOrEmpty((CharSequence)validationFunc) || validationFunc.trim().length() == 0) {
            ConfigurationBuilder defaults = ConfigurationBuilder.defaults(existing);
            defaults.add("security.requestValidationFunction", WWV_FLOW_EPG_INCLUDE_MOD);
            defaults.add("security.validationFunctionType", TYPE_PLSQL);
            return ConfigurationsBuilder.builder((Configurations)existing).configuration("defaults", defaults.build()).configuration(alConfName, al.build()).configuration(rtConfName, rt.build());
        }
        if (validationFunc.equalsIgnoreCase(WWV_FLOW_EPG_INCLUDE_MOD)) return ConfigurationsBuilder.builder((Configurations)existing).configuration(alConfName, al.build()).configuration(rtConfName, rt.build());
        rt.add("security.requestValidationFunction", WWV_FLOW_EPG_INCLUDE_MOD);
        rt.add("security.validationFunctionType", TYPE_PLSQL);
        return ConfigurationsBuilder.builder((Configurations)existing).configuration(alConfName, al.build()).configuration(rtConfName, rt.build());
    }

    private void setupSchemaOnly(Console console, Class<?> provider, Map<String, String> installParams) throws Exception {
        installParams.put("schema.only", "true");
        if (!Boolean.valueOf(installParams.get("bequeath.connect")).booleanValue()) {
            Setup.settingValue(console, null, installParams, "db.hostname", SERVER);
            Setup.settingValue(console, null, installParams, "db.port", PORT);
            this.sidOrServiceName(console, null, installParams);
        } else if (isSimpleInstall && !installParams.containsKey("rest.services.ords.add")) {
            installParams.put("rest.services.ords.add", "true");
        }
        SchemaSetup.schemaParams(console, this.war, installParams);
        if (this.requiresPublicUser(installParams)) {
            installParams.put("user.name.public", ORDS_PUBLIC_USER);
            Setup.settingValue(console, null, installParams, "db.password", PASSWORD, true, ORDS_PUBLIC_USER);
        }
        SchemaSetup.install(installParams, provider, this.factory);
    }

    private void setupRestartOnly(Console console, Class<?> provider, Map<String, String> installParams) throws Exception {
        this.validateRestartPropties(installParams);
        installParams.put("restart.only", "true");
        if (!Boolean.valueOf(installParams.get("bequeath.connect")).booleanValue()) {
            Setup.settingValue(console, null, installParams, "db.hostname", SERVER);
            Setup.settingValue(console, null, installParams, "db.port", PORT);
            this.sidOrServiceName(console, null, installParams);
        } else if (isSimpleInstall && !installParams.containsKey("rest.services.ords.add")) {
            installParams.put("rest.services.ords.add", "true");
        }
        SchemaSetup.schemaParams(console, this.war, installParams);
        if (this.requiresPublicUser(installParams)) {
            installParams.put("user.name.public", ORDS_PUBLIC_USER);
            Setup.settingValue(console, null, installParams, "db.password", PASSWORD, true, ORDS_PUBLIC_USER);
        }
        SchemaSetup.install(installParams, provider, this.factory);
    }

    private boolean requiresPublicUser(Map<String, String> installParams) {
        String installerType = installParams.get("installer");
        if (!NullOrEmpty.nullOrEmpty((CharSequence)installerType)) {
            String containerInfo;
            if (installerType.equals("install") || installerType.equals("cdb.install")) {
                return true;
            }
            if (installerType.equals("cdb.upgrade") && !NullOrEmpty.nullOrEmpty((CharSequence)(containerInfo = installParams.get("containers.info"))) && containerInfo.contains("install")) {
                return true;
            }
        }
        return false;
    }

    private void validateRestartPropties(Map<String, String> installParams) throws IOException {
        Properties prop = this.getProperties(installParams.get("restart.file"));
        if (prop.containsKey("container.process.list")) {
            if (NullOrEmpty.nullOrEmpty((CharSequence)prop.getProperty("container.process.list"))) {
                throw new IOException(SetupMessages.format("ERR_RESTART_MISSING_VALUE", "container.process.list"));
            }
        } else {
            throw new IOException(SetupMessages.format("ERR_RESTART_MISSING_PROPERTY", "container.process.list"));
        }
        installParams.put("container.process.list", prop.getProperty("container.process.list"));
        if (prop.containsKey("container.completed.list")) {
            installParams.put("container.completed.list", prop.getProperty("container.completed.list"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getProperties(String filename) throws IOException {
        SortedProperties properties = new SortedProperties();
        File file = Files.file((String)filename);
        if (file.exists()) {
            InputStream in = null;
            try {
                in = Files.inputStream((File)file);
                properties.load(in);
            }
            finally {
                Closeables.close((Object)in);
            }
        } else {
            throw new IOException(SetupMessages.getString("ERR_RESTART_FILE_NOT_EXIST"));
        }
        return properties;
    }

    private static String settingValue(Console console, ConfigurationBuilder conf, Map<String, String> installParams, String key, Setting setting) throws Exception {
        return Setup.settingValue(console, conf, installParams, key, setting, false, null);
    }

    private static ConfigurationBuilder configurationBuilder(Configurations existing, String poolName, String poolSuffix) {
        String fullyQualifiedName = poolSuffix == null ? poolName : poolName + poolSuffix;
        ConfigurationBuilder defaults = ConfigurationBuilder.defaults(existing);
        ConfigurationBuilder pool = ConfigurationBuilder.builder(defaults, existing, fullyQualifiedName);
        Configuration existingConf = existing.get(poolName);
        if (existingConf != null) {
            for (String name : existingConf.propertyNames()) {
                String value = existingConf.get(name);
                pool.add(name, value);
            }
        }
        return pool;
    }

    private static String settingValue(Console console, ConfigurationBuilder conf, Map<String, String> installParams, String key, Setting setting, boolean isPassword, String user) throws Exception {
        String val = null;
        String pwKey = null;
        if (isPassword) {
            pwKey = user.equalsIgnoreCase(ORDS_PUBLIC_USER) ? "user.public.password" : (user.equalsIgnoreCase("APEX_LISTENER") ? "user.apex.listener.password" : (user.equalsIgnoreCase("APEX_REST_PUBLIC_USER") ? "user.apex.restpublic.password" : "db.password"));
            val = installParams.get(pwKey);
            if (!NullOrEmpty.nullOrEmpty((CharSequence)val) && !val.startsWith("@")) {
                val = "@" + Passwords.goingOut((String)val);
                installParams.put(pwKey, val);
            }
        } else {
            val = installParams.get(key);
        }
        if (console != null) {
            if (isSimpleInstall && !NullOrEmpty.nullOrEmpty((CharSequence)val)) {
                if (conf != null) {
                    conf.add(key, val);
                }
            } else {
                if (isPassword) {
                    val = setting.prompt(console, user);
                    installParams.put(pwKey, val);
                } else {
                    if (!NullOrEmpty.nullOrEmpty((CharSequence)val)) {
                        setting.setDefaultValue(val);
                    }
                    val = setting.prompt(console, conf, new String[0]);
                    installParams.put(key, val);
                }
                if (conf != null) {
                    if (isPassword) {
                        conf.add("db.password", val);
                    } else {
                        conf.add(key, val);
                    }
                }
            }
        } else if (isSimpleInstall) {
            if (NullOrEmpty.nullOrEmpty((CharSequence)val)) {
                throw new Exception(SetupMessages.format("ERR_MISSING_VALUE_SIMPLE", isPassword ? pwKey : key));
            }
            if (conf != null) {
                conf.add(key, val);
            }
        } else {
            throw new Exception(SetupMessages.getString("ERR_NO_CONSOLE_ADVANCED"));
        }
        return val;
    }
}

