/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.collection;

import java.util.HashMap;
import oracle.dbtools.rt.uri.PathMatcher;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.uri.URITemplates;

public class CollectionUriTemplates
implements PathMatcher {
    private final URITemplate collection;
    private final URITemplate item;
    private final String name;
    private final URITemplate relativeItem;
    private final URITemplate scoped;
    public static final String ID = "id";
    public static final String SCOPE = "scope";
    private static final URITemplate COLLECTION = URITemplates.uriTemplate("{name}/");
    private static final URITemplate ITEM = URITemplates.uriTemplate("{name}/{id}");
    private static final URITemplate RELATIVE_ITEM = URITemplates.uriTemplate("./{id}");
    private static final URITemplate SCOPED = URITemplates.uriTemplate("{name}/{scope}/");

    private CollectionUriTemplates(String name) {
        this.name = name;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", name);
        this.collection = URITemplates.uriTemplate(COLLECTION.encode(params));
        this.item = URITemplates.uriTemplate(ITEM.encode(params));
        this.relativeItem = URITemplates.uriTemplate(RELATIVE_ITEM.encode(params));
        this.scoped = URITemplates.uriTemplate(SCOPED.encode(params));
    }

    public URITemplate collection() {
        return this.collection;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CollectionUriTemplates other = (CollectionUriTemplates)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public URITemplate item() {
        return this.item;
    }

    @Override
    public boolean matches(String path) {
        return this.collection.matches(path) || this.item.matches(path) || this.scoped.matches(path);
    }

    public URITemplate relativeItem() {
        return this.relativeItem;
    }

    public URITemplate scoped() {
        return this.scoped;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CollectionUriTemplates [name=");
        builder.append(this.name);
        builder.append("]");
        return builder.toString();
    }

    public static CollectionUriTemplates collectionUriTemplates(String name) {
        return new CollectionUriTemplates(name);
    }
}

