/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.generator;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.security.Principal;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.common.jdbc.ClobReader;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCException;
import oracle.dbtools.common.jdbc.JDBCTransaction;
import oracle.dbtools.common.jdbc.SQLCloser;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.query.UsesQuery;
import oracle.dbtools.common.service.model.Property;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.ReaderStream;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.http.ContentDisposition;
import oracle.dbtools.http.entities.EntityHeader;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeadersBuilder;
import oracle.dbtools.rt.resource.generator.ResourceGenerator;
import oracle.dbtools.rt.resource.generator.ResourceRequest;
import oracle.dbtools.rt.resource.generator.SQLResource;
import oracle.dbtools.rt.transcode.Transcoders;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.WebException;
import oracle.sql.CLOB;
import oracle.xdb.XMLType;

@Service(properties={@Property(name="oracle.dbtools.rt.web.ResourceGenerator", value="resource/lob"), @Property(name="oracle.dbtools.rt.web.ResourceGeneratorLabel", value="Media Resource"), @Property(name="oracle.dbtools.rt.web.ResourceGeneratorDescription", value="Generate a resource from a result set having a single row and two columns. The first column specifies the MIME type of the resource. The second column contains the content of the resource."), @Property(name="oracle.dbtools.rt.web.ResourceGeneratorExample", value="select mime_type,content from media where path=:path")}, provides={ResourceGenerator.class, LobGenerator.class})
public class LobGenerator
extends UsesQuery
implements ResourceGenerator {
    @Reference
    private JDBCCallProvider jdbc;
    @Reference
    private Transcoders transcoders;
    public static final String TYPE = "resource/lob";
    private static final Closeables.Closer XMLTYPES = new SQLCloser<XMLType>(XMLType.class){

        protected void closeSQLType(XMLType closeable) throws SQLException {
            closeable.close();
        }
    };

    @Override
    public Entity generate(ResourceRequest request) throws IOException {
        Entity entity = null;
        SQLResource sqlResource = SQLResource.query(request);
        Map<String, ?> params = sqlResource.inboundValues();
        Statement stmt = sqlResource.statement();
        CompoundPrincipal principal = request.request().principal();
        String[] preferredContentType = request.preferredContentType();
        String documentBase = Requests.documentBase(request.request());
        Transaction txn = null;
        Iterator rows = null;
        try {
            Pair<Transaction, Iterator<ResultRow>> queryResult = this.query((Principal)principal, stmt, params);
            txn = (Transaction)queryResult.first();
            rows = (Iterator)queryResult.second();
            ResultRow resource = (ResultRow)rows.next();
            entity = this.generateResource(documentBase, preferredContentType, resource);
            entity = Entities.alsoClose(entity, rows, txn);
        }
        catch (SQLException e) {
            Closeables.close((Object[])new Object[]{entity, rows, txn});
            throw JDBCException.wrap((SQLException)e);
        }
        return entity;
    }

    protected Entity generateResource(String documentBase, String[] preferredContentType, ResultRow resource) throws IOException, SQLException {
        SQLXML xml;
        ContentType contentType = ContentType.contentType((CharSequence)resource.get(1, String.class));
        String fileName = null;
        if (resource.size() >= 3) {
            fileName = (String)resource.get(3, String.class);
        }
        Object content = resource.get(2);
        InputStream bytes = null;
        if (content instanceof InputStream) {
            bytes = (InputStream)content;
        } else if (content instanceof Reader) {
            bytes = ReaderStream.stream((Reader)((Reader)content), (Charset)Text.defaultCharset());
        } else if (content instanceof String) {
            bytes = StreamCopy.toInputStream((CharSequence)((String)content));
        } else if (content instanceof SQLXML) {
            xml = (SQLXML)content;
            bytes = xml.getBinaryStream();
            bytes = Closeables.alsoClose((InputStream)bytes, (Object[])new Object[]{xml});
        } else if (content instanceof XMLType) {
            xml = (XMLType)content;
            CLOB clob = xml.getClobVal();
            ClobReader r = new ClobReader((Clob)clob);
            bytes = ReaderStream.stream((Reader)r, (Charset)Text.defaultCharset());
            bytes = Closeables.alsoClose((InputStream)bytes, (Object[])new Object[]{r});
        } else {
            throw WebException.internalError(null, new Reason[0]);
        }
        EntityHeadersBuilder headers = Entities.headers();
        if (!NullOrEmpty.nullOrEmpty((Object[])preferredContentType)) {
            headers.header((CharSequence)"X-APEX-PREFERRED-CONTENT-TYPE", preferredContentType);
        }
        headers.header((CharSequence)HttpHeader.CONTENT_TYPE, new CharSequence[]{contentType});
        if (!NullOrEmpty.nullOrEmpty((CharSequence)fileName)) {
            EntityHeader contentDisposition = ContentDisposition.contentDispositionAttachmentHeader((CharSequence)fileName);
            headers.header((CharSequence)contentDisposition.name(), contentDisposition.values());
        }
        Entity entity = this.transcoders.transform(Entities.entity(bytes, headers.build()));
        return entity;
    }

    protected Pair<Transaction, Iterator<ResultRow>> query(Principal principal, Statement stmt, Map<String, ?> params) {
        JDBCTransaction txn = null;
        Iterator<ResultRow> rows = null;
        try {
            txn = this.jdbc.transaction(principal);
            rows = this.query(txn, stmt, params);
            return Pair.pair((Object)txn, rows);
        }
        catch (SQLException e) {
            Closeables.close((Object[])new Object[]{rows, txn});
            throw JDBCException.wrap((SQLException)e);
        }
    }

    private Iterator<ResultRow> query(JDBCTransaction txn, Statement stmt, Map<String, ?> params) {
        Iterator rows = null;
        try {
            rows = this.query.query((Transaction)txn, stmt, params, false);
            if (!rows.hasNext()) {
                Closeables.close((Object[])new Object[]{rows, txn});
                throw WebException.notFound();
            }
        }
        catch (JDBCException e) {
            Closeables.close((Object[])new Object[]{rows, txn});
            throw e;
        }
        return rows;
    }
}

