/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.cache.sync;

import java.security.Principal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCQuery;
import oracle.dbtools.common.jdbc.JDBCTransaction;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.Timestamps;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.jdbc.entity.JDBCIdentifiers;
import oracle.dbtools.rt.resource.templates.cache.MetadataCache;
import oracle.dbtools.rt.resource.templates.cache.MetadataCaches;
import oracle.dbtools.rt.resource.templates.jdbc.ApexListenerJDBCPrincipal;
import oracle.dbtools.rt.tenants.TenantPrincipal;

class MetadataCacheSyncTask
implements Runnable {
    private final MetadataCaches caches;
    private final Timestamp created;
    private final JDBCCallProvider jdbc;
    private final CompoundPrincipal jdbcPrincipal;
    private Timestamp lastUpdated = null;
    private final CompoundPrincipal principal;
    private static final Log LOG = Log.get(MetadataCacheSyncTask.class);
    private static final String MODULES_SYNC = "select m.id, m.security_group_id, m.updated_on, c.short_name from wwv_flow_rt$modules m, wwv_flow_companies c where m.updated_on > :updated and c.provisioning_company_id = m.security_group_id order by m.updated_on";
    private static final Statement MODULES_SYNC_STMT = StatementBuilder.query().append((CharSequence)"select m.id, m.security_group_id, m.updated_on, c.short_name from wwv_flow_rt$modules m, wwv_flow_companies c where m.updated_on > :updated and c.provisioning_company_id = m.security_group_id order by m.updated_on").parameter("updated", Timestamp.class).build();

    MetadataCacheSyncTask(JDBCCallProvider jdbc, CompoundPrincipal principal, Timestamp created, MetadataCaches caches) {
        this.caches = caches;
        this.jdbc = jdbc;
        this.principal = principal;
        this.created = created;
        this.jdbcPrincipal = ApexListenerJDBCPrincipal.apexListener(principal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        JDBCTransaction txn = null;
        JDBCQuery query = null;
        Iterator rows = null;
        try {
            txn = this.jdbc.transaction((Principal)this.jdbcPrincipal);
            if (this.lastUpdated == null) {
                this.lastUpdated = this.created;
                LOG.fine("tracking changes newer than: " + Timestamps.toString((long)this.lastUpdated.getTime()) + " in pool: " + this.jdbcPrincipal.getName());
            }
            query = this.incrementalQuery((Transaction)txn, this.lastUpdated);
            rows = query.execute();
            Timestamp latestUpdated = this.lastUpdated;
            while (rows.hasNext()) {
                ResultRow row = (ResultRow)rows.next();
                TenantIdentifier id = JDBCIdentifiers.valueOf(row, "security_group_id", "id");
                String tenantName = (String)row.get("short_name", String.class);
                latestUpdated = (Timestamp)row.get("updated_on", Timestamp.class);
                if (!latestUpdated.after(this.lastUpdated)) continue;
                TenantPrincipal tenant = JDBCIdentifiers.tenantPrincipal(tenantName, id);
                CompoundPrincipal principal = this.principal.replace(TenantPrincipal.class, (Principal)tenant);
                MetadataCache cache = this.caches.getIfPresent(principal);
                if (cache == null) {
                    LOG.finest("ignoring module: " + id + " because there is no active cache for: " + tenantName);
                } else {
                    cache.invalidateModule(id);
                }
                this.lastUpdated = latestUpdated;
            }
        }
        catch (Throwable t) {
            try {
                LOG.severe(t);
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new Object[]{rows, query, txn});
                throw throwable;
            }
            Closeables.close((Object[])new Object[]{rows, query, txn});
        }
        Closeables.close((Object[])new Object[]{rows, query, txn});
    }

    private JDBCQuery incrementalQuery(Transaction txn, Timestamp lastUpdated) throws SQLException {
        JDBCQuery query = null;
        try {
            query = this.jdbc.query(txn, MODULES_SYNC_STMT, false);
            HashMap<String, Timestamp> parameters = new HashMap<String, Timestamp>();
            parameters.put("updated", lastUpdated);
            query.bind(parameters);
        }
        catch (SQLException e) {
            Closeables.close(query);
        }
        return query;
    }
}

