/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.config.GlobalConfiguration;
import oracle.dbtools.common.diagnostics.Diagnostics;
import oracle.dbtools.common.logging.LegacyLoggingAdaptor;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.timing.ExecutionTimersProvider;
import oracle.dbtools.common.timing.ExecutionTiming;
import oracle.dbtools.common.timing.TimingPoints;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.http.entrypoint.EntryPointServlet;
import oracle.dbtools.http.errors.BadRequestException;
import oracle.dbtools.http.errors.ErrorPageRenderer;
import oracle.dbtools.http.errors.Reason;
import oracle.dbtools.http.servlet.NormalizedHttpServletRequest;
import oracle.dbtools.plugin.api.conf.Configuration;
import oracle.dbtools.plugin.api.i18n.Translatable;
import oracle.dbtools.rt.ResourceTemplateMessages;
import oracle.dbtools.rt.web.AbsoluteLocationHeader;
import oracle.dbtools.rt.web.ForceSecure;

public class HttpEndpointBase
extends HttpServlet {
    private final ExecutionTimersProvider timers;
    private final Configuration conf;
    private final oracle.dbtools.plugin.api.logging.Log log = new LegacyLoggingAdaptor(LOG);
    private static final Log LOG = Log.get(HttpEndpointBase.class);
    private static final long serialVersionUID = 1L;

    public HttpEndpointBase() {
        this.conf = GlobalConfiguration.globalConfiguration();
        this.timers = new ExecutionTimersProvider();
    }

    public void destroy() {
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse servletResponse) throws ServletException, IOException {
        ExecutionTiming timer = this.timers.timer(TimingPoints.request((HttpServletRequest)request)).start();
        try {
            if (request.getCharacterEncoding() == null) {
                request.setCharacterEncoding(Text.defaultEncoding());
            }
            request = new NormalizedHttpServletRequest(request);
            request = ForceSecure.instance().apply(request);
            servletResponse = AbsoluteLocationHeader.apply(request, servletResponse);
            this.diagnostics().diagnosticContext(request, true);
            try {
                this.dispatchableServices(request, servletResponse);
            }
            catch (Throwable t2) {
                BadRequestException t2;
                if (t2 instanceof URIs.IllegalURIException) {
                    t2 = new BadRequestException(t2, new Reason[]{Reason.reason((String)"url", (Translatable)new TranslatableMessage(ResourceTemplateMessages.class, "HttpEndpointBase.1", "", new Object[0]))});
                }
                ErrorPageRenderer renderer = new ErrorPageRenderer(this.log, this.conf, "", (Throwable)t2);
                renderer.service((ServletRequest)request, (ServletResponse)servletResponse);
            }
        }
        finally {
            timer.stop();
        }
    }

    private final Diagnostics diagnostics() {
        return (Diagnostics)ServiceLocator.acquire(Diagnostics.class);
    }

    private void dispatchableServices(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        EntryPointServlet servlet = new EntryPointServlet();
        servlet.init(this.getServletConfig());
        servlet.service((ServletRequest)request, (ServletResponse)response);
    }
}

