/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.common.util.Base64;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Digests;
import oracle.dbtools.common.util.Identifiers;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeadersBuilder;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.ETags;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.HttpStatusCode;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.content.MimeTypes;

public abstract class HttpResources {
    public static final Entity NO_CONTENT = Entities.entity(null, Entities.headers("X-APEX-STATUS-CODE", Integer.toString(HttpStatusCode.NO_CONTENT.statusCode())));
    private static long WEAK_ETAG_SALT = Identifiers.rng().nextLong();

    public static HttpResource created(String location) {
        return new CreatedResource(location);
    }

    public static HttpResource maybeVersioned(String version, Entity response) {
        if (version == null) {
            return HttpResources.noVersion(response);
        }
        return new VersionedResource(version, response);
    }

    public static HttpResource noContent() {
        return new NoContentResource();
    }

    public static HttpResource noVersion(Entity response) {
        return new UnversionedResource(response);
    }

    public static HttpResource resource(URI uri) {
        return new URIResource(uri);
    }

    public static HttpResource temporaryRedirect(String location) {
        return new TemporaryRedirectResource(location);
    }

    static String weakETag(URLConnection conn) throws IOException {
        String etag = null;
        long lastModified = conn.getLastModified();
        long contentLength = conn.getContentLength();
        if (lastModified != 0L) {
            byte[] bytes = ByteBuffer.allocate(24).putLong(lastModified).putLong(contentLength).putLong(WEAK_ETAG_SALT).array();
            etag = Base64.byteArrayToBase64((byte[])Digests.digest((byte[])bytes));
        }
        return etag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Entity entity(URI uri) throws IOException {
        Entity entity;
        URLConnection conn = null;
        Object in = null;
        try {
            int contentLength;
            URL url = uri.toURL();
            conn = url.openConnection();
            boolean hasETag = false;
            boolean hasContentType = false;
            boolean hasContentLength = false;
            EntityHeadersBuilder headers = Entities.headers();
            Map<String, List<String>> hdrs = conn.getHeaderFields();
            for (String name : hdrs.keySet()) {
                if (name == null) continue;
                if (HttpHeader.ETAG.matches(name)) {
                    hasETag = true;
                }
                if (HttpHeader.CONTENT_TYPE.matches(name)) {
                    hasContentType = true;
                }
                if (HttpHeader.CONTENT_LENGTH.matches(name)) {
                    hasContentLength = true;
                }
                List<String> values = hdrs.get(name);
                headers.header((CharSequence)name, values);
            }
            if (!hasETag) {
                headers.header((CharSequence)HttpHeader.ETAG, HttpResources.etag(conn));
            }
            if (!hasContentType) {
                ContentType contentType = MimeTypes.get(URIs.path((URI)uri));
                headers.header((CharSequence)HttpHeader.CONTENT_TYPE, new CharSequence[]{contentType});
            }
            if (!hasContentLength && (contentLength = conn.getContentLength()) != -1) {
                headers.header((CharSequence)HttpHeader.CONTENT_LENGTH, Integer.toString(contentLength));
            }
            entity = Entities.entity(conn.getInputStream(), headers.build());
        }
        catch (Throwable throwable) {
            Closeables.close((Object[])new Object[]{in, conn});
            throw throwable;
        }
        Closeables.close((Object[])new Object[]{in, conn});
        return entity;
    }

    private static String etag(URI uri) {
        String string;
        URLConnection conn = null;
        try {
            String etag;
            URL url = uri.toURL();
            conn = url.openConnection();
            string = etag = HttpResources.etag(conn);
        }
        catch (IOException e) {
            try {
                throw UnrecoverableException.unrecoverable((Throwable)e);
            }
            catch (Throwable throwable) {
                Closeables.close(conn);
                throw throwable;
            }
        }
        Closeables.close((Object)conn);
        return string;
    }

    private static String etag(URLConnection conn) throws IOException {
        String etag = conn.getHeaderField(HttpHeader.ETAG.text());
        if (etag == null) {
            etag = HttpResources.weakETag(conn);
        }
        return etag;
    }

    private static final class URIResource
    implements HttpResource {
        private final URI uri;

        private URIResource(URI uri) {
            this.uri = uri;
        }

        @Override
        public Entity response(RequestEntity request) throws IOException {
            return HttpResources.entity(this.uri);
        }

        public String toString() {
            return this.uri.toString();
        }

        @Override
        public String version() {
            return HttpResources.etag(this.uri);
        }
    }

    private static final class UnversionedResource
    implements HttpResource {
        private final Entity response;

        private UnversionedResource(Entity response) {
            this.response = response;
        }

        @Override
        public Entity response(RequestEntity request) {
            return this.response;
        }

        @Override
        public String version() {
            return null;
        }
    }

    private static final class TemporaryRedirectResource
    implements HttpResource {
        private final String location;

        private TemporaryRedirectResource(String location) {
            this.location = location;
        }

        @Override
        public Entity response(RequestEntity request) throws IOException {
            return Entities.entity(null, Entities.headers(HttpHeader.LOCATION, this.location, "X-APEX-STATUS-CODE", Integer.toString(HttpStatusCode.TEMPORARY_REDIRECT.statusCode())));
        }

        @Override
        public String version() {
            return null;
        }
    }

    private static final class NoContentResource
    implements HttpResource {
        private NoContentResource() {
        }

        @Override
        public Entity response(RequestEntity request) throws IOException {
            return NO_CONTENT;
        }

        @Override
        public String version() {
            return null;
        }
    }

    private static final class VersionedResource
    implements HttpResource {
        private final Entity response;
        private final String version;

        private VersionedResource(String version, Entity response) {
            this.version = version;
            this.response = response;
        }

        @Override
        public Entity response(RequestEntity request) throws IOException {
            if (this.version != null) {
                return ETags.etagHeader(this.response, this.version);
            }
            return this.response;
        }

        @Override
        public String version() {
            return this.version;
        }
    }

    private static final class CreatedResource
    implements HttpResource {
        private final String location;

        private CreatedResource(String location) {
            this.location = location;
        }

        @Override
        public Entity response(RequestEntity request) throws IOException {
            return Entities.entity(null, Entities.headers("X-APEX-FORWARD", this.location, "X-APEX-STATUS-CODE", Integer.toString(HttpStatusCode.CREATED.statusCode())));
        }

        @Override
        public String version() {
            return null;
        }
    }
}

