/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web.content;

import java.io.IOException;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.dispatch.DispatchableResourceType;
import oracle.dbtools.rt.authentication.SecurityConfig;
import oracle.dbtools.rt.locale.LocalePreference;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.HttpResources;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandler;
import oracle.dbtools.rt.web.ResourceDispatcher;
import oracle.dbtools.rt.web.WebException;
import oracle.dbtools.rt.web.content.ContentInfo;
import oracle.dbtools.rt.web.content.ContentRules;

@Service
public class StaticContentHandler
implements ResourceDispatcher {
    @Reference
    private ContentRules contentRules;

    @Override
    public ResourceDispatcher.Score canDispatch(RequestEntity request) {
        ContentInfo content;
        String path = request.path();
        if (!StaticContentHandler.hasQueryString(path) && (content = this.contentRules.match(LocalePreference.preference(request), path)) != null) {
            return new ResourceDispatcher.Score(DispatchableResourceType.BUILT_IN_RESOURCE, 1, content.security(), (Object)content, new String[0]);
        }
        return RequestHandler.NO_MATCH;
    }

    private static boolean hasQueryString(String path) {
        return path.indexOf(63) != -1;
    }

    @Override
    public HttpResource dispatch(ResourceDispatcher.Score score, RequestEntity request) throws IOException {
        if (score == null) {
            score = this.canDispatch(request);
        }
        if (score.score() < 0) {
            throw WebException.notFound();
        }
        ContentInfo content = (ContentInfo)score.handle();
        this.authorize(request, content);
        return HttpResources.resource(content.uri());
    }

    private void authorize(RequestEntity request, ContentInfo content) {
        SecurityConfig security = content.security();
        request.verifySecurityConstraint(security);
    }
}

