/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web.fileupload;

import java.io.IOException;
import java.util.Iterator;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.plugin.api.i18n.Translatable;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;
import oracle.dbtools.rt.web.fileupload.EntityRequestContext;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;

public class FileUploadEntity
extends FileUpload
implements Iterable<FileItemStream> {
    private final EntityRequestContext entity;

    private FileUploadEntity(Entity entity) {
        this.entity = new EntityRequestContext(entity);
    }

    @Override
    public Iterator<FileItemStream> iterator() {
        try {
            return new MultipartIterator(super.getItemIterator((RequestContext)this.entity));
        }
        catch (FileUploadException e) {
            throw WebException.badRequest(Reason.reason("multipart", (Translatable)new TranslatableMessage(e.getMessage())));
        }
        catch (IOException e) {
            throw WebException.internalError(e, new Reason[0]);
        }
    }

    public static FileUploadEntity fileUpload(Entity entity) {
        return new FileUploadEntity(entity);
    }

    public static final boolean isMultipartContent(Entity entity) {
        boolean isMultipart = false;
        EntityHeader h = entity.headers().header("X-APEX-METHOD");
        if (h != null && "post".equals(h.value().toLowerCase()) && (h = entity.headers().header(HttpHeader.CONTENT_TYPE)) != null) {
            String contentType = h.value();
            boolean isMultipart1 = false;
            if (contentType != null && contentType.toLowerCase().startsWith("multipart/")) {
                isMultipart1 = true;
            }
            isMultipart = isMultipart1;
        }
        return isMultipart;
    }

    private final class MultipartIterator
    implements Iterator<FileItemStream> {
        private final FileItemIterator itemIterator;

        public MultipartIterator(FileItemIterator itemIterator) {
            this.itemIterator = itemIterator;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.itemIterator.hasNext();
            }
            catch (Exception e) {
                throw WebException.internalError(e, new Reason[0]);
            }
        }

        @Override
        public FileItemStream next() {
            try {
                return this.itemIterator.next();
            }
            catch (Exception e) {
                throw WebException.internalError(e, new Reason[0]);
            }
        }

        @Override
        public void remove() {
        }
    }
}

