/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scope.module;

import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.TreeReader;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.home.tenants.TenantEntity;
import oracle.dbtools.rt.home.tenants.TenantEntityAccess;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.oauth.OAuthProfile;
import oracle.dbtools.rt.resource.collection.tenants.TenantEntityItemRequestHandler;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.ResourceDispatcher;
import oracle.dbtools.scope.module.ModuleScope;
import oracle.dbtools.scope.module.ModuleScopeJSONReader;
import oracle.dbtools.scope.module.ModuleScopesProvider;

@Service(provides={ResourceDispatcher.class, ModuleScopeRequestHandler.class})
public class ModuleScopeRequestHandler
extends TenantEntityItemRequestHandler<ModuleScope> {
    @Reference
    private ModuleScopesProvider moduleScopes;

    public ModuleScopeRequestHandler() {
        super(OAuthProfile.MODULE_SCOPE_URI_TEMPLATES, TenantEntityAccess.TENANT, OAuthProfile.OAUTH_MODULE_SCOPE_JSON);
    }

    @Override
    public ResourceDispatcher.Score canDispatch(RequestEntity request) {
        return super.canDispatch(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void delete(CompoundPrincipal principal, ModuleScope existing) {
        Transaction txn = null;
        try {
            txn = this.moduleScopes.newTransaction(principal);
            this.moduleScopes.delete(txn, principal, existing.id());
        }
        catch (Throwable throwable) {
            Closeables.close(txn);
            throw throwable;
        }
        Closeables.close((Object)txn);
    }

    @Override
    protected TreeReader<TenantEntity> entityGraphReader() {
        return new ModuleScopeJSONReader();
    }

    @Override
    protected ModuleScope existing(CompoundPrincipal principal, TenantIdentifier id) {
        return (ModuleScope)this.moduleScopes.entity(null, principal, id);
    }

    @Override
    protected Entity process(CompoundPrincipal principal, ModuleScope existing) {
        return Entities.entity(existing.content(), Entities.headers(new CharSequence[]{HttpHeader.CONTENT_TYPE, OAuthProfile.OAUTH_MODULE_SCOPE_JSON}));
    }
}

