/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.common.util;

import oracle.adf.share.codesharing.audit.annotation.CodeSharingSafe;
import oracle.adf.share.platform.ADFServerPlatformSupport;
import oracle.adf.share.platform.ADFServerPlatformSupportFactory;
import oracle.adf.share.platform.AdfLoggingSupport;
import oracle.adf.share.platform.AdfLoggingSupportFactory;
import oracle.adf.share.platform.AdfMetricsSupport;
import oracle.adf.share.platform.AdfMetricsSupportFactory;
import oracle.adf.share.platform.AdfPlatformSupportFactory;
import oracle.adf.share.platform.AdfServerPlatformSupport;
import oracle.adf.share.platform.AdfServerPlatformSupportFactory;

public class AdfPlatformFactoryResolver {
    @CodeSharingSafe(value="MutableStaticField")
    private static AdfMetricsSupportFactory msFactory = null;
    @CodeSharingSafe(value="MutableStaticField")
    private static AdfLoggingSupportFactory lsFactory = null;

    private AdfPlatformFactoryResolver() {
    }

    protected static AdfPlatformFactoryResolver getInstance() {
        return SingletonHolder.resolver;
    }

    public AdfPlatformSupportFactory getAdfServerPlatformSupportFactory() {
        return SingletonHolder.spFactory;
    }

    public ADFServerPlatformSupportFactory getADFServerPlatformSupportFactory() {
        return SingletonHolder.spFactory2;
    }

    public static ADFServerPlatformSupport getADFServerPlatformSupport() {
        return AdfPlatformFactoryResolver.getInstance().getADFServerPlatformSupportFactory().getSupportInstance();
    }

    public static AdfServerPlatformSupport getAdfServerPlatformSupport() throws Exception {
        return (AdfServerPlatformSupport)AdfPlatformFactoryResolver.getInstance().getAdfServerPlatformSupportFactory().getSupportInstance();
    }

    @Deprecated
    public static AdfMetricsSupport getAdfMetricsSupport() throws Exception {
        AdfPlatformFactoryResolver resolver = AdfPlatformFactoryResolver.getInstance();
        return (AdfMetricsSupport)resolver.getAdfMetricsSupportFactory().getSupportInstance();
    }

    @Deprecated
    public static AdfLoggingSupport getAdfLoggingSupport() throws Exception {
        AdfPlatformFactoryResolver resolver = AdfPlatformFactoryResolver.getInstance();
        return (AdfLoggingSupport)resolver.getAdfLoggingSupportFactory().getSupportInstance();
    }

    @Deprecated
    public AdfPlatformSupportFactory getAdfMetricsSupportFactory() {
        if (msFactory == null) {
            msFactory = new AdfMetricsSupportFactory();
            return msFactory;
        }
        return msFactory;
    }

    @Deprecated
    public AdfPlatformSupportFactory getAdfLoggingSupportFactory() {
        if (lsFactory == null) {
            lsFactory = new AdfLoggingSupportFactory();
            return lsFactory;
        }
        return lsFactory;
    }

    private static class SingletonHolder {
        private static final ADFServerPlatformSupportFactory spFactory2 = new ADFServerPlatformSupportFactory();
        private static final AdfServerPlatformSupportFactory spFactory = new AdfServerPlatformSupportFactory();
        private static final AdfPlatformFactoryResolver resolver = new AdfPlatformFactoryResolver();

        private SingletonHolder() {
        }
    }
}

