/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging.internal.diagnostic;

import java.util.logging.Level;
import oracle.adf.share.logging.internal.diagnostic.ADFLogRecord;

public class JBODiagnosticLogRecord
extends ADFLogRecord {
    private static final long serialVersionUID = -1141654773305349587L;
    private transient boolean __needToInferCaller = true;

    public JBODiagnosticLogRecord(Level level, String msg) {
        super(level, msg);
    }

    @Override
    public String getSourceClassName() {
        if (this.__needToInferCaller) {
            this._inferCaller();
        }
        return super.getSourceClassName();
    }

    @Override
    public String getSourceMethodName() {
        if (this.__needToInferCaller) {
            this._inferCaller();
        }
        return super.getSourceMethodName();
    }

    @Override
    public void setSourceClassName(String sourceClassName) {
        this.__needToInferCaller = false;
        super.setSourceClassName(sourceClassName);
    }

    @Override
    public void setSourceMethodName(String sourceMethodName) {
        this.__needToInferCaller = false;
        super.setSourceMethodName(sourceMethodName);
    }

    private void _inferCaller() {
        StackTraceElement frame;
        String cname;
        int ix;
        this.__needToInferCaller = false;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (ix = 0; ix < stack.length && !(cname = (frame = stack[ix]).getClassName()).equals("oracle.jbo.common.Diagnostic"); ++ix) {
        }
        while (ix < stack.length) {
            frame = stack[ix];
            cname = frame.getClassName();
            if (!cname.equals("oracle.jbo.common.Diagnostic")) {
                this.setSourceClassName(cname);
                this.setSourceMethodName(frame.getMethodName());
                return;
            }
            ++ix;
        }
        this.setSourceClassName(null);
        this.setSourceMethodName(null);
    }
}

