/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.perf.analysis;

import java.io.PrintStream;
import oracle.adf.share.perf.analysis.Analyzer;
import oracle.adf.share.perf.analysis.SensorResult;

class TimerResult
extends SensorResult {
    int mMax = Integer.MIN_VALUE;
    int mMin = Integer.MAX_VALUE;

    TimerResult(int nameIndex) {
        this.mNameIndex = nameIndex;
    }

    @Override
    void setValue(String value) {
        ++this.mHit;
        this.mValue = value;
        int intValue = Integer.parseInt(value);
        this.mElapseTime += (long)intValue;
        if (intValue > this.mMax) {
            this.mMax = intValue;
        }
        if (intValue < this.mMin) {
            this.mMin = intValue;
        }
    }

    @Override
    void print(PrintStream out, boolean printGap, String spaces) {
        String fullName = (String)Analyzer.sSensorNames.get(this.mNameIndex);
        if (Analyzer.sFormatXml) {
            int sep = fullName.lastIndexOf(47);
            String name = fullName.substring(sep + 1);
            String group = fullName.substring(0, sep);
            out.print("Timer: (");
            if (printGap) {
                out.print(" gap=" + TimerResult.prependSpace(sDblFmt.format((double)this.mGap / (double)this.mHit), 6) + " |");
            }
            out.print(" hit=" + TimerResult.prependSpace(sIntFmt.format(this.mHit), 6));
            out.print(" | avg=" + TimerResult.prependSpace(sDblFmt.format((double)this.mElapseTime / (double)this.mHit), 6));
            out.print(" | min=" + TimerResult.prependSpace(sDblFmt.format(this.mMin), 6));
            out.print(" | max=" + TimerResult.prependSpace(sIntFmt.format(this.mMax), 6));
            if (Analyzer.sAnalysisType == 2) {
                out.print(" | rtt=" + TimerResult.prependSpace(sDblFmt.format(this.mRunningTotal), 6));
            } else {
                out.print(" | ttl=" + TimerResult.prependSpace(sDblFmt.format(this.mElapseTime), 6));
            }
            out.print(" )");
            out.println(" " + name + " [" + group + "]");
        } else {
            out.println(spaces + "Timer:" + fullName + " [id=" + this.mNameIndex + "]");
            out.print(spaces + "(");
            if (printGap) {
                out.print(" gap=" + TimerResult.prependSpace(sDblFmt.format((double)this.mGap / (double)this.mHit), 6) + " |");
            }
            out.print(" hit=" + TimerResult.prependSpace(sIntFmt.format(this.mHit), 6));
            out.print(" | avg=" + TimerResult.prependSpace(sDblFmt.format((double)this.mElapseTime / (double)this.mHit), 6));
            out.print(" | min=" + TimerResult.prependSpace(sDblFmt.format(this.mMin), 6));
            out.print(" | max=" + TimerResult.prependSpace(sIntFmt.format(this.mMax), 6));
            if (Analyzer.sAnalysisType == 2) {
                out.print(" | rtt=" + TimerResult.prependSpace(sDblFmt.format(this.mRunningTotal), 6));
            } else {
                out.print(" | ttl=" + TimerResult.prependSpace(sDblFmt.format(this.mElapseTime), 6));
            }
            if (Analyzer.sDebug) {
                out.print(" | ts=" + TimerResult.prependSpace(sIntFmt.format(this.mTimeStamp), 6));
            }
            out.println(" )");
            out.println("");
        }
    }
}

