/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.demo;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import oracle.bali.xml.gui.swing.util.UIUtils;
import oracle.bali.xml.share.BaseAction;

public class DemoUndoHandler
implements ActionListener,
UndoableEditListener {
    private static final String _UNDO_COMMAND = "undo";
    private static final String _REDO_COMMAND = "redo";
    private Action _undoAction;
    private Action _redoAction;
    private Action[] _actions;
    private LinkedList _undos = new LinkedList();
    private LinkedList _redos = new LinkedList();
    private boolean _busy;

    public DemoUndoHandler() {
        this._undoAction = new BaseAction("", 85, KeyStroke.getKeyStroke(90, 2), _UNDO_COMMAND, (ActionListener)this);
        this._redoAction = new BaseAction("", 82, KeyStroke.getKeyStroke(89, 2), _REDO_COMMAND, (ActionListener)this);
        this._actions = new Action[]{this._undoAction, this._redoAction};
        this._updateUndoRedo();
    }

    public Action[] getActions() {
        return this._actions;
    }

    public Action getUndoAction() {
        return this._undoAction;
    }

    public Action getRedoAction() {
        return this._redoAction;
    }

    public JMenuItem createUndoMenuItem() {
        return UIUtils.createMenuItem(this.getUndoAction());
    }

    public JMenuItem createRedoMenuItem() {
        return UIUtils.createMenuItem(this.getRedoAction());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (_UNDO_COMMAND.equals(command)) {
            this._undo();
        } else if (_REDO_COMMAND.equals(command)) {
            this._redo();
        }
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        UndoableEdit edit;
        if (!this._busy && (edit = e.getEdit()).isSignificant()) {
            if (edit.canUndo()) {
                this._undos.add(edit);
            } else {
                this._clearList(this._undos);
            }
            this._clearList(this._redos);
            this._updateUndoRedo();
        }
    }

    private void _undo() {
        if (!this._undos.isEmpty()) {
            UndoableEdit undoEdit = (UndoableEdit)this._undos.removeLast();
            this._busy = true;
            try {
                undoEdit.undo();
                if (undoEdit.canRedo()) {
                    this._redos.add(undoEdit);
                } else {
                    undoEdit.die();
                }
            }
            catch (CannotUndoException e) {
                System.err.println("Could not undo:" + undoEdit);
                undoEdit.die();
                this._clearList(this._undos);
            }
            this._busy = false;
            this._updateUndoRedo();
        }
    }

    private void _redo() {
        if (!this._redos.isEmpty()) {
            UndoableEdit redoEdit = (UndoableEdit)this._redos.removeLast();
            this._busy = true;
            try {
                redoEdit.redo();
                if (redoEdit.canUndo()) {
                    this._undos.add(redoEdit);
                } else {
                    redoEdit.die();
                }
            }
            catch (CannotRedoException e) {
                System.err.println("Could not redo:" + redoEdit);
                redoEdit.die();
                this._clearList(this._redos);
            }
            this._busy = false;
            this._updateUndoRedo();
        }
    }

    private void _clearList(LinkedList list) {
        while (!list.isEmpty()) {
            UndoableEdit currEdit = (UndoableEdit)list.removeFirst();
            currEdit.die();
        }
    }

    private void _updateUndoRedo() {
        boolean undoEnabled = false;
        boolean redoEnabled = false;
        String undoText = "Undo";
        String redoText = "Redo";
        undoEnabled = !this._undos.isEmpty();
        boolean bl = redoEnabled = !this._redos.isEmpty();
        if (undoEnabled) {
            undoText = ((UndoableEdit)this._undos.getLast()).getUndoPresentationName();
        }
        if (redoEnabled) {
            redoText = ((UndoableEdit)this._redos.getLast()).getRedoPresentationName();
        }
        this._undoAction.setEnabled(undoEnabled);
        this._redoAction.setEnabled(redoEnabled);
        this._undoAction.putValue("Name", undoText);
        this._redoAction.putValue("Name", redoText);
    }
}

