/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.inspector.editors;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.table.TableCellEditor;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.inspector.PropertyEditorAdapter;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.gui.GuiXmlContext;
import oracle.bali.xml.gui.base.inspector.editors.AbstractSimplePropretyEditor;
import oracle.bali.xml.gui.swing.inspector.editors.ListEditorPanel;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.metadata.ContextualPropertyEditor;
import oracle.bali.xml.model.metadata.PropertyEditorContext;
import oracle.bali.xml.util.SimpleTypePropertyEditorManager;
import org.w3c.dom.Node;

public class ListEditor
extends AbstractSimplePropretyEditor<List>
implements ContextualPropertyEditor,
VetoableChangeListener {
    private PropertyEditorContext _propertyEditorContext;
    private PropertyEditor _listItemPropertyEditor;
    private ListEditorPanel _listEditorPanel;

    public ListEditor() {
        super(List.class);
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("closed".equals(evt.getPropertyName()) && Boolean.TRUE.equals(evt.getNewValue())) {
            Object[] listValueArray = this._getListEditorPanel().getValue();
            String listObject = ListEditor._convertObjectArrayToListString(listValueArray);
            this.setValue(listObject);
        }
    }

    public void setContext(PropertyEditorContext context) {
        this._propertyEditorContext = context.clone();
        this._setListItemPropertyEditor();
    }

    public void clearContext() {
        this._propertyEditorContext = null;
        this._listItemPropertyEditor = null;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        ListEditorPanel lep = this._getListEditorPanel();
        Object[] listValue = ListEditor._convertListObjectToObjectArray(this.getValue());
        lep.setValue(listValue);
        TableCellEditor tce = this.getListItemTableCellEditor();
        lep.setListItemEditor(tce);
        return lep;
    }

    protected String getStringForValue(List value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        if (value.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder(3);
        for (Object o : value) {
            if (o == null) continue;
            sb.append(this._getText(o));
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    protected List getValueForString(String value) throws IllegalArgumentException {
        if (value == null) {
            return Collections.emptyList();
        }
        List<String> sl = Arrays.asList(value.split(" "));
        ArrayList<Object> ol = new ArrayList<Object>(sl.size());
        for (String s : sl) {
            if (s == null) continue;
            Object o = this._getValue(s);
            if (o == null) {
                o = value;
            }
            ol.add(o);
        }
        return ol;
    }

    protected TableCellEditor getListItemTableCellEditor() {
        if (this._listItemPropertyEditor == null) {
            return null;
        }
        Object pef = this._listItemPropertyEditor instanceof PropertyEditorFactory ? (PropertyEditorFactory)this._listItemPropertyEditor : new PropertyEditorAdapter(this._listItemPropertyEditor);
        return pef.getInPlaceEditor(this.getXmlContext().getLocale());
    }

    protected String getHelpId() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getHelpTopic(XmlContext context, XmlKey key, Node node, Node ownerNode) {
        if (context == null) {
            return null;
        }
        context.getModel().acquireReadLock();
        try {
            String string = ((GuiXmlContext)context).getActiveGui().getHelpTopic(node, key);
            return string;
        }
        finally {
            context.getModel().releaseReadLock();
        }
    }

    protected String getInstructionText() {
        return null;
    }

    protected final XmlContext getXmlContext() {
        return this._propertyEditorContext == null ? null : this._propertyEditorContext.getXmlContext();
    }

    protected final Node getOwnerNode() {
        return this._propertyEditorContext == null ? null : this._propertyEditorContext.getOwnerNode();
    }

    protected final Node getNode() {
        return this._propertyEditorContext == null ? null : this._propertyEditorContext.getNode();
    }

    protected final XmlKey getXmlKey() {
        return this._propertyEditorContext == null ? null : this._propertyEditorContext.getKey();
    }

    private String _getText(Object o) {
        this._setListItemPropertyEditor();
        if (this._listItemPropertyEditor != null) {
            this._listItemPropertyEditor.setValue(o);
            return this._listItemPropertyEditor.getAsText();
        }
        return o.toString();
    }

    private Object _getValue(String s) {
        this._setListItemPropertyEditor();
        if (this._listItemPropertyEditor != null) {
            this._listItemPropertyEditor.setAsText(s);
            return this._listItemPropertyEditor.getValue();
        }
        return s;
    }

    private void _setListItemPropertyEditor() {
        XmlKey xmlKey = this.getXmlKey();
        Node node = this.getNode();
        Object value = this.getValue();
        AbstractModel model = this.getXmlContext().getActiveAbstractModel();
        XmlMetadataResolver xmlMetadataResolver = model.getXmlMetadataResolver();
        SimpleType type = xmlMetadataResolver.getModifiedSimpleType(node, xmlKey, value);
        if (type != null && type.getVariety() == 1) {
            SimpleType listType = type.getListItemType();
            try {
                this._listItemPropertyEditor = SimpleTypePropertyEditorManager.getInstance().getPropertyEditor(listType);
            }
            catch (GrammarException e) {
                this._listItemPropertyEditor = null;
            }
        }
    }

    private ListEditorPanel _getListEditorPanel() {
        if (this._listEditorPanel == null) {
            this._listEditorPanel = new ListEditorPanel(this.getXmlContext());
            this._listEditorPanel.addVetoableChangeListener(this);
            this._listEditorPanel.setInstructionText(this.getInstructionText());
            String helpId = this.getHelpId();
            if (helpId == null) {
                helpId = this.getHelpTopic(this.getXmlContext(), this.getXmlKey(), this.getNode(), this.getOwnerNode());
            }
            HelpUtils.setHelpID((JComponent)this._listEditorPanel, (String)helpId);
        }
        return this._listEditorPanel;
    }

    private static Object[] _convertListObjectToObjectArray(Object listObject) {
        if (listObject == null || "".equals(listObject)) {
            return new Object[0];
        }
        if (listObject instanceof List) {
            return ((List)listObject).toArray();
        }
        String listString = listObject.toString();
        String[] stringArray = listString.split(" ");
        ArrayList<String> newList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String item = stringArray[i];
            if (item == null || "".equals(item)) continue;
            newList.add(item);
        }
        return newList.toArray();
    }

    private static String _convertObjectArrayToListString(Object[] objectArray) {
        StringBuffer sb = new StringBuffer();
        int arrayLength = objectArray.length;
        for (int x = 0; x < arrayLength; ++x) {
            if (objectArray[x] == null || "".equals(objectArray[x])) continue;
            String item = objectArray[x].toString();
            if ("".equals(item = item.trim())) continue;
            if (item.indexOf(" ") >= 0) {
                Object[] splitString = item.split(" ");
                sb.append(ListEditor._convertObjectArrayToListString(splitString) + " ");
                continue;
            }
            sb.append(item + " ");
        }
        return sb.toString().trim();
    }
}

