/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.io.Serializable;

public class FillContainerLayoutManager
implements LayoutManager2,
Serializable {
    private static final Dimension _ZERO_SIZE = new Dimension(0, 0);

    protected Component getPrimaryComponent(Container parent) {
        if (parent.getComponentCount() == 0) {
            return null;
        }
        return parent.getComponent(0);
    }

    protected void layoutNonPrimaryComponents(Container parent, int x, int y, int width, int height) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Component c = this.getPrimaryComponent(parent);
        if (c == null) {
            return _ZERO_SIZE;
        }
        Dimension cpSize = c.getPreferredSize();
        Insets i = parent.getInsets();
        return new Dimension(cpSize.width + i.left + i.right, cpSize.height + i.top + i.bottom);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Component c = this.getPrimaryComponent(parent);
        if (c == null) {
            return _ZERO_SIZE;
        }
        Dimension cpSize = c.getMinimumSize();
        Insets i = parent.getInsets();
        return new Dimension(cpSize.width + i.left + i.right, cpSize.height + i.top + i.bottom);
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        Component c = this.getPrimaryComponent(parent);
        if (c == null) {
            return _ZERO_SIZE;
        }
        Dimension cpSize = c.getMaximumSize();
        Insets i = parent.getInsets();
        return new Dimension(cpSize.width + i.left + i.right, cpSize.height + i.top + i.bottom);
    }

    @Override
    public void layoutContainer(Container parent) {
        Rectangle b = parent.getBounds();
        Insets i = parent.getInsets();
        int w = b.width - i.right - i.left;
        int h = b.height - i.top - i.bottom;
        Component c = this.getPrimaryComponent(parent);
        if (c != null) {
            c.setBounds(i.left, i.top, w, h);
        }
        this.layoutNonPrimaryComponents(parent, i.left, i.top, w, h);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }
}

