/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xquery.XMLDataSource;
import oracle.xquery.XMLDataSourceIterator;
import oracle.xquery.XQException;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.ExprResultIterator;
import oracle.xquery.exec.OptimizeContext;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.Visitor;
import oracle.xquery.exec.XQueryUtils;
import org.w3c.dom.Node;

public class ExternalDataSrc
extends Expr {
    XMLDataSource sourceClass;

    public ExternalDataSrc(XMLDataSource xMLDataSource) {
        this.sourceClass = xMLDataSource;
    }

    public ExternalDataSrc(XMLDataSource xMLDataSource, Expr[] exprArray) {
        super(exprArray);
        this.sourceClass = xMLDataSource;
    }

    @Override
    public ExprResultIterator getIterator(QueryState queryState) {
        return new ExternalDataSrcIterator(this, queryState);
    }

    @Override
    public XMLNode toXML() {
        XMLElement xMLElement = (XMLElement)ExternalDataSrc.getDoc().createElement("ExtrnlDS");
        XMLNode xMLNode = (XMLNode)ExternalDataSrc.getDoc().createTextNode(this.sourceClass.getDataSourceName());
        xMLElement.appendChild((Node)xMLNode);
        return xMLElement;
    }

    @Override
    public Expr optimize(OptimizeContext optimizeContext) {
        if (optimizeContext != null) {
            optimizeContext.setXqPushdown(false);
        }
        return super.optimize(optimizeContext);
    }

    @Override
    public OXMLSequence Evaluate(QueryState queryState) {
        return this.EvaluateUsingIterator(queryState);
    }

    @Override
    public void acceptVisitor(Visitor visitor) {
    }

    static class ExternalDataSrcIterator
    implements ExprResultIterator {
        ExternalDataSrc outerDataSrc;
        XMLDataSourceIterator sourceClassIterator;
        QueryState qryState;
        OXMLItem[] datasrcParameters;

        public ExternalDataSrcIterator(ExternalDataSrc externalDataSrc, QueryState queryState) {
            this.outerDataSrc = externalDataSrc;
            this.qryState = queryState;
            if (this.outerDataSrc.sourceClass == null) {
                throw new XQException("Unable to find the data source");
            }
            if (this.outerDataSrc.kids != null) {
                this.datasrcParameters = new OXMLItem[this.outerDataSrc.kids.length];
                for (int i = 0; i < this.outerDataSrc.kids.length; ++i) {
                    this.datasrcParameters[i] = queryState.createItem();
                }
            }
            this.sourceClassIterator = this.outerDataSrc.sourceClass.getIterator();
        }

        @Override
        public void Restart() {
            if (this.outerDataSrc.kids != null) {
                int n = this.outerDataSrc.kids.length;
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    OXMLSequence oXMLSequence = this.outerDataSrc.kids[i].Evaluate(this.qryState);
                    this.datasrcParameters[i].copyItem(XQueryUtils.getSingleItem(oXMLSequence));
                    this.qryState.returnSequence(oXMLSequence);
                }
                this.sourceClassIterator.start(this.datasrcParameters);
            } else {
                this.sourceClassIterator.start();
            }
        }

        @Override
        public OXMLItem Fetch() {
            OXMLItem oXMLItem = this.qryState.createItem();
            if (this.sourceClassIterator.fetch(oXMLItem)) {
                return oXMLItem;
            }
            return null;
        }

        @Override
        public void Close() {
            this.sourceClassIterator.close();
        }
    }
}

