/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem;

import com.oracle.jdeveloper.nbwindowsystem.FreezeViewAction;
import com.oracle.jdeveloper.nbwindowsystem.JDevTopComponent;
import com.oracle.jdeveloper.nbwindowsystem.NbDockStation;
import com.oracle.jdeveloper.nbwindowsystem.NbEditorManager;
import com.oracle.jdeveloper.nbwindowsystem.NbMainWindow;
import com.oracle.jdeveloper.nbwindowsystem.NbView;
import com.oracle.jdeveloper.nbwindowsystem.NbWindowSystemFS;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseEvent;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.Site;
import oracle.ide.docking.TitleChangeEvent;
import oracle.ide.docking.TitleChangeListener;
import oracle.ide.layout.Layout;
import oracle.ide.layout.Layouts;
import oracle.ide.layout.ViewId;
import oracle.ide.util.BitField;
import oracle.ide.view.View;
import oracle.ideimpl.docking.DockableHook;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ui.tabcontrol.TabbedAdapter;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.TabbedContainer;
import org.openide.util.ImageUtilities;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;

public class NbDockableContainer
extends JDevTopComponent
implements TitleChangeListener {
    private static final String PREFERRED_ID = "DockableContainerTopComponent";
    protected String viewId;
    private Dockable dckbl;
    private View view;
    private Component gui;
    private ComponentListener siteUpdaterListener;
    private boolean layoutRelatedEvent;
    private AncestorListener ancestorListener;
    private boolean initialized = false;

    public NbDockableContainer() {
        this.putClientProperty("netbeans.winsys.tc.draganddrop_copy_disabled", Boolean.TRUE);
        this.initInputMap();
    }

    NbDockableContainer(Dockable dckbl) {
        this();
        this.viewId = NbDockStation.getId(dckbl);
        this.dckbl = dckbl;
        if (dckbl instanceof View) {
            this.view = (View)dckbl;
        }
    }

    public String getShortName() {
        if (null != this.dckbl) {
            return this.dckbl.getTabName();
        }
        return super.getShortName();
    }

    public int getPersistenceType() {
        return 0;
    }

    public Dimension getMinimumSize() {
        return new Dimension(10, 10);
    }

    final String getViewId() {
        return this.viewId;
    }

    protected void componentOpened() {
        JComponent newGui;
        if (!this.initialized) {
            boolean loadDataView = true;
            this.initialized = true;
            if (null != this.view) {
                if (null != this.dckbl) {
                    this.updateTitle();
                    NbDockStation.loadViewData(this.dckbl, (Layout)Layouts.getLayouts().getActiveLayout());
                    loadDataView = false;
                    this.gui = this.dckbl.getHostedComponent();
                    if (null != this.gui) {
                        this.contentPanel.add(this.gui, "Center");
                    }
                } else {
                    Toolbar tb;
                    this.setName(this.view.getId());
                    this.setDisplayName(this.view.getTabName());
                    this.gui = this.view.getGUI();
                    if (null != this.gui) {
                        this.contentPanel.add((Component)new JScrollPane(this.gui), "Center");
                    }
                    if (null != (tb = this.view.getToolbar())) {
                        this.contentPanel.add((Component)tb, "North");
                    }
                }
            } else {
                if (null == this.dckbl) {
                    DockableHook.get().loadPendingDockables();
                    DockStation ds = DockStation.getDockStation();
                    ViewId id = new ViewId(this.viewId);
                    this.dckbl = ds.findDockable(id);
                    if (null == this.dckbl) {
                        if (null == NbDockStation.getDockStation().lookupFactory(id)) {
                            Logger.getLogger(NbDockableContainer.class.getName()).log(Level.FINE, "Inactive DockableFactory " + this.viewId);
                        } else {
                            Logger.getLogger(NbDockableContainer.class.getName()).log(Level.INFO, "Cannot get dockable for id " + this.viewId);
                        }
                        this.initialized = false;
                        this.close();
                        return;
                    }
                    if (this.dckbl instanceof View) {
                        NbDockStation.loadViewData(this.dckbl, (Layout)Layouts.getLayouts().getActiveLayout());
                        loadDataView = false;
                        this.gui = this.dckbl.getHostedComponent();
                        this.setView((View)this.dckbl);
                    }
                }
                if (this.view == null) {
                    this.view = new NbView(this);
                }
                this.updateTitle();
                if (loadDataView) {
                    NbDockStation.loadViewData(this.dckbl, (Layout)Layouts.getLayouts().getActiveLayout());
                }
                this.gui = this.dckbl.getHostedComponent();
                if (null != this.gui) {
                    this.contentPanel.add(this.gui, "Center");
                }
            }
        } else if (this.dckbl != null && null != (newGui = this.dckbl.getHostedComponent()) && newGui != this.gui) {
            if (this.gui != null) {
                this.contentPanel.remove(this.gui);
            }
            this.gui = newGui;
            this.contentPanel.add(this.gui, "Center");
            this.contentPanel.invalidate();
            this.contentPanel.revalidate();
            this.contentPanel.repaint();
        }
        if (null != this.dckbl) {
            ((NbDockStation)DockStation.getDockStation()).dockableOpened(this.dckbl);
            this.addTitleChangeListener(this.dckbl);
            this.addSiteUpdaterListener();
        }
        this.addAncestorListener();
    }

    protected void componentClosed() {
        this.removeAncestorListener();
        if (null == this.dckbl) {
            return;
        }
        if (this.layoutRelatedEvent) {
            this.componentHidden();
        } else {
            ((NbDockStation)DockStation.getDockStation()).dockableClosed(this.dckbl);
            this.removeTitleChangeListener(this.dckbl);
            this.removeSiteUpdaterListener();
            if (this.gui != null) {
                this.contentPanel.remove(this.gui);
                this.gui = null;
            }
            if (this.getDockable() != null && BitField.isSet((int)this.getDockable().getType(), (int)1)) {
                NbWindowSystemFS.getDefault().unregister(this.dckbl);
            }
        }
        this.layoutRelatedEvent = false;
    }

    protected void componentHidden() {
        if (null != this.dckbl) {
            ((NbDockStation)DockStation.getDockStation()).dockableHidden(this.dckbl);
        }
    }

    protected void componentShowing() {
        if (null != this.dckbl) {
            ((NbDockStation)DockStation.getDockStation()).dockableShowing(this.dckbl);
        }
    }

    public Action[] getActions() {
        if (WindowManagerImpl.getInstance().isTopComponentMinimized((TopComponent)this) && TopComponent.getRegistry().getActivated() != this) {
            this.requestActive();
        }
        if (Ide.getMainWindow().getLastActiveView() != this.view && SwingUtilities.isEventDispatchThread()) {
            HierarchyEvent hierarchyEvent;
            if (EventQueue.getCurrentEvent() instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)EventQueue.getCurrentEvent();
                if (mouseEvent.getButton() == 3) {
                    ((NbMainWindow)Ide.getMainWindow()).setActiveView(this.view);
                }
            } else if (EventQueue.getCurrentEvent() instanceof HierarchyEvent && (hierarchyEvent = (HierarchyEvent)EventQueue.getCurrentEvent()).getSource() instanceof TabbedAdapter) {
                ((NbMainWindow)Ide.getMainWindow()).setActiveView(this.view);
            }
        }
        Action[] defaultActions = super.getActions();
        Action[] res = new Action[defaultActions.length + 3];
        System.arraycopy(defaultActions, 0, res, 0, defaultActions.length);
        res[res.length - 3] = null;
        IdeAction cloneAction = IdeActions.getViewNewViewAction();
        IdeAction freezeAction = IdeActions.getViewFreezeAction();
        cloneAction.updateAction();
        freezeAction.updateAction();
        res[res.length - 2] = cloneAction;
        res[res.length - 1] = FreezeViewAction.createFreezeViewAction();
        return res;
    }

    public void addNotify() {
        try {
            super.addNotify();
        }
        catch (NullPointerException ex) {
            System.out.println("Exception " + ex.getMessage());
            System.out.println("TopComponent/Dockable " + this.getName());
            boolean isDebugBuild = "true".equals(System.getProperty("ide.debugbuild"));
            if (isDebugBuild) {
                throw ex;
            }
            ex.printStackTrace();
        }
        this._adjustTabbedContainerNameForAbbot();
    }

    static NbDockableContainer find(Dockable dckbl) {
        if (dckbl == null) {
            return null;
        }
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        TopComponent persistedTc = wm.findTopComponent(NbWindowSystemFS.toTopComponentId(NbDockStation.getId(dckbl)));
        if (persistedTc instanceof NbDockableContainer) {
            return (NbDockableContainer)persistedTc;
        }
        Set opened = TopComponent.getRegistry().getOpened();
        String id = NbDockStation.getId(dckbl);
        if (null == id) {
            Logger.getLogger(NbDockableContainer.class.getName()).log(Level.INFO, "No id for Dockable: " + dckbl);
            return null;
        }
        for (TopComponent tc : opened) {
            if (!(tc instanceof NbDockableContainer)) continue;
            NbDockableContainer dockTc = (NbDockableContainer)tc;
            if (!id.equals(dockTc.viewId)) continue;
            return dockTc;
        }
        for (Mode m : wm.getModes()) {
            for (TopComponent tc : m.getTopComponents()) {
                if (!(tc instanceof NbDockableContainer)) continue;
                NbDockableContainer dockTc = (NbDockableContainer)tc;
                if (!id.equals(dockTc.viewId)) continue;
                return dockTc;
            }
        }
        return null;
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
        p.setProperty("viewId", this.viewId);
    }

    Object readProperties(Properties p) {
        this.readPropertiesImpl(p);
        return this;
    }

    protected void readPropertiesImpl(Properties p) {
        String version = p.getProperty("version");
        if ("1.0".equals(version)) {
            this.viewId = p.getProperty("viewId");
        }
    }

    protected String preferredID() {
        return PREFERRED_ID + this.viewId;
    }

    protected void setView(View view) {
        this.view = view;
        this.updateViewLookup(view);
    }

    protected View getView() {
        return this.view;
    }

    Component getGUI() {
        return this.gui;
    }

    Dockable getDockable() {
        return this.dckbl;
    }

    private void updateTitle() {
        String titleName = this.dckbl.getTitleName() != null ? this.dckbl.getTitleName() : "";
        this.setName(NbDockStation.getId(this.dckbl));
        this.setDisplayName(titleName);
        Icon icn = this.dckbl.getTabIcon();
        if (null != icn) {
            this.setIcon(ImageUtilities.icon2Image((Icon)icn));
        }
        this.setToolTipText(titleName);
    }

    private void addTitleChangeListener(Dockable dckbl) {
        this.removeTitleChangeListener(dckbl);
        if (dckbl instanceof DockableWindow) {
            ((DockableWindow)dckbl).addTitleChangeListener((TitleChangeListener)this);
        }
    }

    private void removeTitleChangeListener(Dockable dckbl) {
        if (dckbl instanceof DockableWindow) {
            ((DockableWindow)dckbl).removeTitleChangeListener((TitleChangeListener)this);
        }
    }

    private void addSiteUpdaterListener() {
        if (this.siteUpdaterListener == null) {
            this.siteUpdaterListener = new DockableSiteUpdater();
        } else {
            this.removeSiteUpdaterListener();
        }
        this.addComponentListener(this.siteUpdaterListener);
    }

    private void removeSiteUpdaterListener() {
        if (this.siteUpdaterListener != null) {
            this.addComponentListener(this.siteUpdaterListener);
            this.siteUpdaterListener = null;
        }
    }

    public void titleChange(TitleChangeEvent e) {
        this.updateTitle();
    }

    void markEventAsLayoutEvent() {
        this.layoutRelatedEvent = true;
    }

    @Override
    protected void componentActivated() {
        super.componentActivated();
        this.removeESCNetbeansAction();
    }

    private void initInputMap() {
        ActionMap amIde = Ide.getIdeActionMap();
        InputMap imIde = Ide.getIdeInputMap();
        InputMap im = this.getInputMap(1);
        ActionMap am = this.getActionMap();
        im.setParent(imIde);
        am.setParent(amIde);
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        NBDockableContainerActions a = new NBDockableContainerActions("aEditor");
        im.put(ks, a);
        am.put(a, a);
    }

    private void _adjustTabbedContainerNameForAbbot() {
        Component tabDisplayer = this.findTabDisplayer();
        if (null == tabDisplayer) {
            Logger.getLogger(NbDockableContainer.class.getName()).log(Level.INFO, "Cannot find TabDisplayer for Dockable " + this.viewId);
            return;
        }
        String name = tabDisplayer.getName();
        if (null == name || name.isEmpty() || "Tab Displayer".equals(name)) {
            tabDisplayer.setName("TabDisplayer_" + this.viewId);
        }
    }

    private Component findTabDisplayer() {
        TabbedContainer tc = (TabbedContainer)SwingUtilities.getAncestorOfClass(TabbedContainer.class, (Component)((Object)this));
        if (null != tc) {
            for (Component c : tc.getComponents()) {
                if (!(c instanceof TabDisplayer)) continue;
                return c;
            }
        }
        return null;
    }

    private void addAncestorListener() {
        this.removeAncestorListener();
        this.ancestorListener = new FocusAncestorListener();
        this.addAncestorListener(this.ancestorListener);
    }

    private void removeAncestorListener() {
        if (this.ancestorListener != null) {
            this.removeAncestorListener(this.ancestorListener);
            this.ancestorListener = null;
        }
    }

    final void removeESCNetbeansAction() {
        Action action = this.getActionMap().get("return");
        if (action != null) {
            this.getActionMap().remove("return");
            this.getActionMap().remove(action);
            this.initInputMap();
        }
    }

    private class FocusAncestorListener
    implements AncestorListener {
        private FocusAncestorListener() {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            this.updateFocus();
            this.makeSureSomeComponentHasFocus();
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            this.updateFocus();
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
            this.updateFocus();
        }

        private void updateFocus() {
            if (TopComponent.getRegistry().getActivated() == NbDockableContainer.this && NbDockableContainer.this.getGUI() != null && !NbDockableContainer.this.getGUI().hasFocus() && NbDockableContainer.this.isOpened() && NbDockableContainer.this.isVisible() && !Ide.isStarting()) {
                this.setFocus();
            }
        }

        private void setFocus() {
            JDevTopComponent.activateTCWithoutFocusIfPossible((TopComponent)NbDockableContainer.this);
            NbDockableContainer.this.requestActive();
            NbDockableContainer.this.getGUI().requestFocusInWindow();
        }

        private void makeSureSomeComponentHasFocus() {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    Component c = FocusManager.getCurrentManager().getFocusOwner();
                    if (c == null) {
                        FocusAncestorListener.this.updateFocus();
                    }
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    private class DockableSiteUpdater
    implements ComponentListener {
        private DockableSiteUpdater() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.updateDockableSite();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.updateDockableSite();
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.updateDockableSite();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        private void updateDockableSite() {
            if (NbDockableContainer.this.dckbl == null) {
                return;
            }
            Site site = NbDockableContainer.this.dckbl.getSite();
            if (site == null) {
                return;
            }
            JDialog dialog = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, (Component)((Object)NbDockableContainer.this));
            int X = 0;
            int Y = 0;
            if (dialog != null) {
                X = dialog.getX();
                Y = dialog.getY();
            } else {
                X = NbDockableContainer.this.getX();
                Y = NbDockableContainer.this.getY();
            }
            site.geometry = new Rectangle(X, Y, NbDockableContainer.this.getWidth(), NbDockableContainer.this.getHeight());
            site.size = NbDockableContainer.this.getSize();
        }
    }

    private class NBDockableContainerActions
    extends AbstractAction {
        private static final String CMD_ACTIVATE_EDITOR = "aEditor";

        NBDockableContainerActions(String sCmd) {
            this.init(sCmd);
        }

        private void init(String sCmd) {
            this.putValue("ActionCommandKey", sCmd);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String sActionCommand = (String)this.getValue("ActionCommandKey");
            if (sActionCommand == CMD_ACTIVATE_EDITOR) {
                this.whenActivateEditors();
            }
        }

        private void whenActivateEditors() {
            NbEditorManager em = NbEditorManager.getInstance();
            em.activateCurrentEditorFrame(false);
            Ide.getMainWindow().toFront();
        }
    }
}

