/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem.plaf;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.openide.awt.ToolbarPool;
import org.openide.util.ImageUtilities;

public class ToolbarDragger
extends JLabel {
    private static final Icon realIcon = ImageUtilities.loadImageIcon((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/toolbar_dragger.png", (boolean)true);
    private static final Icon emptyIcon = new EmptyIcon(realIcon);
    private static boolean draggerShowing = false;

    public ToolbarDragger() {
        this.setText(null);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }

    @Override
    public Icon getIcon() {
        return draggerShowing ? realIcon : emptyIcon;
    }

    public static AWTEventListener createMouseMotionListener() {
        return new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                if (event instanceof MouseEvent) {
                    MouseEvent e = (MouseEvent)event;
                    Point loc = e.getLocationOnScreen();
                    ToolbarPool toolbars = ToolbarPool.getDefault();
                    SwingUtilities.convertPointFromScreen(loc, (Component)toolbars);
                    boolean showDraggers = toolbars.contains(loc);
                    if (showDraggers != draggerShowing) {
                        draggerShowing = showDraggers;
                        toolbars.repaint();
                    }
                }
            }
        };
    }

    private static class EmptyIcon
    implements Icon {
        private final Icon realIcon;

        public EmptyIcon(Icon realIcon) {
            this.realIcon = realIcon;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return this.realIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.realIcon.getIconHeight();
        }
    }
}

