/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.FileField;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizerAdapter;
import oracle.jdevimpl.vcs.svn.res.Resource;

public final class PatchOptionsCustomizer
extends VCSOptionsCustomizerAdapter {
    public static final String PATCH_PATH = "svn-patch-path";
    public static final String PATCH_OPEN = "svn-patch-open";
    public static final String PATCH_GIT = "svn-patch-git";
    private PatchPanel _ui = new PatchPanel();

    public Component getComponent() {
        return this._ui;
    }

    public void setOptions(Map opts) {
        String patchPath = (String)opts.get(PATCH_PATH);
        this._ui.setDestination(patchPath);
        Boolean open = (Boolean)opts.get(PATCH_OPEN);
        this._ui.setOpen(open);
        Boolean git = (Boolean)opts.get(PATCH_GIT);
        this._ui.setGitFormat(git);
    }

    public Map getOptions() {
        HashMap<String, Object> opts = new HashMap<String, Object>(5);
        opts.put(PATCH_PATH, this._ui.getDestination());
        opts.put(PATCH_OPEN, this._ui.isOpen());
        opts.put(PATCH_GIT, this._ui.isGitFormat());
        return opts;
    }

    public void validateOptions() throws VCSException {
        Map opts = this.getOptions();
        String destination = (String)opts.get(PATCH_PATH);
        if (destination.isEmpty()) {
            throw new VCSException(Resource.get("CREATE_PATCH_DEST_TITLE"), Resource.get("CREATE_PATCH_DEST_EMPTY"));
        }
        URL destUrl = URLFactory.newURL((String)destination);
        if (URLFileSystem.exists((URL)destUrl)) {
            throw new VCSException(Resource.get("CREATE_PATCH_DEST_TITLE"), Resource.format("CREATE_PATCH_DEST_EXIST", destination));
        }
        URL parent = this.getParentExist(URLFileSystem.getParent((URL)destUrl));
        if (parent == null) {
            throw new VCSException(Resource.get("CREATE_PATCH_DEST_TITLE"), Resource.get("CREATE_PATCH_DEST_NOTEXIST"));
        }
        if (!URLFileSystem.canWrite((URL)parent)) {
            throw new VCSException(Resource.get("CREATE_PATCH_DEST_TITLE"), Resource.format("CREATE_PATCH_DEST_PARENT", URLFileSystem.getPlatformPathName((URL)parent)));
        }
    }

    private URL getParentExist(URL url) {
        while (!URLFileSystem.exists((URL)url)) {
            if ((url = URLFileSystem.getParent((URL)url)) != null) continue;
            return null;
        }
        return url;
    }

    private static class PatchPanel
    extends JPanel {
        private FileField _fldFile;
        private JLabel _lblFile;
        private JButton _browse;
        private JCheckBox _ckOpen;
        private JCheckBox _chGit;

        PatchPanel() {
            super(new GridBagLayout());
            this.createComponents();
            this.layoutComponents();
            this.addListeners();
        }

        private void createComponents() {
            this._lblFile = new JLabel();
            this._fldFile = new FileField();
            this._browse = new JButton();
            this._ckOpen = new JCheckBox();
            this._chGit = new JCheckBox();
            ResourceUtils.resLabel((JLabel)this._lblFile, (Component)this._fldFile, (String)Resource.get("CREATE_PATCH_DESTINATION"));
            ResourceUtils.resButton((AbstractButton)this._browse, (String)Resource.get("CREATE_PATCH_BROWSE"));
            ResourceUtils.resButton((AbstractButton)this._ckOpen, (String)Resource.get("CREATE_PATCH_OPEN"));
            ResourceUtils.resButton((AbstractButton)this._chGit, (String)Resource.get("CREATE_PATCH_GIT"));
        }

        private void layoutComponents() {
            this.add((Component)this._chGit, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
            this.add((Component)this._lblFile, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 2, 5), 0, 0));
            this.add((Component)this._fldFile, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
            this.add((Component)this._browse, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
            this.add((Component)this._ckOpen, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        }

        private void setDestination(String patchPath) {
            this._fldFile.setText(patchPath);
        }

        private String getDestination() {
            return this._fldFile.getText();
        }

        private void setOpen(Boolean open) {
            this._ckOpen.setSelected(open);
        }

        private boolean isOpen() {
            return this._ckOpen.isSelected();
        }

        private boolean isGitFormat() {
            return this._chGit.isSelected();
        }

        private void setGitFormat(Boolean git) {
            this._chGit.setSelected(git);
        }

        private void addListeners() {
            this._browse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    URL current = URLFactory.newFileURL((String)_fldFile.getText());
                    URLChooser chooser = DialogUtil.newURLChooser((URL)current);
                    chooser.setSelectionMode(0);
                    if (chooser.showOpenDialog((Component)this) == 0) {
                        _fldFile.setText(URLFileSystem.getPlatformPathName((URL)chooser.getSelectedURL()));
                    }
                }
            });
        }
    }
}

