/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.repos;

import java.net.URL;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ideri.importexport.ExportWizard;
import oracle.ideri.importexport.ImportWizard;
import oracle.javatools.util.ImageIconCache;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNavigatorAPI;
import oracle.jdevimpl.vcs.svn.repos.SVNRepositoryManager;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.ui.SVNRepositoryImportExportPanel;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;

public final class SVNRepositoryImportExportWizard
implements ExportWizard,
ImportWizard {
    public String getExportWizardName(Context context) {
        return Resource.get("REPOS_CONN_EXP_IMP_NAME");
    }

    public String getImportWizardName(Context context) {
        return Resource.get("REPOS_CONN_EXP_IMP_NAME");
    }

    public Icon getExportWizardIcon(Context context) {
        return ImageIconCache.get((URL)Resource.class.getResource(Resource.get("NAV_ICON_REPOSITORIES_NODE")));
    }

    public Icon getImportWizardIcon(Context context) {
        return ImageIconCache.get((URL)Resource.class.getResource(Resource.get("NAV_ICON_REPOSITORIES_NODE")));
    }

    public String getExportWizardTooltipText(Context context) {
        return Resource.get("REPOS_CONN_EXP_TOOLTIP");
    }

    public String getImportWizardTooltipText(Context context) {
        return Resource.get("REPOS_CONN_IMP_TOOLTIP");
    }

    public boolean isAvailableAsExportWizard(Context context) {
        VCSProfile activeProfile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion");
        if (activeProfile != null) {
            return "oracle.jdeveloper.subversion".equals(activeProfile.getID()) && !SVNRepositoryManager.getInstance().isEmpty();
        }
        return false;
    }

    public boolean isAvailableAsImportWizard(Context context) {
        return true;
    }

    public boolean invokeExportWizard(Context context, String[] params) {
        SVNRepositoryImportExportPanel ui = new SVNRepositoryImportExportPanel();
        ui.setImportMode(false);
        ui.setExplanatoryText(Resource.get("REPOS_CONN_EXP_DIALOG_HINT"));
        return ui.runDialog(VCSWindowUtils.getCurrentWindow(), Resource.get("REPOS_CONN_EXP_DIALOG_TITLE"), "f1_svnexportsvnconnections_html");
    }

    public boolean invokeImportWizard(Context context, String[] params) {
        SVNRepositoryImportExportPanel ui = new SVNRepositoryImportExportPanel();
        ui.setImportMode(true);
        ui.setExplanatoryText(Resource.get("REPOS_CONN_IMP_DIALOG_HINT"));
        if (ui.runDialog(VCSWindowUtils.getCurrentWindow(), Resource.get("REPOS_CONN_IMP_DIALOG_TITLE"), "f1_svnimportsvnconnections_html")) {
            SVNUtil.usageTrackerLog();
            SVNRepositoryNavigatorAPI.getInstance().showRepositoryNavigator();
            return true;
        }
        return false;
    }
}

