/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.controls;

import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.Comparator;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.PopupMenuListener;
import oracle.dbtools.raptor.controls.Bug4199622Fix;
import oracle.dbtools.raptor.onsd.OnsdBrowserResources;
import oracle.dbtools.raptor.onsd.connection.NSConnections;
import oracle.ide.controls.SortedComboBoxModel;

public class OnsdConnectionComboBox {
    private JComboBox m_combo;
    private DefaultComboBoxModel m_model;

    public final JComboBox getComboBox() {
        if (this.m_combo == null) {
            this.m_model = this.createModel();
            this.m_combo = this.createCombo(this.m_model);
        }
        return this.m_combo;
    }

    protected JComboBox createCombo(ComboBoxModel comboBoxModel) {
        JComboBox jComboBox = new JComboBox(comboBoxModel);
        jComboBox.setToolTipText(OnsdBrowserResources.getString("SELECTOR_TOOLTIP"));
        jComboBox.addActionListener((ActionListener)Bug4199622Fix.INSTANCE);
        jComboBox.addPopupMenuListener((PopupMenuListener)Bug4199622Fix.INSTANCE);
        return jComboBox;
    }

    protected DefaultComboBoxModel createModel() {
        SortedComboBoxModel sortedComboBoxModel = new SortedComboBoxModel();
        sortedComboBoxModel.setComparator((Comparator)new Comparator<Object>(){

            @Override
            public int compare(Object object, Object object2) {
                return Collator.getInstance().compare(object, object2);
            }
        });
        for (String string : NSConnections.getInstance().listConnections()) {
            sortedComboBoxModel.addElement((Object)string);
        }
        return sortedComboBoxModel;
    }

    public String getCurrentConnectionName() {
        if (this.m_combo != null && this.m_combo.getItemCount() > 0) {
            return (String)this.m_combo.getSelectedItem();
        }
        return null;
    }
}

