/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.controls.display;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.controls.display.DisplayAdapter;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.ISelectionChangeListener;
import oracle.dbtools.raptor.controls.grid.GridFilterField;
import oracle.dbtools.raptor.controls.grid.IRowIterator;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.dbtools.raptor.controls.grid.RaptorGridTaskWrapper;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.onsd.Messages;
import oracle.dbtools.raptor.onsd.controls.grid.OnsdIteratorTable;
import oracle.dbtools.raptor.onsd.controls.grid.OnsdIteratorTableModel;
import oracle.dbtools.raptor.onsd.iterator.OnsdQueryFactory;
import oracle.dbtools.raptor.onsd.navigator.OnsdObject;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.view.View;
import oracle.javatools.controls.JMenuSorter;

public class DisplayOnsdIterator
extends DisplayAdapter
implements ISelectionChangeListener {
    private static Logger logger = Logger.getLogger(DisplayOnsdIterator.class.getName());
    protected OnsdIteratorTable _grid;
    protected Map<String, Object> _binds;
    protected DisplayRTContextMenuListener _menu;
    protected boolean _closing = false;
    protected List<ObjectAction> _actions;
    protected String uri;
    public static final int _delay = 1000;
    protected RefreshChecker _refreshChecker;
    private IRaptorTaskListener notifyEditorHeadersChanged = new RaptorTaskAdapter(){

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            SwingUtilities.invokeLater(new EditorHeadersChange());
        }
    };

    public DisplayOnsdIterator() {
        this.setExtValues(new HashMap());
        this.uri = null;
    }

    public void setUriString(String string) {
        this.uri = string;
    }

    public void initTable() {
        if (this._grid == null) {
            this._grid = new OnsdIteratorTable();
            this._grid.setView(this.getView());
            this._refreshChecker = new RefreshChecker(1000);
            this._grid.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!DisplayOnsdIterator.this._closing && !listSelectionEvent.getValueIsAdjusting()) {
                        int n = DisplayOnsdIterator.this._grid.getSelectedRow();
                        if (!DisplayOnsdIterator.this._refreshChecker.isRunning()) {
                            DisplayOnsdIterator.this._refreshChecker.setLastSelectedRow(n);
                            DisplayOnsdIterator.this._refreshChecker.start();
                        } else {
                            DisplayOnsdIterator.this._refreshChecker.setLastSelectedRow(n);
                            DisplayOnsdIterator.this._refreshChecker.restart();
                        }
                    }
                }
            });
            this._menu = new DisplayRTContextMenuListener(this);
            this._grid.addLocalContextMenuListener(this._menu);
        }
        this._grid.setMinimumSize(new Dimension(200, 200));
    }

    public void setToolbar(Toolbar toolbar) {
        super.setToolbar(toolbar);
        this.initTable();
        this.getGrid().setToolbar(toolbar);
    }

    public JComponent getUI() {
        logger.finer("OnsdIteratorTable.getUI()");
        this.initTable();
        return this._grid;
    }

    public void close() {
        logger.finer("OnsdIteratorTable.close()");
        this._binds = null;
        this._closing = true;
        if (this._grid != null) {
            this._grid.closeModel();
        }
        if (this._menu != null) {
            RaptorGridTable.removeGridContextMenu((GridContextMenuItem)this._menu);
        }
        if (this._refreshChecker != null) {
            this._refreshChecker.stop();
        }
        if (this._grid != null && this._grid.getParent() != null) {
            this._grid.getParent().remove((Component)((Object)this._grid));
        }
        this._grid = null;
        super.close();
    }

    public void refresh(boolean bl) {
        logger.finer("OnsdIteratorTable.refresh(" + bl + ")");
        if (this._grid == null) {
            this.initTable();
        }
        this._grid.clearSelection();
        if (bl || this._grid.getGridModel() == null || this.isDirty()) {
            this.updateQuery(this.getIterator());
            try {
                ArrayList<IRaptorTaskListener> arrayList = new ArrayList<IRaptorTaskListener>();
                if (this._taskListener != null) {
                    arrayList.add(this._taskListener);
                }
                arrayList.add(this.notifyEditorHeadersChanged);
                this.openGrid(arrayList);
            }
            catch (ExecutionException executionException) {
                logger.severe(executionException.getLocalizedMessage());
                return;
            }
            this.setDirty(false);
        } else {
            try {
                this._grid.refresh();
                this.setDirty(false);
            }
            catch (ExecutionException executionException) {
                logger.severe(executionException.getLocalizedMessage());
                return;
            }
        }
    }

    protected IRowIterator getIterator() {
        View view = this.getView();
        OnsdObject onsdObject = (OnsdObject)((ViewerNode)view.getContext().getNode()).getDBObject().getNode();
        String string = onsdObject.getName();
        String string2 = onsdObject.getConnectionName();
        return OnsdQueryFactory.getInstance().getTableIterator(string2, this.uri, string);
    }

    protected void addMouseMoveListener(Component component) {
    }

    protected void openGrid(List<IRaptorTaskListener> list) throws ExecutionException {
        GridFilterField gridFilterField;
        this._grid.open(new RaptorGridTaskWrapper(Messages.getString("OnsdIteratorLabel"), IRaptorTaskRunMode.MODAL_OPTIONAL, true, list, null, null));
        if (this._grid.getController() != null && (gridFilterField = this._grid.getController().getGridFilterField()) != null) {
            gridFilterField.reset();
        }
    }

    protected void updateQuery(IRowIterator iRowIterator) {
        String string = (String)this.getExtValues().get("TYPE");
        if (string != null && string.equalsIgnoreCase("vertical")) {
            this._grid.setVerticalDisplay(true);
        }
        this._grid.setQuery(this.getConnName(), iRowIterator);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DisplayOnsdIterator.this._grid.getController().addToolBarActions(DisplayOnsdIterator.this.getToolbar());
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                DisplayOnsdIterator.this._grid.getController().addContextMenuActions(DisplayOnsdIterator.this.getContextMenu());
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable2.run();
        } else {
            SwingUtilities.invokeLater(runnable2);
        }
    }

    public void parentSelectionChanged() {
    }

    public void addActions(List<ObjectAction> list) {
        this._actions = list;
    }

    public void clear() {
        if (this._grid != null && this._grid.getModel() != null && this._grid.getModel() instanceof OnsdIteratorTableModel) {
            this._grid.clearSelection();
            ((OnsdIteratorTableModel)((Object)this._grid.getModel())).closeModel();
        }
    }

    public OnsdIteratorTable getGrid() {
        return this._grid;
    }

    public boolean isUpdatable() {
        return true;
    }

    public Component getScrollableLeftMargin() {
        return null == this._grid ? null : this._grid.getRowHeader();
    }

    public Component getScrollableTopMargin() {
        return null == this._grid ? null : this._grid.getTableHeader();
    }

    public JScrollPane getScrollableUI() {
        JScrollPane jScrollPane = super.getScrollableUI();
        jScrollPane.setRowHeaderView(this.getScrollableLeftMargin());
        jScrollPane.setColumnHeaderView(this.getScrollableTopMargin());
        return jScrollPane;
    }

    public ContextMenu getContextMenu() {
        return null == this._grid ? null : this._grid.getContextMenu();
    }

    public void setView(View view) {
        super.setView(view);
        if (this._grid != null) {
            this._grid.setView(this.getView());
            if (this._grid.getController() != null) {
                this._grid.getController().setView(this.getView());
            }
        }
    }

    private class RefreshChecker
    extends Timer {
        int lastSelectedRow;
        ActionListener listener;

        public RefreshChecker(int n) {
            super(n, null);
            this.lastSelectedRow = -1;
            this.listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    if (DisplayOnsdIterator.this._grid != null && (n = DisplayOnsdIterator.this._grid.getSelectedRow()) == RefreshChecker.this.lastSelectedRow && n < DisplayOnsdIterator.this._grid.getLoadedRowCount()) {
                        RefreshChecker.this.lastSelectedRow = n;
                        DisplayOnsdIterator.this.fireSelectionChanged();
                    }
                }
            };
            this.addActionListener(this.listener);
            this.setRepeats(false);
        }

        void setLastSelectedRow(int n) {
            this.lastSelectedRow = n;
        }
    }

    public class DisplayRTContextMenuListener
    extends GridContextMenuItem {
        JMenu reports;
        JMenu auto;
        private DisplayOnsdIterator _display;
        boolean showA;

        DisplayRTContextMenuListener(DisplayOnsdIterator displayOnsdIterator2) {
            this._display = displayOnsdIterator2;
        }

        public boolean canShow(ContextMenu contextMenu) {
            boolean bl = false;
            this.reports = contextMenu.createMenu(Messages.getString("OnsdIteratorTable.14"), (float)StringUtils.getMnemonicKeyCode((String)Messages.getString("OnsdIteratorTable.15")));
            JMenuSorter.registerJMenu((JMenu)this.reports);
            this.showA = false;
            if (this._table != null && this._table == this._display.getGrid()) {
                contextMenu.getContext().setProperty("ObjectAction.EVENT", (Object)contextMenu.getContext().getEvent());
                contextMenu.getContext().setProperty("ObjectAction.TARGET.KEY", (Object)this._display);
                contextMenu.getContext().setProperty("ObjectAction.CONN_NAME", (Object)this._display.getConnName());
                if (DisplayOnsdIterator.this._actions != null) {
                    for (ObjectAction objectAction : DisplayOnsdIterator.this._actions) {
                        JMenuItem jMenuItem = objectAction.getMenuItem(contextMenu);
                        objectAction.putProperty("CONTEXT", (Object)contextMenu.getContext());
                        objectAction.putProperty("DISPLAY", (Object)this);
                        objectAction.putProperty("ACTION_TYPE", (Object)"REPORT");
                        if (objectAction.getMetaClass() == DisplayOnsdIterator.getDrillActionClass()) {
                            this.reports.add(jMenuItem);
                            this.showA = true;
                            continue;
                        }
                        contextMenu.add((Component)jMenuItem);
                    }
                }
                if (this.showA) {
                    contextMenu.add((Component)this.reports);
                    bl = true;
                }
            }
            return bl;
        }

        protected void createAndShowMenu(ContextMenu contextMenu) {
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            return true;
        }

        public boolean update(IdeAction ideAction, Context context) {
            return true;
        }

        public String getID() {
            if (this._display == null) {
                return null;
            }
            return this._display.getId();
        }

        public DisplayModel getDisplayModel() {
            if (this._display == null) {
                return null;
            }
            return this._display.getDisplayModel();
        }
    }

    private class EditorHeadersChange
    implements Runnable {
        private EditorHeadersChange() {
        }

        @Override
        public void run() {
            JTable jTable = DisplayOnsdIterator.this._grid.getRowHeader();
            jTable.setModel((TableModel)DisplayOnsdIterator.this._grid.getGridModel().getRowHeaderModel());
            jTable.setSize(jTable.getPreferredSize());
            if (DisplayOnsdIterator.this.hasScrollableUI()) {
                JScrollPane jScrollPane = DisplayOnsdIterator.this.getScrollableUI();
                jScrollPane.setRowHeaderView(jTable);
                jScrollPane.setColumnHeaderView(DisplayOnsdIterator.this._grid.getTableHeader());
            } else {
                DisplayOnsdIterator.this.firePropertyChangeEvent("scrollable_left_margin", null, jTable);
                DisplayOnsdIterator.this.firePropertyChangeEvent("scrollable_top_margin", null, DisplayOnsdIterator.this._grid.getTableHeader());
            }
        }
    }
}

