/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import oracle.ide.file.Path;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.java.JavaModelFactory;
import oracle.jdeveloper.java.classpath.ClasspathTreeVisitOptions;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.ClassLocatorFactory;
import oracle.jdeveloper.java.locator.JdevClassLocatorFactory;
import oracle.jdeveloper.library.Library;

public class LibraryClassLocator
extends BaseClassLocator {
    protected Library _library;
    protected BaseClassLocator _classLocator;
    protected boolean _hasNoClassPath;
    protected BaseClassLocator _sourceLocator;

    public LibraryClassLocator(Library library) {
        ClassLocatorFactory factory = JavaModelFactory.getInstance().getLocatorFactory();
        this._library = library;
        URLPath sourcePath = library.getSourcePath();
        this._sourceLocator = LibraryClassLocator.ensureValid((BaseClassLocator)factory.getSourceLocator(sourcePath));
        URLPath classPath = library.getClassPath();
        this._classLocator = LibraryClassLocator.ensureValid((BaseClassLocator)factory.getClassLocator(classPath));
        this._hasNoClassPath = classPath == null || classPath.size() == 0;
    }

    public LibraryClassLocator(Workspace workspace, Library library) {
        this.init(workspace, library);
    }

    protected void init(Workspace workspace, Library library) {
        this._library = library;
        Path sourcePath = Path.getInstance((URLPath)library.getSourcePath());
        this._sourceLocator = LibraryClassLocator.ensureValid((BaseClassLocator)JdevClassLocatorFactory.getSourceLocator(workspace, sourcePath));
        Path classPath = Path.getInstance((URLPath)library.getClassPath());
        this._classLocator = LibraryClassLocator.ensureValid((BaseClassLocator)JdevClassLocatorFactory.getClassLocator(workspace, classPath));
        this._hasNoClassPath = classPath == null || classPath.size() == 0;
    }

    public void buildIndex() {
        this._classLocator.buildIndex();
        if (this._hasNoClassPath) {
            this._sourceLocator.buildIndex();
        }
    }

    public void buildIndexInterruptibly() throws InterruptedException {
        LibraryClassLocator.checkInterrupt();
        this._classLocator.buildIndex();
        if (this._hasNoClassPath) {
            LibraryClassLocator.checkInterrupt();
            this._sourceLocator.buildIndex();
        }
    }

    public void getPackages(String packagePrefix, Collection<String> out) {
        this._classLocator.getPackages(packagePrefix, out);
        if (this._hasNoClassPath) {
            this._sourceLocator.getPackages(packagePrefix, out);
        }
    }

    public void getPackagesInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        LibraryClassLocator.checkInterrupt();
        this._classLocator.getPackagesInterruptibly(packagePrefix, out);
        LibraryClassLocator.checkInterrupt();
        if (this._hasNoClassPath) {
            this._sourceLocator.getPackagesInterruptibly(packagePrefix, out);
        }
    }

    public void getClassesInPackage(String packagePrefix, Collection<String> out) {
        this._classLocator.getClassesInPackage(packagePrefix, out);
        if (this._hasNoClassPath) {
            this._sourceLocator.getClassesInPackage(packagePrefix, out);
        }
    }

    public void getClassesInPackageInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        LibraryClassLocator.checkInterrupt();
        this._classLocator.getClassesInPackageInterruptibly(packagePrefix, out);
        LibraryClassLocator.checkInterrupt();
        if (this._hasNoClassPath) {
            this._sourceLocator.getClassesInPackageInterruptibly(packagePrefix, out);
        }
    }

    public void getAllClasses(Collection<String> out, ClassNameFilter filter) {
        this._classLocator.getAllClasses(out, filter);
        if (this._hasNoClassPath) {
            this._sourceLocator.getAllClasses(out, filter);
        }
    }

    public void getAllClassesInterruptibly(Collection<String> out, ClassNameFilter filter) throws InterruptedException {
        LibraryClassLocator.checkInterrupt();
        this._classLocator.getAllClassesInterruptibly(out, filter);
        LibraryClassLocator.checkInterrupt();
        if (this._hasNoClassPath) {
            this._sourceLocator.getAllClassesInterruptibly(out, filter);
        }
    }

    public void getAllPackages(Collection<String> out, PackageNameFilter filter) {
        this._classLocator.getAllPackages(out, filter);
        if (this._hasNoClassPath) {
            this._sourceLocator.getAllPackages(out, filter);
        }
    }

    public void getAllPackagesInterruptibly(Collection<String> out, PackageNameFilter filter) throws InterruptedException {
        LibraryClassLocator.checkInterrupt();
        this._classLocator.getAllPackagesInterruptibly(out, filter);
        LibraryClassLocator.checkInterrupt();
        if (this._hasNoClassPath) {
            this._sourceLocator.getAllPackagesInterruptibly(out, filter);
        }
    }

    public URL getURL(String fqClassName) {
        URL url = this.getClassURL(fqClassName);
        if (this._hasNoClassPath && url == null) {
            url = this.getSourceURL(fqClassName);
        }
        return url;
    }

    public URL getURLInterruptibly(String fqClassName) throws InterruptedException {
        URL url = this.getClassURLInterruptibly(fqClassName);
        if (this._hasNoClassPath && url == null) {
            url = this.getSourceURLInterruptibly(fqClassName);
        }
        return url;
    }

    public URL getSourceURL(String fqClassName) {
        return this._sourceLocator.getSourceURL(fqClassName);
    }

    public URL getSourceURLInterruptibly(String fqClassName) throws InterruptedException {
        return this._sourceLocator.getSourceURLInterruptibly(fqClassName);
    }

    public URL getClassURL(String fqClassName) {
        return this._classLocator.getClassURL(fqClassName);
    }

    public URL getClassURLInterruptibly(String fqClassName) throws InterruptedException {
        return this._classLocator.getClassURLInterruptibly(fqClassName);
    }

    public URL getResourceURL(String resourceName) {
        return this._classLocator.getResourceURL(resourceName);
    }

    public String getModuleNameOfClass(String fqClassName) {
        return this._classLocator.getModuleNameOfClass(fqClassName);
    }

    public String getModuleNameOfClassInterruptibly(String fqClassName) throws InterruptedException {
        return this._classLocator.getModuleNameOfClassInterruptibly(fqClassName);
    }

    protected Object getClasspathTreeNode() {
        return this._library;
    }

    protected Collection<BaseClassLocator> getChildLocators(EnumSet<ClasspathTreeVisitOptions> options) {
        ArrayList<BaseClassLocator> list = new ArrayList<BaseClassLocator>(2);
        list.add(this._classLocator);
        if (options.contains(ClasspathTreeVisitOptions.INCLUDE_SOURCE)) {
            list.add(this._sourceLocator);
        }
        return list;
    }

    protected BaseClassLocator getSourceLocator(BaseClassLocator locator) {
        if (locator == this._classLocator) {
            return this._sourceLocator;
        }
        return super.getSourceLocator(locator);
    }
}

