/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.navigator;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.AddContentCommand;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.RadioMenuItem;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.ContentSet;
import oracle.ide.model.ContentSetProviderReference;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.Workspace;
import oracle.ide.model.panels.ProjectContentNavigable;
import oracle.ide.model.panels.ProjectPropertiesDialog;
import oracle.ide.navigator.NavigatorInit;
import oracle.ide.navigator.NavigatorMenuConstants;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.navigator.ProjectNavigatorManager;
import oracle.ide.navigator.Res;
import oracle.ide.navigator.ViewSupport;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.ModelArb;
import oracle.ide.resource.NavigatorArb;
import oracle.ide.resource.PanelsArb;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.View;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public final class ContentSetSupport
extends NavigatorInit
implements Controller {
    public static final int ADD_URL_TO_PROJECT_CMD_ID = AddContentCommand.ADD_URL_TO_PROJECT_CMD_ID;
    public static final int ADD_TO_PROJECT_CMD_ID = AddContentCommand.ADD_TO_PROJECT_CMD_ID;
    private static final String TOGGLE_DIRS_CMD = "ContentSetSupport.toggleDirs";
    private static final int TOGGLE_DIRS_CMD_ID = Ide.findOrCreateCmdID((String)"ContentSetSupport.toggleDirs");
    private static IdeAction _toggleDirsAction;
    private static final boolean DEFAULT_SHOW_DIRS = false;
    private boolean _showDirs = false;
    private static final int DEFAULT_FLAT_LEVEL = 3;
    private int _flatLevel = 3;
    private final HashMap _flatLevelLocalActions = new HashMap();
    private static final int WEBCONTENT_DEFAULT_FLAT_LEVEL = 1;
    private int _webContentFlatLevel = 1;
    private final HashMap _webContentFlatLevelLocalActions = new HashMap();
    private static final String TOGGLE_SORT_BY_TYPE_CMD = "ContentSetSupport.sortByType";
    private static final int TOGGLE_SORT_BY_TYPE_CMD_ID;
    private static IdeAction _toggleSortByTypeAction;
    private static final boolean DEFAULT_SORT_BY_TYPE = false;
    private boolean _sortByType = false;
    private final ToggleAction _displayOptionsNonAction = new DisplayOptionsNonAction();
    private final MenuToolButton _displayOptionsMenu = new MenuToolButton(this._displayOptionsNonAction);
    private static IdeAction _addFileToProjectAction;

    public static void init() {
        ContentSetSupport.maybeInitToggleDirsAction();
        ContentSetSupport.maybeInitToggleSortByTypeAction();
    }

    ContentSetSupport(NavigatorWindow navWin, Context context) {
        super(navWin, context);
        this._displayOptionsMenu.putClientProperty((Object)"DisplayOptionsMenu", (Object)Boolean.TRUE);
        new DisplayOptionsMenuListener(this._displayOptionsMenu.getPopupMenu());
    }

    @Override
    public void loadPreferences(PropertyAccess prefs) {
        this._flatLevel = ContentSetSupport.str2Int(prefs, "flat-level", 3);
        this.setFlatLevelRadio(this._flatLevel, true);
        this._webContentFlatLevel = ContentSetSupport.str2Int(prefs, "webcontent-flat-level", 1);
        this.setWebContentFlatLevelRadio(this._webContentFlatLevel, true);
        this._showDirs = ContentSetSupport.str2Boolean(prefs, "show-root-dirs", false);
        this._sortByType = ContentSetSupport.str2Boolean(prefs, "sort-by-type", false);
    }

    @Override
    public void savePreferences(PropertyAccess prefs) {
        ContentSetSupport.int2Str(prefs, "flat-level", this._flatLevel);
        ContentSetSupport.int2Str(prefs, "webcontent-flat-level", this._webContentFlatLevel);
        ContentSetSupport.boolean2Str(prefs, "show-root-dirs", this._showDirs);
        ContentSetSupport.boolean2Str(prefs, "sort-by-type", this._sortByType);
    }

    @Override
    public void copyPreferencesTo(Context context) {
        context.setInt("webcontent-flat-level", this._webContentFlatLevel);
        if (ViewSupport.isDirectoryView()) {
            context.setInt("flat-level", 1);
            context.setBoolean("show-root-dirs", true);
        } else {
            context.setInt("flat-level", this._flatLevel);
            context.setBoolean("show-root-dirs", this._showDirs);
        }
        context.setBoolean("sort-by-type", this._sortByType);
    }

    @Override
    public void initToolbar(Toolbar toolbar) {
        this._displayOptionsMenu.removeAllPopupItems();
        this._displayOptionsMenu.setAction((Action)this._displayOptionsNonAction);
        int componentCount = toolbar.getComponentCount();
        toolbar.add((Component)this._displayOptionsMenu, componentCount >= 2 ? 2 : componentCount);
        this.createAddFileToProjectAction();
        this.attachActionControllers();
        Menubar menuMgr = Ide.getMenubar();
        JMenu viewNavViewOptionsMenu = Menubar.getJMenu((String)"navigator-view-options-menu");
        IdeAction localAction = _toggleDirsAction.newLocalAction((View)this.getNavigatorWindow());
        localAction.addController((Controller)this);
        this._displayOptionsMenu.addPopupItem((ToggleAction)localAction);
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)localAction), viewNavViewOptionsMenu, 1.0f);
        localAction = _toggleSortByTypeAction.newLocalAction((View)this.getNavigatorWindow());
        localAction.addController((Controller)this);
        this._displayOptionsMenu.addPopupItem((ToggleAction)localAction);
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)localAction), viewNavViewOptionsMenu, 1.0f);
        JMenu toolbarViewMenu = menuMgr.createSubMenu(Res.getString(5), null, NavigatorMenuConstants.WEIGHT_PACKAGE_LEVEL);
        JMenu viewSubMenu = menuMgr.createSubMenu(Res.getString(5), null, NavigatorMenuConstants.WEIGHT_PACKAGE_LEVEL);
        this.addPackageLevelRadio(menuMgr, toolbarViewMenu, viewSubMenu, "ContentSetSupport.packageLevel0", Res.getString(8), 0);
        this.addPackageLevelRadio(menuMgr, toolbarViewMenu, viewSubMenu, "ContentSetSupport.packageLevel1", "1", 1);
        this.addPackageLevelRadio(menuMgr, toolbarViewMenu, viewSubMenu, "ContentSetSupport.packageLevel2", "2", 2);
        this.addPackageLevelRadio(menuMgr, toolbarViewMenu, viewSubMenu, "ContentSetSupport.packageLevel3", "3", 3);
        this.addPackageLevelRadio(menuMgr, toolbarViewMenu, viewSubMenu, "ContentSetSupport.packageLevel4", "4", 4);
        this.addPackageLevelRadio(menuMgr, toolbarViewMenu, viewSubMenu, "ContentSetSupport.packageLevel5", "5", 5);
        this.addPackageLevelRadio(menuMgr, toolbarViewMenu, viewSubMenu, "ContentSetSupport.packageLevel6", "6", 6);
        this.addPackageLevelRadio(menuMgr, toolbarViewMenu, viewSubMenu, "ContentSetSupport.packageLevel99", Res.getString(9), 99);
        this._displayOptionsMenu.add((Component)toolbarViewMenu);
        menuMgr.add((Component)viewSubMenu, viewNavViewOptionsMenu, 1.0f);
        new MnemonicSolver(toolbarViewMenu).solve();
        new MnemonicSolver(viewSubMenu).solve();
        toolbarViewMenu = menuMgr.createSubMenu(Res.getString(6), null, NavigatorMenuConstants.WEIGHT_WEB_CONTENT_LEVEL);
        viewSubMenu = menuMgr.createSubMenu(Res.getString(6), null, NavigatorMenuConstants.WEIGHT_WEB_CONTENT_LEVEL);
        this.addWebContentLevelRadio(menuMgr, toolbarViewMenu, viewSubMenu, "ContentSetSupport.webContentLevel0", Res.getString(10), 0);
        this.addWebContentLevelRadio(menuMgr, toolbarViewMenu, viewSubMenu, "ContentSetSupport.webContentLevel1", "1", 1);
        this.addWebContentLevelRadio(menuMgr, toolbarViewMenu, viewSubMenu, "ContentSetSupport.webContentLevel2", "2", 2);
        this.addWebContentLevelRadio(menuMgr, toolbarViewMenu, viewSubMenu, "ContentSetSupport.webContentLevel3", "3", 3);
        this.addWebContentLevelRadio(menuMgr, toolbarViewMenu, viewSubMenu, "ContentSetSupport.webContentLevel4", "4", 4);
        this.addWebContentLevelRadio(menuMgr, toolbarViewMenu, viewSubMenu, "ContentSetSupport.webContentLevel5", "5", 5);
        this.addWebContentLevelRadio(menuMgr, toolbarViewMenu, viewSubMenu, "ContentSetSupport.webContentLevel6", "6", 6);
        this.addWebContentLevelRadio(menuMgr, toolbarViewMenu, viewSubMenu, "ContentSetSupport.webContentLevel99", Res.getString(9), 99);
        this._displayOptionsMenu.add((Component)toolbarViewMenu);
        menuMgr.add((Component)viewSubMenu, viewNavViewOptionsMenu, 1.0f);
        new MnemonicSolver(toolbarViewMenu).solve();
        new MnemonicSolver(viewSubMenu).solve();
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == TOGGLE_DIRS_CMD_ID) {
            this._showDirs = !this._showDirs;
            action.setState(this._showDirs);
            ProjectNavigatorManager.refreshAllProjectsInNavigator(context);
            return true;
        }
        if (cmdId == TOGGLE_SORT_BY_TYPE_CMD_ID) {
            this._sortByType = !this._sortByType;
            action.setState(this._sortByType);
            ProjectNavigatorManager.refreshAllProjectsInNavigator(context);
            return true;
        }
        Object packageLevelObj = action.getValue("packageLevel");
        if (packageLevelObj != null) {
            this.setFlatLevelRadio(this._flatLevel, false);
            int packageLevel = (Integer)packageLevelObj;
            action.setState(true);
            this._flatLevel = packageLevel;
            NavigatorWindow navWin = this.getNavigatorWindow();
            ProjectNavigatorManager.refreshAllProjectsInNavigator(navWin.getContext());
            return true;
        }
        Object webContentLevelObj = action.getValue("webContentLevel");
        if (webContentLevelObj != null) {
            this.setWebContentFlatLevelRadio(this._webContentFlatLevel, false);
            int webContentLevel = (Integer)webContentLevelObj;
            action.setState(true);
            this._webContentFlatLevel = webContentLevel;
            NavigatorWindow navWin = this.getNavigatorWindow();
            ProjectNavigatorManager.refreshAllProjectsInNavigator(navWin.getContext());
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == TOGGLE_DIRS_CMD_ID) {
            boolean isDirectoryViewOn = ViewSupport.isDirectoryView();
            action.setEnabled(!isDirectoryViewOn);
            action.setState(isDirectoryViewOn ? true : this._showDirs);
            return true;
        }
        if (cmdId == TOGGLE_SORT_BY_TYPE_CMD_ID) {
            action.setEnabled(true);
            action.setState(this._sortByType);
            return true;
        }
        Object packageLevelObj = action.getValue("packageLevel");
        if (packageLevelObj != null) {
            int packageLevel = (Integer)packageLevelObj;
            if (ViewSupport.isDirectoryView()) {
                action.setState(1 == packageLevel);
                action.setEnabled(false);
            } else {
                action.setState(this._flatLevel == packageLevel);
                action.setEnabled(true);
            }
            return true;
        }
        Object webContentLevelObj = action.getValue("webContentLevel");
        if (webContentLevelObj != null) {
            int webContentLevel = (Integer)webContentLevelObj;
            action.setState(this._webContentFlatLevel == webContentLevel);
            action.setEnabled(true);
            return true;
        }
        return false;
    }

    public static MenuToolButton findDisplayOptionsMenu(Toolbar toolbar) {
        int n = toolbar.getComponentCount();
        for (int i = 0; i < n; ++i) {
            MenuToolButton menuToolButton;
            Component component = toolbar.getComponentAtIndex(i);
            if (!(component instanceof MenuToolButton) || !Boolean.TRUE.equals((menuToolButton = (MenuToolButton)component).getClientProperty((Object)"DisplayOptionsMenu"))) continue;
            return menuToolButton;
        }
        return null;
    }

    private void setFlatLevelRadio(int level, boolean state) {
        Object actionObj = this._flatLevelLocalActions.get(level);
        if (actionObj != null) {
            ((IdeAction)actionObj).putValueDirectly("State", (Object)state);
        }
    }

    private void setWebContentFlatLevelRadio(int level, boolean state) {
        Object actionObj = this._webContentFlatLevelLocalActions.get(level);
        if (actionObj != null) {
            ((IdeAction)actionObj).putValueDirectly("State", (Object)state);
        }
    }

    private static void maybeInitToggleDirsAction() {
        if (_toggleDirsAction == null) {
            IdeAction action = IdeAction.get((int)TOGGLE_DIRS_CMD_ID, (String)TOGGLE_DIRS_CMD, (String)NavigatorArb.getString((int)1));
            action.putValue("menu-weight", (Object)Float.valueOf(NavigatorMenuConstants.WEIGHT_GROUP_BY_DIRECTORY));
            action.setEnabled(true);
            action.putValue("Check", (Object)Boolean.TRUE);
            _toggleDirsAction = action;
        }
    }

    private void addPackageLevelRadio(Menubar menuMgr, JMenu menu, JMenu mainMenu, String cmdStr, String label, int packageLevel) {
        int cmdID = Ide.findOrCreateCmdID((String)cmdStr);
        IdeAction radioAction = IdeAction.get((int)cmdID);
        radioAction.putValue("Name", (Object)StringUtils.stripMnemonic((String)label));
        radioAction.putValue("MnemonicKey", (Object)StringUtils.getMnemonicKeyCode((String)label));
        IdeAction radioLocalAction = radioAction.newLocalAction((View)this.getNavigatorWindow());
        radioLocalAction.putValue("Radio", (Object)Boolean.TRUE);
        radioLocalAction.setEnabled(true);
        radioLocalAction.putValue("packageLevel", (Object)packageLevel);
        radioLocalAction.addController((Controller)this);
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)radioLocalAction), menu);
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)radioLocalAction), mainMenu, 1.0f);
        this._flatLevelLocalActions.put(packageLevel, radioLocalAction);
    }

    private void addWebContentLevelRadio(Menubar menuMgr, JMenu menu, JMenu mainMenu, String cmdStr, String label, int webContentLevel) {
        int cmdID = Ide.findOrCreateCmdID((String)cmdStr);
        IdeAction radioAction = IdeAction.get((int)cmdID);
        radioAction.putValue("Name", (Object)StringUtils.stripMnemonic((String)label));
        radioAction.putValue("MnemonicKey", (Object)StringUtils.getMnemonicKeyCode((String)label));
        IdeAction radioLocalAction = radioAction.newLocalAction((View)this.getNavigatorWindow());
        radioLocalAction.putValue("Radio", (Object)Boolean.TRUE);
        radioLocalAction.setEnabled(true);
        radioLocalAction.putValue("webContentLevel", (Object)webContentLevel);
        radioLocalAction.addController((Controller)this);
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)radioLocalAction), menu);
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)radioLocalAction), mainMenu, 1.0f);
        this._webContentFlatLevelLocalActions.put(webContentLevel, radioLocalAction);
    }

    private static void maybeInitToggleSortByTypeAction() {
        if (_toggleSortByTypeAction == null) {
            IdeAction action = IdeAction.get((int)TOGGLE_SORT_BY_TYPE_CMD_ID);
            action.putValue("Name", (Object)StringUtils.stripMnemonic((String)ModelArb.getString((int)55)));
            action.putValue("menu-weight", (Object)Float.valueOf(NavigatorMenuConstants.WEIGHT_SORT_TYPES));
            action.setEnabled(true);
            action.putValue("Check", (Object)Boolean.TRUE);
            _toggleSortByTypeAction = action;
        }
    }

    private void attachActionControllers() {
        this.attachAddToProjectController();
        this.attachDeleteController();
    }

    private void attachDeleteController() {
        IdeAction removeAction = IdeActions.getFileRemoveFromIDEAction();
        Controller controller = new Controller(){

            public boolean handleEvent(IdeAction action, Context context) {
                Project proj;
                Project project = proj = context != null ? context.getProject() : null;
                if (proj != null) {
                    Element[] selection = context.getSelection();
                    if (!this.canHandleSelection(selection)) {
                        return false;
                    }
                    if (!this.showConfirmMsg()) {
                        return true;
                    }
                    ArrayList<URL> urls = new ArrayList<URL>();
                    ArrayList<String> paths = new ArrayList<String>();
                    for (int x = 0; x < selection.length; ++x) {
                        Object data = selection[x].getData();
                        if (data instanceof Locatable) {
                            urls.add(((Locatable)data).getURL());
                            continue;
                        }
                        if (!(data instanceof RelativeDirectoryContextFolder)) continue;
                        paths.add(((RelativeDirectoryContextFolder)data).getRelativePath());
                    }
                    proj.applyBatchChanges(this.updateContentSets(proj, urls, paths));
                    return true;
                }
                return false;
            }

            public boolean update(IdeAction action, Context context) {
                Project proj;
                Project project = proj = context != null ? context.getProject() : null;
                if (proj != null) {
                    if (!this.canHandleSelection(context.getSelection())) {
                        return false;
                    }
                    boolean enable = false;
                    Element[] selection = context.getSelection();
                    if (selection.length > 0) {
                        Object data = selection[0].getData();
                        URL url = null;
                        String relPath = null;
                        if (data instanceof Locatable) {
                            url = ((Locatable)data).getURL();
                        } else if (data instanceof RelativeDirectoryContextFolder) {
                            relPath = ((RelativeDirectoryContextFolder)data).getRelativePath();
                        }
                        if (url != null || relPath != null) {
                            ContentSetProviderReference[] refs = ProjectContent.getContentSetProviderReferences();
                            for (int i = 0; i < refs.length; ++i) {
                                String key = refs[i].key();
                                ContentSet cs = ContentSet.getInstance((PropertyStorage)proj, (String)key);
                                if ((url == null || !cs.canHaveMember(url)) && (relPath == null || relPath.length() <= 0 || cs.toQualifiedURL(relPath + "/") == null)) continue;
                                enable = true;
                                break;
                            }
                            action.setEnabled(enable);
                            String label = ModelArb.getString((int)61);
                            action.putValue("Name", (Object)label);
                            return true;
                        }
                    }
                }
                return false;
            }

            private Runnable updateContentSets(final Project project, final ArrayList urls, final ArrayList paths) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        if (!urls.isEmpty() || !paths.isEmpty()) {
                            ContentSetProviderReference[] refs;
                            ProjectContent projContent = ProjectContent.getInstance((PropertyStorage)project);
                            for (ContentSetProviderReference ref : refs = ProjectContent.getContentSetProviderReferences()) {
                                ContentSet contentSet = projContent.getContentSet(ref.key());
                                for (String relPath : paths) {
                                    URL url;
                                    if (relPath.isEmpty() || !contentSet.canHaveMember(url = contentSet.toQualifiedURL(relPath + "/"))) continue;
                                    ref.contentSetProvider().getContentSetHelper().removeContent(url, projContent);
                                }
                                for (URL url : urls) {
                                    if (!contentSet.canHaveMember(url)) continue;
                                    ref.contentSetProvider().getContentSetHelper().removeContent(url, projContent);
                                }
                            }
                        }
                    }
                };
                return r;
            }

            private boolean showConfirmMsg() {
                String nodeText = PanelsArb.getString((int)11);
                String message = ModelArb.format((int)60, (Object)nodeText);
                String title = ModelArb.getString((int)61);
                return MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)message, (String)title, (String)"f1_idedexcludeprojectcontent_html");
            }

            private boolean canHandleSelection(Element[] selection) {
                return selection.length <= 0 || selection[0] != null && !(selection[0] instanceof Project) && !(selection[0] instanceof Workspace);
            }
        };
        removeAction.addController(controller);
    }

    private void attachAddToProjectController() {
        String label = Res.format(12, "");
        IdeAction action = IdeAction.findOrCreate((int)ADD_TO_PROJECT_CMD_ID, null, (String)label);
        Controller controller = new Controller(){

            public boolean handleEvent(IdeAction action, Context context) {
                Project project;
                Project project2 = project = context != null ? context.getProject() : null;
                if (project != null) {
                    String[] selection = new String[]{ProjectContentNavigable.PROPERTIES_NODE_LABEL};
                    ProjectPropertiesDialog.showDialog((Context)context, (Frame)Ide.getMainWindow(), (Project)project, (String[])selection);
                    return true;
                }
                return false;
            }

            public boolean update(IdeAction action, Context context) {
                return false;
            }
        };
        action.addController(controller);
    }

    private IdeAction createAddFileToProjectAction() {
        if (_addFileToProjectAction == null) {
            String label = StringUtils.stripMnemonic((String)ModelArb.getString((int)62));
            String category = MenuManager.getJMenu((String)"Tools").getText();
            int mnemonicKeyCode = StringUtils.getMnemonicKeyCode((String)ModelArb.getString((int)62));
            _addFileToProjectAction = IdeAction.get((int)ADD_URL_TO_PROJECT_CMD_ID, null, (String)label, (String)category, (Integer)mnemonicKeyCode, (ResourceBundle)NavigatorArb.getInstance(), null, null, (boolean)false);
            Controller controller = new Controller(){

                public boolean handleEvent(IdeAction action, Context context) {
                    AddContentCommand cmd = new AddContentCommand();
                    cmd.setContext(context);
                    try {
                        if (cmd.doit() == 0) {
                            Node element = context.getNode();
                            NavigatorWindow navigator = ContentSetSupport.this.getNavigatorWindow();
                            if (navigator.isVisible()) {
                                TreeExplorer explorer = navigator.getTreeExplorer();
                                TNode tnode = explorer.findTNode((Element)element, null);
                                explorer.setSelected(tnode);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return true;
                }

                public boolean update(IdeAction action, Context context) {
                    Node node;
                    Project project = context.getProject();
                    if (project != null && (context.getSelection().length == 1 || context.getNode() != null) && (node = context.getNode()) != null) {
                        boolean enable = this.canBeAddedToProject(project, node);
                        action.setEnabled(enable);
                        return true;
                    }
                    action.setEnabled(false);
                    return true;
                }

                private boolean canBeAddedToProject(Project project, Node node) {
                    URL url;
                    return !project.containsChild((Element)node) && (URLFileSystem.isRegularFile((URL)(url = node.getURL())) || URLFileSystem.isDirectory((URL)url));
                }
            };
            _addFileToProjectAction.addController(controller);
        }
        return _addFileToProjectAction;
    }

    static {
        TOGGLE_SORT_BY_TYPE_CMD_ID = Ide.findOrCreateCmdID((String)TOGGLE_SORT_BY_TYPE_CMD);
    }

    private static class DisplayOptionsMenuListener
    implements PopupMenuListener {
        final JPopupMenu _popupMenu;

        public DisplayOptionsMenuListener(JPopupMenu popupMenu) {
            this._popupMenu = popupMenu;
            this._popupMenu.addPopupMenuListener(this);
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            Container source = (Container)e.getSource();
            Component[] children = source.getComponents();
            ArrayList<Component> radios = new ArrayList<Component>();
            for (Component c : children) {
                if (!(c instanceof RadioMenuItem)) continue;
                source.remove(c);
                radios.add(c);
            }
            Ide.getMenubar().sortContainer(source);
            if (!radios.isEmpty()) {
                Collections.reverse(radios);
                source.add((Component)new JSeparator(), 0);
                for (Component c : radios) {
                    source.add(c, 0);
                }
            }
            new MnemonicSolver(this._popupMenu).solve();
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this._popupMenu.removePopupMenuListener(this);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }

    private class DisplayOptionsNonAction
    extends ToggleAction {
        DisplayOptionsNonAction() {
            super(Res.getString(7), OracleIcons.getIcon((String)"small/navigatordisplayoptions_14.png"));
            this.putValue("tinyButton", Boolean.TRUE);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }
}

