/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.navigator;

import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.NavigatorInit;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.refactoring.MoveActionHandler;
import oracle.ide.refactoring.MoveHandlerService;

public final class CutPasteSupport
extends NavigatorInit {
    private Controller _controller;

    protected CutPasteSupport(NavigatorWindow navWin, Context context) {
        super(navWin, context);
    }

    @Override
    public Controller getController() {
        if (this._controller == null) {
            this._controller = new Controller(){
                URL[] selectionURLs;
                URL selectionWorkspaceURL;
                MoveActionHandler moveActionHandler;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean handleEvent(IdeAction action, Context context) {
                    switch (action.getCommandId()) {
                        case 17: {
                            Workspace ws = context.getWorkspace();
                            this.selectionWorkspaceURL = ws == null ? null : ws.getURL();
                            this.selectionURLs = CutPasteSupport.gatherElementsURLs(context.getSelection());
                            this.moveActionHandler = MoveHandlerService.createMoveHandler((Context)new Context(context));
                            return true;
                        }
                        case 19: {
                            try {
                                if (this.moveActionHandler != null) {
                                    this.moveActionHandler.doit();
                                }
                            }
                            finally {
                                this.moveActionHandler = null;
                            }
                            return true;
                        }
                    }
                    return false;
                }

                public boolean update(IdeAction action, Context context) {
                    switch (action.getCommandId()) {
                        case 17: {
                            action.setEnabled(true);
                            return true;
                        }
                        case 19: {
                            boolean enablePaste = true;
                            Workspace ws = context.getWorkspace();
                            if (this.moveActionHandler == null) {
                                enablePaste = false;
                            } else if (ws != null && this.selectionWorkspaceURL != null && !this.selectionWorkspaceURL.equals(ws.getURL())) {
                                enablePaste = false;
                            } else if (!CutPasteSupport.checkExistenceOfURL(this.selectionURLs)) {
                                enablePaste = false;
                            }
                            if (!enablePaste) {
                                this.moveActionHandler = null;
                                this.selectionURLs = null;
                                this.moveActionHandler = null;
                                action.setEnabled(enablePaste);
                                return true;
                            }
                            action.setEnabled(this.moveActionHandler.setDestination(context));
                            return true;
                        }
                    }
                    return false;
                }
            };
        }
        return this._controller;
    }

    private static URL[] gatherElementsURLs(Element[] elements) {
        return (URL[])Arrays.stream(elements).map(element -> CutPasteSupport.findElementURL(element)).filter(url -> url != null).toArray(URL[]::new);
    }

    private static boolean checkExistenceOfURL(URL[] urls) {
        if (urls == null || urls.length == 0) {
            return true;
        }
        return Arrays.stream(urls).allMatch(url -> URLFileSystem.exists((URL)url));
    }

    private static final URL findElementURL(Element element) {
        if (element instanceof Locatable) {
            Locatable locatable = (Locatable)element;
            URL url = locatable.getURL();
            return url;
        }
        if (element instanceof RelativeDirectoryContextFolder) {
            RelativeDirectoryContextFolder folder = (RelativeDirectoryContextFolder)element;
            URLPath roots = folder.getRootDirectories();
            String path = folder.getRelativePath();
            Iterator j = roots.iterator();
            if (j.hasNext()) {
                URL root = (URL)j.next();
                URL url = URLFactory.newDirURL((URL)root, (String)path);
                return url;
            }
        }
        return null;
    }
}

