/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.progress;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.ide.progress.IProgressListener;

public class ProgressManager {
    private static HashMap<String, List<IProgressListener>> _listeners = null;
    private static Object _listenersMonitor = new Object();

    private ProgressManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void beginProgress() {
        Object object = _listenersMonitor;
        synchronized (object) {
            if (_listeners == null) {
                _listeners = new HashMap();
            } else if (!_listeners.isEmpty()) {
                _listeners.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endProgress() {
        Object object = _listenersMonitor;
        synchronized (object) {
            if (_listeners != null) {
                _listeners.clear();
                _listeners = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerListener(String name, IProgressListener listener) {
        Object object = _listenersMonitor;
        synchronized (object) {
            if (_listeners != null) {
                List<IProgressListener> items = _listeners.get(name);
                if (items == null) {
                    items = new LinkedList<IProgressListener>();
                    items.add(listener);
                    _listeners.put(name, items);
                } else if (!items.contains(listener)) {
                    items.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(String name, IProgressListener listener) {
        Object object = _listenersMonitor;
        synchronized (object) {
            List<IProgressListener> items;
            if (_listeners != null && (items = _listeners.get(name)) != null) {
                items.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void completeProgress(String name) {
        Object object = _listenersMonitor;
        synchronized (object) {
            List<IProgressListener> listeners;
            if (_listeners != null && (listeners = _listeners.get(name)) != null) {
                for (IProgressListener listener : listeners) {
                    if (listener == null) continue;
                    listener.completeProgress();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateProgressTitle(String name, String title) {
        Object object = _listenersMonitor;
        synchronized (object) {
            List<IProgressListener> listeners;
            if (_listeners != null && (listeners = _listeners.get(name)) != null) {
                for (IProgressListener listener : listeners) {
                    if (listener == null) continue;
                    listener.updateProgressTitle(title);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateProgressDescription(String name, String description, int count) {
        Object object = _listenersMonitor;
        synchronized (object) {
            List<IProgressListener> listeners;
            if (_listeners != null && (listeners = _listeners.get(name)) != null) {
                for (IProgressListener listener : listeners) {
                    if (listener == null) continue;
                    listener.updateProgressDescription(description, count);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateProgress(String name, int count) {
        Object object = _listenersMonitor;
        synchronized (object) {
            List<IProgressListener> listeners;
            if (_listeners != null && (listeners = _listeners.get(name)) != null) {
                for (IProgressListener listener : listeners) {
                    if (listener == null) continue;
                    listener.updateProgress(count);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finalizeProgress(String name, int count) {
        Object object = _listenersMonitor;
        synchronized (object) {
            List<IProgressListener> listeners;
            if (_listeners != null && (listeners = _listeners.get(name)) != null) {
                for (IProgressListener listener : listeners) {
                    if (listener == null) continue;
                    listener.finalizeProgress(count);
                }
            }
        }
    }
}

