/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import java.util.Hashtable;
import oracle.xml.parser.v2.NSName;
import oracle.xml.util.NSNameImpl;
import oracle.xml.xpath.PathExpr;
import oracle.xml.xpath.XPathCompileEvents;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLStylesheet;

public class XPathVarReference
extends XSLExprBase {
    private NSName nsname;
    private int varIdx = -1;
    private PathExpr expr;

    static XSLExprBase parse(XSLParseString xSLParseString) throws XSLException {
        XPathCompileEvents xPathCompileEvents = xSLParseString.getXPathCompileEvents();
        if (xSLParseString.isVarRestricted() && xSLParseString.xss != null && !xSLParseString.xss.is2029Compatible()) {
            throw new XPathException(1013, xSLParseString.getExprString());
        }
        if (xSLParseString.peekToken() != 7) {
            return null;
        }
        xSLParseString.nextToken();
        if (xSLParseString.nextToken() != 112) {
            throw new XPathException(1019, "QNAME", xSLParseString.getCurrentToken());
        }
        XPathVarReference xPathVarReference = new XPathVarReference();
        String string = xSLParseString.getNamespace();
        String string2 = xSLParseString.getLocalName();
        xPathVarReference.nsname = new NSNameImpl("", string2, string);
        XSLStylesheet xSLStylesheet = xSLParseString.getStylesheet();
        if (xSLStylesheet != null) {
            xPathVarReference.varIdx = xSLStylesheet.getVariableIndex(xPathVarReference.nsname);
            XSLExprBase xSLExprBase = xSLStylesheet.getVariableExpr(xPathVarReference.nsname, xPathVarReference.varIdx);
            if (xSLExprBase instanceof PathExpr) {
                xPathVarReference.expr = (PathExpr)xSLExprBase;
            }
        }
        xPathVarReference.setExprType(0xFFFFFE);
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsWithStringParam(127, 2, string, string2, null);
            xPathCompileEvents.reportEventsWithStringParam(235, 2, string, string2, null);
        }
        return xPathVarReference;
    }

    private static PathExpr retrievePathExpr(NSName nSName, Hashtable<NSName, PathExpr> hashtable) {
        if (hashtable == null) {
            return null;
        }
        return hashtable.get(nSName);
    }

    @Override
    void cacheSubExpr() {
    }

    @Override
    boolean canCacheExpr() {
        return false;
    }

    @Override
    public String getNormalizedExpr() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(7);
        String string = this.nsname.getNamespace();
        if (string != null && string.length() > 0) {
            stringBuffer.append("{");
            stringBuffer.append(string);
            stringBuffer.append("}");
        }
        stringBuffer.append(this.nsname.getLocalName());
        return stringBuffer.toString();
    }

    @Override
    int checkPosLastFN() {
        this.flag = 0;
        return 0;
    }

    @Override
    public void evaluate(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        OXMLSequence oXMLSequence = xPathRuntimeContext.pushExprValue();
        OXMLSequence oXMLSequence2 = xPathRuntimeContext.getVariable(this.nsname, this.varIdx);
        if (oXMLSequence2 == null) {
            if (!((XPathSequence)oXMLSequence).setObjectValue(xPathRuntimeContext.getVariable(this.nsname))) {
                throw new XPathException(1031, this.nsname.getQualifiedName());
            }
        } else {
            ((XPathSequence)oXMLSequence2).copyInto((XPathSequence)oXMLSequence);
        }
        if (this.predicates != null) {
            this.filterPredicates(xPathRuntimeContext);
        }
    }

    PathExpr getPathExpr() {
        return this.expr;
    }
}

