/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector.editors;

import java.beans.PropertyEditorSupport;

public class StringEditor
extends PropertyEditorSupport {
    @Override
    public String getJavaInitializationString() {
        Object value = this.getValue();
        if (value == null) {
            return "null";
        }
        String str = value.toString();
        int length = str.length();
        StringBuilder sb = new StringBuilder(length + 2);
        sb.append('\"');
        block9: for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                default: {
                    if (ch < ' ' || ch > '~') {
                        sb.append("\\u");
                        String hex = Integer.toHexString(ch);
                        for (int len = hex.length(); len < 4; ++len) {
                            sb.append('0');
                        }
                        sb.append(hex);
                        continue block9;
                    }
                    sb.append(ch);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    @Override
    public void setAsText(String text) {
        this.setValue(text);
    }
}

