/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.ResourceBundle;
import oracle.adf.share.ADFContext;
import oracle.adf.share.MDSAppContext;
import oracle.adf.share.config.resources.Messages;
import oracle.adf.share.logging.ADFLogger;

public class MDSAppContextStack {
    private Deque<MDSAppContext> m_appCtxStack = new ArrayDeque<MDSAppContext>();
    private static final ADFLogger _LOG = ADFLogger.createADFLogger(MDSAppContextStack.class);
    private static final String MDS_APP_CONTEXT = MDSAppContextStack.class.getName();
    private static final ResourceBundle _resBundle = ResourceBundle.getBundle(Messages.class.getName());

    private int size() {
        return this.m_appCtxStack.size();
    }

    public boolean isLast() {
        return this.m_appCtxStack.size() <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MDSAppContextStack getMDSAppContextStack() {
        MDSAppContextStack mdsAppCtx;
        block6: {
            mdsAppCtx = null;
            try {
                Map reqScope = MDSAppContextStack.getRequestScope();
                mdsAppCtx = (MDSAppContextStack)reqScope.get(MDS_APP_CONTEXT);
                if (mdsAppCtx != null) break block6;
                Map map = reqScope;
                synchronized (map) {
                    mdsAppCtx = (MDSAppContextStack)reqScope.get(MDS_APP_CONTEXT);
                    if (mdsAppCtx == null) {
                        mdsAppCtx = new MDSAppContextStack();
                        reqScope.put(MDS_APP_CONTEXT, mdsAppCtx);
                    }
                }
            }
            catch (Exception e) {
                _LOG.severe((Throwable)e);
            }
        }
        return mdsAppCtx;
    }

    private void pushMDSAppContext(MDSAppContext mdsApp) {
        this.m_appCtxStack.offerFirst(mdsApp);
    }

    private MDSAppContext popMDSAppContext() {
        return this.m_appCtxStack.pollFirst();
    }

    private static ADFContext getADFContext() {
        ADFContext adfc = ADFContext.getCurrent();
        return adfc;
    }

    private static Map getRequestScope() {
        ADFContext adfc = MDSAppContextStack.getADFContext();
        Map reqScope = adfc.getRequestScope();
        return reqScope;
    }

    public static void pushCurrentAndReset(Object mdsTransM) throws Exception {
        MDSAppContextStack.getMDSAppContextStack().pushCurrentAndResetInternal(mdsTransM);
    }

    private void pushCurrentAndResetInternal(Object mdsTransM) throws Exception {
        ADFContext adfctx = MDSAppContextStack.getADFContext();
        this.storeCurrent(mdsTransM);
        MDSAppContext mdsAppCtx = new MDSAppContext();
        adfctx.setMDSContext(mdsAppCtx);
    }

    private void storeCurrent() throws Exception {
        MDSAppContext mdsAppCtx = new MDSAppContext();
        ADFContext adfctx = MDSAppContextStack.getADFContext();
        mdsAppCtx.setMDSSession(adfctx.getMDSSessionAsObject());
        mdsAppCtx.setADFContextMDSConfigHelper(adfctx.getMDSConfigHelper());
        this.pushMDSAppContext(mdsAppCtx);
    }

    private void storeCurrent(Object mdsTransM) throws Exception {
        MDSAppContext mdsAppCtx = new MDSAppContext();
        ADFContext adfctx = MDSAppContextStack.getADFContext();
        mdsAppCtx.setMDSSession(adfctx.getMDSSessionAsObject());
        mdsAppCtx.setADFContextMDSConfigHelper(adfctx.getMDSConfigHelper());
        mdsAppCtx.setMDSTransManager(mdsTransM);
        this.pushMDSAppContext(mdsAppCtx);
    }

    public static Object popAndMakeCurrent() throws Exception {
        return MDSAppContextStack.getMDSAppContextStack().popAndMakeCurrentInternal();
    }

    private Object popAndMakeCurrentInternal() throws Exception {
        if (this.isLast()) {
            throw new Exception(_resBundle.getString("MDS_APPCTX_LAST"));
        }
        MDSAppContext mdsAppCtx = this.popMDSAppContext();
        MDSAppContextStack.getADFContext().setMDSContext(mdsAppCtx);
        return mdsAppCtx.getMDSTransManager();
    }
}

