/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share;

import oracle.adf.share.MetadataEnvironmentShell;

public class MetadataEnvironmentThread
extends Thread {
    private final MetadataEnvironmentShell.Variables variables;
    private final MetadataEnvironmentShell shell;

    public MetadataEnvironmentThread(MetadataEnvironmentShell shell, MetadataEnvironmentShell.Variables variables, ThreadGroup group, Runnable target, String name, long stackSize) {
        super(group, target, name, stackSize);
        if (shell == null) {
            throw new IllegalArgumentException("Invalid metadata environment shell: null.");
        }
        this.shell = shell;
        this.variables = variables;
    }

    public final MetadataEnvironmentShell getMetadataEnvironmentShell() {
        return this.shell;
    }

    public final <T> T get(MetadataEnvironmentShell.Variable<T> var) {
        if (this.variables == null) {
            return null;
        }
        return this.variables.get(var);
    }

    public final boolean isSet(MetadataEnvironmentShell.Variable var) {
        if (this.variables == null) {
            return false;
        }
        return this.variables.contains(var);
    }

    @Override
    public final void run() {
        super.run();
    }

    public static abstract class Resources {
        public abstract void initializeResources();

        public abstract void finalizeResources();
    }
}

