/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.sandbox;

import java.util.Map;
import oracle.adf.share.ADFContext;
import oracle.adf.share.Environment;
import oracle.adf.share.MetadataEnvironment;
import oracle.adf.share.sandbox.MetadataRepositoryBaseline;
import oracle.adf.share.sandbox.SandboxConstraints;

public abstract class SandboxEnvironment
implements MetadataEnvironment {
    private final String _sandboxId;
    private Boolean _requestForRefresh;

    public static String getRequestParameter(Parameter p) {
        Environment e = ADFContext.getCurrent().getEnvironment();
        if (e == null) {
            return null;
        }
        Map m = e.getRequestParameterMap();
        if (m == null || m.isEmpty()) {
            return null;
        }
        for (Object key : m.keySet()) {
            String r;
            if (!key.toString().endsWith(p.code())) continue;
            Object o = m.get(key);
            if (o == null) {
                return null;
            }
            if (o instanceof String[]) {
                String[] ar = (String[])o;
                if (ar.length <= 0) {
                    return null;
                }
                if (ar[0] == null) {
                    return null;
                }
                r = ar[0].trim();
            } else {
                r = o.toString().trim();
            }
            if (r.isEmpty()) {
                return null;
            }
            return r;
        }
        return null;
    }

    public static SandboxEnvironment getCurrent() {
        ADFContext adfc = ADFContext.getCurrent();
        MetadataEnvironment me = adfc.getMetadataEnvironment();
        if (!(me instanceof SandboxEnvironment)) {
            return null;
        }
        return (SandboxEnvironment)me;
    }

    public static SandboxEnvironment getMdsCurrent() {
        return SandboxEnvironment.getCurrent("oracle.adf.unifiedsandbox.repository.MdsCommonRepository");
    }

    public static SandboxEnvironment getCurrent(String repositoryId) {
        SandboxEnvironment se = SandboxEnvironment.getCurrent();
        if (se != null && se.isRepositoryBranched(repositoryId)) {
            return se;
        }
        return null;
    }

    protected SandboxEnvironment(String sandboxId) {
        if (sandboxId == null) {
            throw new IllegalArgumentException("Invalid sandbox ID: null.");
        }
        this._sandboxId = sandboxId;
    }

    public final String getSandboxId() {
        return this._sandboxId;
    }

    public SandboxConstraints getSandboxConstraints() {
        return null;
    }

    public boolean isFeatureEnabled(String featureId) {
        return false;
    }

    public boolean isRepositoryBranched(String repositoryId) {
        return false;
    }

    public String getRepositoryLabel(String repositoryId) {
        MetadataRepositoryBaseline mrb = this.getRepositoryBaseline(repositoryId);
        return mrb == null ? null : mrb.getCertifiedLabel();
    }

    @Override
    public MetadataRepositoryBaseline getRepositoryBaseline(String repositoryId) {
        return null;
    }

    public String getRepositoryBranchId(String repositoryId) {
        return null;
    }

    public final String getMdsDefaultCustStoreSandboxName() {
        return this.getRepositoryBranchId("oracle.adf.unifiedsandbox.repository.MdsCommonRepository");
    }

    public ToolHints getToolHints() {
        return new ToolHints();
    }

    public boolean isRefreshing() {
        return false;
    }

    public boolean isPublishing() {
        return false;
    }

    public boolean isRefreshRequired() {
        return false;
    }

    public boolean isRequestForRefresh() {
        if (this._requestForRefresh == null) {
            this._requestForRefresh = "t".equals(SandboxEnvironment.getRequestParameter(Parameter.IS_REQUEST_FOR_REFRESH));
        }
        return this._requestForRefresh;
    }

    public class ToolHints {
        public boolean isSandboxAdministrator() {
            return false;
        }

        public boolean isSandboxOwner() {
            return false;
        }

        public boolean isEditable() {
            return true;
        }
    }

    public static enum Parameter {
        SANDBOX_ID("adfmde-sb-id"),
        IS_REQUEST_FOR_REFRESH("adfmde-sb-isrfr");

        private String code;

        private Parameter(String n2) {
            this.code = n2;
        }

        public final String code() {
            return this.code;
        }
    }
}

