/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security.identitymanagement;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import oracle.adf.share.codesharing.audit.annotation.CodeSharingSafe;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.security.ADFSecurityRuntimeException;
import oracle.adf.share.security.ADFSecurityUtil;
import oracle.adf.share.security.AllowUntrustedScriptAccess;
import oracle.adf.share.security.identitymanagement.AttributeFilter;
import oracle.adf.share.security.identitymanagement.UserManager;
import oracle.adf.share.security.identitymanagement.UserProfileType;

@AllowUntrustedScriptAccess(allowConstructor=false, methodNames={"getBusinessCity", "getBusinessCountry", "getBusinessEmail", "getBusinessFax", "getBusinessMobile", "getBusinessPOBox", "getBusinessPager", "getBusinessPhone", "getBusinessPostalAddr", "getBusinessPostalCode", "getBusinessState", "getBusinessStreet", "getDateofBirth", "getDateofHire", "getDefaultGroup", "getDepartment", "getDepartmentNumber", "getDescription", "getDisplayName", "getEmployeeNumber", "getEmployeeType", "getFirstName", "getGUID", "getGivenName", "getHomeAddress", "getHomePhone", "getInitials", "getJpegPhoto", "getLastName", "getMaidenName", "getManager", "getMiddleName", "getName", "getNameSuffix", "getOrganization", "getOrganizationalUnit", "getPreferredLanguage", "getPrinciple", "getProperties", "getProperty", "getTimeZone", "getTitle", "getUIAccessMode", "getUniqueName", "getUserID", "getUserName", "getWirelessAccountNumber"})
public class UserProfile
implements Serializable {
    private static final String CLASS_NAME = UserProfile.class.getName();
    private static final long serialVersionUID = -8483385872960671970L;
    private String _userName = null;
    private HashMap _values = new HashMap();
    private HashMap _internalMap = new HashMap();
    private static final ADFLogger _adfSecLogger = ADFSecurityUtil.getADFLogger();
    @CodeSharingSafe(value="MutableStaticField")
    private static final UserManager _userMgr = new UserManager();
    private HashMap _modifiedProps = null;

    public UserProfile() {
    }

    public UserProfile(String userName) {
        String METHOD_NAME = "UserProfile Constructor";
        if (_adfSecLogger.isFinest()) {
            _adfSecLogger.log(Level.FINEST, CLASS_NAME + "." + "UserProfile Constructor" + " userName: " + userName);
        }
        if (userName == null) {
            throw new ADFSecurityRuntimeException(ADFSecurityUtil.getMessage("EXC_INVALID_USER"));
        }
        this._userName = userName;
        this.initialize();
    }

    private void initialize() {
        if (_userMgr != null) {
            AttributeFilter filter = new AttributeFilter();
            filter.setValue(this._userName);
            ArrayList list = null;
            list = _userMgr.getUserProfileList(-1, new AttributeFilter[]{filter});
            if (list != null && list.size() > 0) {
                this.internalSetProperties(((UserProfile)list.get(0)).getProperties());
            }
        }
    }

    public String getBusinessCity() {
        return (String)this.getProperty(UserProfileType.BUSINESS_CITY);
    }

    public String getBusinessCountry() {
        return (String)this.getProperty("BUSINESS_COUNTRY");
    }

    public String getBusinessEmail() {
        return (String)this.getProperty("BUSINESS_EMAIL");
    }

    public String getBusinessFax() {
        return (String)this.getProperty("BUSINESS_FAX");
    }

    public String getBusinessMobile() {
        return (String)this.getProperty("BUSINESS_MOBILE");
    }

    public String getBusinessPager() {
        return (String)this.getProperty("BUSINESS_PAGER");
    }

    public String getBusinessPhone() {
        return (String)this.getProperty("BUSINESS_PHONE");
    }

    public String getBusinessPOBox() {
        return (String)this.getProperty("BUSINESS_PO_BOX");
    }

    public String getBusinessPostalAddr() {
        return (String)this.getProperty("BUSINESS_POSTAL_ADDR");
    }

    public String getBusinessPostalCode() {
        return (String)this.getProperty("BUSINESS_POSTAL_CODE");
    }

    public String getBusinessState() {
        return (String)this.getProperty("BUSINESS_STATE");
    }

    public String getBusinessStreet() {
        return (String)this.getProperty("BUSINESS_STREET");
    }

    public String getDateofBirth() {
        return (String)this.getProperty("DATE_OF_BIRTH");
    }

    public String getDateofHire() {
        return (String)this.getProperty("DATE_OF_HIRE");
    }

    public String getDefaultGroup() {
        return (String)this.getProperty("DEFAULT_GROUP");
    }

    public String getDepartment() {
        return (String)this.getProperty("DEPARTMENT");
    }

    public String getDepartmentNumber() {
        return this.getDepartment();
    }

    public String getDescription() {
        return (String)this.getProperty("DESCRIPTION");
    }

    public String getEmployeeNumber() {
        return (String)this.getProperty("EMPLOYEE_NUMBER");
    }

    public String getEmployeeType() {
        return (String)this.getProperty("EMPLOYEE_TYPE");
    }

    public String getFirstName() {
        return (String)this.getProperty("FIRST_NAME");
    }

    public String getGivenName() {
        return (String)this.getProperty("GIVEN_NAME");
    }

    public String getHomeAddress() {
        return (String)this.getProperty("HOME_ADDRESS");
    }

    public String getHomePhone() {
        return (String)this.getProperty("HOME_PHONE");
    }

    public String getInitials() {
        return (String)this.getProperty("INITIALS");
    }

    public byte[] getJpegPhoto() {
        return (byte[])this.getProperty("JPEG_PHOTO");
    }

    public String getLastName() {
        return (String)this.getProperty("LAST_NAME");
    }

    public String getMaidenName() {
        return (String)this.getProperty("MAIDEN_NAME");
    }

    public String getManager() {
        return (String)this.getProperty("MANAGER");
    }

    public String getMiddleName() {
        return (String)this.getProperty("MIDDLE_NAME");
    }

    public String getNameSuffix() {
        return (String)this.getProperty("NAME_SUFFIX");
    }

    public String getOrganization() {
        return (String)this.getProperty("ORGANIZATION");
    }

    public String getOrganizationalUnit() {
        return (String)this.getProperty("ORGANIZATIONAL_UNIT");
    }

    public String getPreferredLanguage() {
        return (String)this.getProperty("PREFERRED_LANGUAGE");
    }

    public String getTimeZone() {
        return (String)this.getProperty("TIME_ZONE");
    }

    public String getTitle() {
        return (String)this.getProperty("TITLE");
    }

    public String getUserID() {
        return (String)this.getProperty("USER_ID");
    }

    public String getUserName() {
        return (String)this.getProperty("USER_NAME");
    }

    public String getWirelessAcctNumber() {
        return (String)this.getProperty("WIRELESS_ACCT_NUMBER");
    }

    public String getDisplayName() {
        return (String)this.getProperty("DISPLAY_NAME");
    }

    public String getGUID() {
        return (String)this.getProperty(UserProfileType.GUID);
    }

    public String getName() {
        return (String)this.getProperty(UserProfileType.NAME);
    }

    public Principal getPrincipal() {
        return _userMgr.getPrincipal(this.getName());
    }

    public String getUniqueName() {
        return (String)this.getProperty("UNIQUE_NAME");
    }

    public String getUIAccessMode() {
        return (String)this.getProperty("UI_ACCESS_MODE");
    }

    public void setBusinessCity(String businessCity) {
        this.setProperty("BUSINESS_CITY", businessCity);
    }

    public void setBusinessCountry(String businessCountry) {
        this.setProperty("BUSINESS_COUNTRY", businessCountry);
    }

    public void setBusinessEmail(String businessEmail) {
        this.setProperty("BUSINESS_EMAIL", businessEmail);
    }

    public void setBusinessFax(String businessFax) {
        this.setProperty("BUSINESS_FAX", businessFax);
    }

    public void setBusinessMobile(String businessMobile) {
        this.setProperty("BUSINESS_MOBILE", businessMobile);
    }

    public void setBusinessPager(String businessPager) {
        this.setProperty("BUSINESS_PAGER", businessPager);
    }

    public void setBusinessPhone(String businessPhone) {
        this.setProperty("BUSINESS_PHONE", businessPhone);
    }

    public void setBusinessPOBox(String businessPOBox) {
        this.setProperty("BUSINESS_PO_BOX", businessPOBox);
    }

    public void setBusinessPostalAddr(String businessPostalAddr) {
        this.setProperty("BUSINESS_POSTAL_ADDR", businessPostalAddr);
    }

    public void setBusinessPostalCode(String businessPostalCode) {
        this.setProperty("BUSINESS_POSTAL_CODE", businessPostalCode);
    }

    public void setBusinessState(String businessState) {
        this.setProperty("BUSINESS_STATE", businessState);
    }

    public void setBusinessStreet(String businessStreet) {
        this.setProperty("BUSINESS_STREET", businessStreet);
    }

    public void setDateofBirth(String dateofBirth) {
        this.setProperty("DATE_OF_BIRTH", dateofBirth);
    }

    public void setDateofHire(String dateofHire) {
        this.setProperty("DATE_OF_HIRE", dateofHire);
    }

    public void setDefaultGroup(String defaultGroup) {
        this.setProperty("DEFAULT_GROUP", defaultGroup);
    }

    public void setDepartment(String department) {
        this.setProperty("DEPARTMENT", department);
    }

    public void setDepartmentNumber(String departmentNumber) {
        this.setDepartment(departmentNumber);
    }

    public void setDescription(String description) {
        this.setProperty("DESCRIPTION", description);
    }

    public void setDisplayName(String displayName) {
        this.setProperty("DISPLAY_NAME", displayName);
    }

    public void setEmployeeNumber(String employeeNumber) {
        this.setProperty("EMPLOYEE_NUMBER", employeeNumber);
    }

    public void setEmployeeType(String employeeType) {
        this.setProperty("EMPLOYEE_TYPE", employeeType);
    }

    public void setFirstName(String firstName) {
        this.setProperty("FIRST_NAME", firstName);
    }

    public void setGivenName(String givenName) {
        this.setProperty("GIVEN_NAME", givenName);
    }

    public void setHomeAddress(String homeAddress) {
        this.setProperty("HOME_ADDRESS", homeAddress);
    }

    public void setHomePhone(String homePhone) {
        this.setProperty("HOME_PHONE", homePhone);
    }

    public void setInitials(String initials) {
        this.setProperty("INITIALS", initials);
    }

    public void setJpegPhoto(String jpeg) {
        this.setProperty("JPEG_PHOTO", jpeg);
    }

    public void setLastName(String lastName) {
        this.setProperty("LAST_NAME", lastName);
    }

    public void setMaidenName(String maidenName) {
        this.setProperty("MAIDEN_NAME", maidenName);
    }

    public void setManager(String manager) {
        this.setProperty("MANAGER", manager);
    }

    public void setMiddleName(String middleName) {
        this.setProperty("MIDDLE_NAME", middleName);
    }

    public void setName(String name) {
        this.setProperty("NAME", name);
    }

    public void setNameSuffix(String nameSuffix) {
        this.setProperty("NAME_SUFFIX", nameSuffix);
    }

    public void setOrganization(String organization) {
        this.setProperty("ORGANIZATION", organization);
    }

    public void setOrganizationalUnit(String organizationalUnit) {
        this.setProperty("ORGANIZATIONAL_UNIT", organizationalUnit);
    }

    public void setPreferredLanguage(String preferredLanguage) {
        this.setProperty("PREFERRED_LANGUAGE", preferredLanguage);
    }

    public void setTimeZone(String timeZone) {
        this.setProperty("TIME_ZONE", timeZone);
    }

    public void setTitle(String title) {
        this.setProperty("TITLE", title);
    }

    public void setUniqueName(String uniqueName) {
        this.setProperty("UNIQUE_NAME", uniqueName);
    }

    public void setUserID(String userID) {
        this.setProperty("USER_ID", userID);
    }

    public void setUserName(String userName) {
        this.setProperty("USER_NAME", userName);
    }

    public void setUIAccessMode(String uiAccessMode) {
        this.setProperty("UI_ACCESS_MODE", uiAccessMode);
    }

    public void setWirelessAcctNumber(String wirelessAcctNumber) {
        this.setProperty("WIRELESS_ACCT_NUMBER", wirelessAcctNumber);
    }

    public void saveProfile() {
        String METHOD_NAME = "saveProfile()";
        if (this._modifiedProps != null && this._modifiedProps.size() > 0) {
            _userMgr.saveUserProfile(this.getName(), this._modifiedProps);
            this._modifiedProps.clear();
        }
    }

    public Object getProperty(String propName) {
        Object value = null;
        if (this._values.containsKey(propName)) {
            return this._values.get(propName);
        }
        if (this._userName != null) {
            value = _userMgr.getUserProfilePropertyVal(this._userName, propName);
            this._values.put(propName, value);
        }
        return value;
    }

    public void setProperty(String name, Object value) {
        this._values.put(name, value);
        if (this._modifiedProps == null) {
            this._modifiedProps = new HashMap();
        }
        this._modifiedProps.put(name, value);
    }

    public HashMap getProperties() {
        return this._values;
    }

    public void setProperties(HashMap props) {
        this.internalSetProperties(props);
        if (this._modifiedProps == null) {
            this._modifiedProps = new HashMap();
        }
        this._modifiedProps.putAll(props);
    }

    final void internalSetProperties(HashMap props) {
        this._internalMap.clear();
        this._values.clear();
        for (Object key : props.keySet()) {
            if (key instanceof UserProfileType) {
                this._internalMap.put(key, props.get(key));
                continue;
            }
            this._values.put(key, props.get(key));
        }
    }

    Object getProperty(UserProfileType type) {
        Object value = null;
        if (this._internalMap.containsKey((Object)type)) {
            return this._internalMap.get((Object)type);
        }
        String propName = type.getAttributeName();
        if (this._values.containsKey(propName)) {
            return this._values.get(propName);
        }
        if (this._userName != null) {
            value = _userMgr.getUserProfilePropertyVal(this._userName, type);
            this._values.put(propName, value);
        }
        return value;
    }
}

