/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.ActionLogger;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.ControllerProvider;
import oracle.ide.controller.LabelUpdater;
import oracle.ide.controller.WrappingController;
import oracle.ide.controls.ToggleAction;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.ideimpl.controller.ControllersHook;
import oracle.javatools.util.StringUtil;

public class IdeAction
extends ToggleAction {
    private final ArrayList<Controller> _controllers = new ArrayList(1);
    private MetaClass _metaClass;
    private DelegatingClassLoader _delegatingClassLoader;
    private ClassLoader _classloader;
    private int _commandId;
    private LabelUpdater _labelUpdater;
    private String _name;
    public static final String INVOKED_FROM = "invokedFrom";
    static final String EVENT_SOURCE = "eventSource";
    public static final String ORIGINAL_ACTION_NAME = "oracle.id.IdeAction.NAME";
    private static boolean _handlerInProgress;
    private static final Logger LOG;
    public static final String PERMANENTLY_DISABLED_KEY = "oracle.ide.IdeAction.permanently-disable";
    public static final String LAST_TOOLTIP_SUFFIX = "last-tooltip-suffix";
    public static final String CONTROLLER_HANDLING_UPDATE = "controller-handling-update";
    public static final boolean DEBUG;

    @Deprecated
    protected IdeAction() {
        super(null, null);
        if (!"oracle.ideimpl.jsr198.JSR198Action".equals(this.getClass().getName())) {
            throw new UnsupportedOperationException();
        }
        this._delegatingClassLoader = new DelegatingClassLoader(this);
    }

    private IdeAction(String name, Icon icon) {
        super(name, icon);
        this._delegatingClassLoader = new DelegatingClassLoader(this);
    }

    private IdeAction(IdeAction action) {
        super(action);
        this._delegatingClassLoader = new DelegatingClassLoader(this);
        this.setCommand(action._metaClass);
        this._commandId = action._commandId;
    }

    private IdeAction(String name, ResourceBundle bundle, String key) {
        super(name, bundle, key);
        this._delegatingClassLoader = new DelegatingClassLoader(this);
    }

    private IdeAction(String name, ArrayResourceBundle bundle, int key) {
        super(name, bundle, key);
        this._delegatingClassLoader = new DelegatingClassLoader(this);
    }

    private static MetaClass toMetaClass(String cmdClass) {
        return cmdClass != null ? new MetaClass((ClassLoader)new DelegatingClassLoader(), cmdClass) : null;
    }

    @Deprecated
    public static IdeAction get(int cmdId, String cmdClass, String name) {
        return IdeAction.findOrCreate(cmdId, IdeAction.toMetaClass(cmdClass), name);
    }

    public static IdeAction findOrCreate(int cmdId, MetaClass cmdClass, String name) {
        Integer id;
        ActionMap ideActionMap = Ide.getIdeActionMap();
        IdeAction action = (IdeAction)ideActionMap.get(id = Integer.valueOf(cmdId));
        if (action != null) {
            return action;
        }
        action = IdeAction.create(cmdId, cmdClass, name, null, null, null, null, null, -1, null, true);
        ideActionMap.put(id, action);
        return action;
    }

    @Deprecated
    public static IdeAction get(int cmdId, String cmdClass, String name, ArrayResourceBundle bundle, int key) {
        return IdeAction.findOrCreate(cmdId, IdeAction.toMetaClass(cmdClass), name, bundle, key);
    }

    private static IdeAction findOrCreate(int cmdId, MetaClass cmdClass, String name, ArrayResourceBundle bundle, int key) {
        Integer id;
        ActionMap ideActionMap = Ide.getIdeActionMap();
        IdeAction action = (IdeAction)ideActionMap.get(id = Integer.valueOf(cmdId));
        if (action != null) {
            return action;
        }
        action = IdeAction.create(cmdId, cmdClass, name, null, null, null, (ResourceBundle)bundle, null, key, null, true);
        ideActionMap.put(id, action);
        return action;
    }

    @Deprecated
    public static IdeAction get(int cmdId, String cmdClass, String name, String sCategory, Integer mnemonic, Icon icon, Object data, boolean enabled) {
        return IdeAction.findOrCreate(cmdId, IdeAction.toMetaClass(cmdClass), name, sCategory, mnemonic, icon, data, enabled);
    }

    public static IdeAction findOrCreate(int cmdId, MetaClass cmdClass, String name, String sCategory, Integer mnemonic, Icon icon, Object data, boolean enabled) {
        Integer id;
        ActionMap ideActionMap = Ide.getIdeActionMap();
        IdeAction action = (IdeAction)ideActionMap.get(id = Integer.valueOf(cmdId));
        if (action != null) {
            return action;
        }
        action = IdeAction.create(cmdId, cmdClass, name, sCategory, mnemonic, icon, null, null, -1, data, enabled);
        ideActionMap.put(id, action);
        return action;
    }

    public static IdeAction getEnabled(int cmdId, String name) {
        return IdeAction.findOrCreate(cmdId, null, name, null, null, null, null, true);
    }

    public static IdeAction getEnabled(int cmdId, String name, String category) {
        return IdeAction.findOrCreate(cmdId, null, name, category, null, null, null, true);
    }

    public static IdeAction getEnabled(int cmdId, String name, Icon icon) {
        return IdeAction.findOrCreate(cmdId, null, name, null, null, icon, null, true);
    }

    @Deprecated
    public static IdeAction get(int cmdId, String cmdClass, String name, String sCategory, Integer mnemonic, ArrayResourceBundle bundle, int key, Object data, boolean enabled) {
        return IdeAction.findOrCreate(cmdId, IdeAction.toMetaClass(cmdClass), name, sCategory, mnemonic, bundle, key, data, enabled);
    }

    private static IdeAction findOrCreate(int cmdId, MetaClass cmdClass, String name, String sCategory, Integer mnemonic, ArrayResourceBundle bundle, int key, Object data, boolean enabled) {
        Integer id;
        ActionMap ideActionMap = Ide.getIdeActionMap();
        IdeAction action = (IdeAction)ideActionMap.get(id = Integer.valueOf(cmdId));
        if (action != null) {
            return action;
        }
        action = IdeAction.create(cmdId, cmdClass, name, sCategory, mnemonic, null, (ResourceBundle)bundle, null, key, data, enabled);
        ideActionMap.put(id, action);
        return action;
    }

    @Deprecated
    public static IdeAction get(int cmdId, String cmdClass, String name, String sCategory, Integer mnemonic, ResourceBundle bundle, String key, Object data, boolean enabled) {
        return IdeAction.findOrCreate(cmdId, IdeAction.toMetaClass(cmdClass), name, sCategory, mnemonic, bundle, key, data, enabled);
    }

    public static IdeAction findOrCreate(int cmdId, MetaClass cmdClass, String name, String sCategory, Integer mnemonic, ResourceBundle bundle, String key, Object data, boolean enabled) {
        Integer id;
        ActionMap ideActionMap = Ide.getIdeActionMap();
        IdeAction action = (IdeAction)ideActionMap.get(id = Integer.valueOf(cmdId));
        if (action != null) {
            return action;
        }
        action = IdeAction.create(cmdId, cmdClass, name, sCategory, mnemonic, null, bundle, key != null ? key : "", -1, data, enabled);
        ideActionMap.put(id, action);
        return action;
    }

    public static IdeAction getEnabled(int cmdId, String name, ResourceBundle bundle) {
        return IdeAction.findOrCreate(cmdId, (MetaClass)null, name, null, null, bundle, null, null, true);
    }

    public static IdeAction get(int cmdId) {
        return IdeAction.get(cmdId, (String)null, (Integer)null);
    }

    @Deprecated
    public static IdeAction get(int cmdId, String name, Integer mnemonic) {
        IdeAction action = IdeAction.findOrCreate(cmdId, null, name);
        if (mnemonic != null) {
            action.putValue("MnemonicKey", mnemonic);
        }
        return action;
    }

    public static IdeAction find(int cmdId) {
        if (Ide.isRunning()) {
            return (IdeAction)Ide.getIdeActionMap().get(cmdId);
        }
        return null;
    }

    public static IdeAction find(String commandName) {
        IdeAction ret = null;
        Integer cmdID = Ide.findCmdID(commandName);
        if (cmdID != null) {
            ret = IdeAction.find(cmdID);
        }
        return ret;
    }

    public static void remove(int cmdId) {
        Ide.getIdeActionMap().remove(cmdId);
    }

    public static IdeAction[] findGroup(String groupName) {
        ActionMap actionMap = Ide.getIdeActionMap();
        Object[] keys = actionMap.allKeys();
        if (keys == null || keys.length == 0) {
            return null;
        }
        TreeMap<Object, IdeAction> group = new TreeMap<Object, IdeAction>();
        for (int i = 0; i < keys.length; ++i) {
            IdeAction action;
            String buttonGroup;
            Object key = keys[i];
            Action value = actionMap.get(key);
            if (!(value instanceof IdeAction) || (buttonGroup = (String)(action = (IdeAction)value).getValue("RadioGroupName")) == null || !buttonGroup.equals(groupName)) continue;
            group.put(key, action);
        }
        return group.size() > 0 ? group.values().toArray(new IdeAction[group.size()]) : null;
    }

    @Override
    public final void actionPerformed(ActionEvent event) {
        this.actionPerformedImpl(event);
    }

    public final void performAction() throws Exception {
        this.performAction(this.getView().getContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void performAction(Context context) throws Exception {
        ActionLogger.logActionPerformed(context, this);
        boolean alreadyInProgress = IdeAction.handlerStarting();
        FeedbackManager.addFeedback("Performing action (" + this._commandId + ") " + this.getValue("Name"), context);
        if (DEBUG) {
            Object object;
            System.out.println("Performing action (" + this._commandId + ") " + this.getValue("Name"));
            if (context.getEvent() != null && (object = context.getEvent().getSource()) instanceof JComponent) {
                Object weight = ((JComponent)object).getClientProperty("menu-weight");
                Object section = ((JComponent)object).getClientProperty("menu-section-id");
                System.out.println(this.getValue("Name") + " menu item weight = " + weight + ", section = " + section);
            }
        }
        try {
            final View contextView = context != null ? context.getView() : null;
            ControllerIterator iter = new ControllerIterator(){

                @Override
                protected View _getView() {
                    return contextView != null ? contextView : IdeAction.this.getView();
                }
            };
            while (iter.hasNext()) {
                Controller controller = iter.next();
                try {
                    if (!controller.handleEvent(this, context)) continue;
                    if (DEBUG) {
                        System.out.println("Action handled by " + controller);
                    }
                    return;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    FeedbackManager.reportException("Exception while performing action " + this.getValue("Name"), t);
                }
                finally {
                    this.setEnabled(this.enabled);
                }
            }
            if (DEBUG) {
                System.out.println("No Controller handled action '" + this.getValue("Name") + "' (id=" + this._commandId + ") -- checking CommandProcessor...");
            }
            Command cmd = null;
            if (this.getCommandMetaClass() != null) {
                Class cl = this.getCommandMetaClass().toClass();
                if (cl != null) {
                    cmd = CommandProcessor.createCommandFromMeta(this.getCommandMetaClass(), context);
                }
            } else {
                cmd = this.getCommand() == null ? null : CommandProcessor.createCommandFromMeta(new MetaClass(this.getClassloader() != null ? this.getClassloader() : Thread.currentThread().getContextClassLoader(), this.getCommand()), context);
            }
            if (cmd != null) {
                if (DEBUG) {
                    System.out.println("Invoking Command class (" + this._commandId + ") " + cmd.getClass().getName());
                }
                CommandProcessor.getInstance().invoke(cmd);
            } else {
                LOG.log(Level.FINE, this.unhandledActionError());
            }
        }
        finally {
            IdeAction.handlerFinished(alreadyInProgress, Controller.UPDATE_FROM_ACTION_PERFORMED);
        }
    }

    private String unhandledActionError() {
        StringBuilder msg = new StringBuilder();
        msg.append("Error during handleEvent on action '");
        msg.append(this.getValue("Name"));
        msg.append("' (id=");
        msg.append(Ide.findCmdName(this._commandId));
        msg.append(").\n");
        msg.append("None of the attached controllers handled the action.");
        for (Controller c : this.getControllers()) {
            msg.append("\n - ");
            msg.append(c);
        }
        msg.append(".\n");
        return msg.toString();
    }

    public final void updateAction() {
        this.updateAction(this.getView().getContext());
    }

    /*
     * Exception decompiling
     */
    public final void updateAction(Context context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setLabelUpdater(LabelUpdater labelUpdater) {
        this._labelUpdater = labelUpdater;
    }

    public LabelUpdater getLabelUpdater() {
        return this._labelUpdater;
    }

    private void updateLabel(Context context) {
        if (this._labelUpdater != null) {
            if (this._name == null) {
                String stored = (String)this.getValue(ORIGINAL_ACTION_NAME);
                this._name = stored != null ? stored : (String)super.getValue("Name");
                this.putValue(ORIGINAL_ACTION_NAME, this._name);
            }
            String oldLabel = (String)super.getValue("Name");
            final String newLabel = this.isEnabled() ? this._labelUpdater.labelWhenEnabled(context, this, this._name) : this._labelUpdater.labelWhenDisabled(context, this, this._name);
            if (newLabel != null && !newLabel.equals(oldLabel)) {
                final int mnemonicIndex = StringUtils.getMnemonicIndex((String)newLabel);
                final String strippedNewLabel = StringUtils.stripMnemonic((String)newLabel);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        IdeAction.this.putValue("Name", strippedNewLabel);
                        if (mnemonicIndex != -1) {
                            IdeAction.this.putValue("MnemonicKey", StringUtils.getMnemonicKeyCode((String)newLabel));
                        }
                    }
                };
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(runnable);
                } else {
                    runnable.run();
                }
            }
            if (context != null) {
                context.removeProperty("oracle.ide.label_updater_macros");
            }
        }
    }

    @Override
    public Object getValue(String key) {
        if (key == "Name" && this._labelUpdater != null && !Ide.isStarting()) {
            this.updateLabel(this.getView().getContext());
        }
        return super.getValue(key);
    }

    private void appendToToolTip(Controller controller) {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        String cmdName = Ide.findCmdName(this.getCommandId());
        if (cmdName != null) {
            buf.append("id=");
            buf.append(cmdName);
            buf.append(" ");
        }
        buf.append("controller=");
        String explicitHandler = (String)this.getValue(CONTROLLER_HANDLING_UPDATE);
        buf.append(explicitHandler != null ? explicitHandler : controller.toString());
        buf.append("]");
        String suffix = buf.toString();
        String lastSuffix = (String)this.getValue(LAST_TOOLTIP_SUFFIX);
        String updateStr = (String)this.getValue("ShortDescription");
        if (updateStr == null) {
            updateStr = "";
        }
        if (lastSuffix != null) {
            updateStr = updateStr.replace(lastSuffix, "");
        }
        this.putValue(LAST_TOOLTIP_SUFFIX, suffix);
        updateStr = updateStr + suffix;
        this.putValue("ShortDescription", updateStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addController(Controller controller) {
        if (controller == null) {
            return;
        }
        WrappingController wrapped = this.wrapController(controller);
        ArrayList<Controller> arrayList = this._controllers;
        synchronized (arrayList) {
            if (!this._controllers.contains(wrapped)) {
                this._controllers.add(0, wrapped);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addControllerLast(Controller controller) {
        if (controller == null) {
            return;
        }
        WrappingController wrapped = this.wrapController(controller);
        ArrayList<Controller> arrayList = this._controllers;
        synchronized (arrayList) {
            if (!this._controllers.contains(wrapped)) {
                if (this._controllers.isEmpty()) {
                    this._controllers.add(wrapped);
                } else {
                    this._controllers.add(this._controllers.size() - 1, wrapped);
                }
            }
        }
    }

    public static void addController(int actionID, Controller controller) {
        IdeAction action = IdeAction.find(actionID);
        if (action != null) {
            action.addController(controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeController(Controller controller) {
        if (controller != null) {
            WrappingController wrapped = this.wrapController(controller);
            ArrayList<Controller> arrayList = this._controllers;
            synchronized (arrayList) {
                this._controllers.remove(wrapped);
            }
        }
    }

    private WrappingController wrapController(Controller controller) {
        if (controller instanceof WrappingController) {
            return (WrappingController)controller;
        }
        return new ControllerDelegatingController(controller);
    }

    public static void removeController(int actionID, Controller controller) {
        IdeAction action = IdeAction.find(actionID);
        if (action != null) {
            action.removeController(controller);
        }
    }

    public final String getCommand() {
        return this._metaClass != null ? this._metaClass.getClassName() : null;
    }

    public final MetaClass getCommandMetaClass() {
        return this._metaClass;
    }

    @Deprecated
    public final void setCommand(String command) {
        if (command == null) {
            this.setCommand((MetaClass)null);
        } else {
            this.setCommand(new MetaClass((ClassLoader)this._delegatingClassLoader, command));
        }
    }

    public final void setCommand(MetaClass metaClass) {
        if (metaClass == null) {
            this._metaClass = null;
        } else {
            if ("oracle.ide.cmd.NotImplementedCommand".equals(metaClass.getClassName())) {
                return;
            }
            if (this._metaClass == null) {
                this._metaClass = metaClass;
            } else if (!this._metaClass.equals((Object)metaClass)) {
                this._metaClass = metaClass;
            }
        }
    }

    public final void setCommandId(int commandId) {
        this._commandId = commandId;
    }

    public final int getCommandId() {
        return this._commandId;
    }

    public final void putValueDirectly(String key, Object value) {
        super.putValue(key, value);
    }

    public static IdeAction newLocalAction(int cmdId, View view) {
        IdeAction globalAction = IdeAction.find(cmdId);
        if (globalAction != null) {
            return globalAction.newLocalAction(view);
        }
        return null;
    }

    public IdeAction newLocalAction(View view) {
        return new Local(this, view);
    }

    public final boolean isLocalAction() {
        return this.getClass() == Local.class;
    }

    View getView() {
        return Ide.getMainWindow().getLastActiveView();
    }

    ArrayList<Controller> getControllers() {
        return (ArrayList)this.getControllersDirectly().clone();
    }

    final ArrayList<Controller> getControllersDirectly() {
        return this._controllers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void actionPerformedImpl(ActionEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            IdeAction.freezeKeyboard(true);
            Context context = null;
            if (event.getSource() instanceof JMenuItem) {
                JMenuItem item = (JMenuItem)event.getSource();
                context = ContextMenu.getContext(item, event);
                ContextMenu.clearContext(item);
            }
            if (context == null) {
                context = this.getView().getContext(event);
            }
            this.putValue(EVENT_SOURCE, event.getSource());
            this.performAction(context);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Exception peforming action", e);
        }
        finally {
            IdeAction.freezeKeyboard(false);
            this.putValue(EVENT_SOURCE, null);
        }
    }

    static synchronized boolean handlerStarting() {
        boolean oldValue = _handlerInProgress;
        _handlerInProgress = true;
        return oldValue;
    }

    public static synchronized boolean isHandlerInProgress() {
        return _handlerInProgress;
    }

    static synchronized void handlerFinished(boolean alreadyInProgress, int updateSource) {
        try {
            if (!alreadyInProgress) {
                IdeMainWindow.updateVisibleActions(updateSource);
                _handlerInProgress = false;
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private static IdeAction create(int cmdId, MetaClass cmdClass, String name, String sCategory, Integer mnemonic, Icon icon, ResourceBundle bundle, String strKey, int intKey, Object data, boolean enabled) {
        String label = StringUtil.addMnemonicToLabelIfNotPresentAlready((String)name, (Integer)mnemonic);
        IdeAction action = icon != null ? new IdeAction(label, icon) : (strKey != null ? new IdeAction(label, bundle, strKey) : new IdeAction(label, (ArrayResourceBundle)bundle, intKey));
        action._commandId = cmdId;
        action.setCommand(cmdClass);
        if (sCategory != null) {
            action.putValue("Category", sCategory);
        }
        if (mnemonic != null) {
            action.putValue("MnemonicKey", mnemonic);
        }
        if (data != null) {
            action.putValue("UserData", data);
        }
        ControllersHook controllersHook = (ControllersHook)ExtensionRegistry.getExtensionRegistry().getHook(ControllersHook.ELEMENT);
        controllersHook.attachControllersToAction(action);
        action.setEnabled(enabled);
        return action;
    }

    public void setClassloader(ClassLoader classloader) {
        this._classloader = classloader;
    }

    public ClassLoader getClassloader() {
        return this._classloader;
    }

    static {
        LOG = Logger.getLogger(IdeAction.class.getName());
        DEBUG = Boolean.getBoolean("ide.IdeAction.debug");
    }

    private static class DelegatingClassLoader
    extends ClassLoader {
        private IdeAction _action;

        public DelegatingClassLoader() {
            this((IdeAction)null);
        }

        public DelegatingClassLoader(IdeAction action) {
            this._action = action;
        }

        private ClassLoader getDelegate() {
            ClassLoader classloader = this._action != null ? this._action.getClassloader() : null;
            return classloader != null ? classloader : Thread.currentThread().getContextClassLoader();
        }

        @Override
        public synchronized void setPackageAssertionStatus(String packageName, boolean enabled) {
            this.getDelegate().setPackageAssertionStatus(packageName, enabled);
        }

        @Override
        public synchronized void setDefaultAssertionStatus(boolean enabled) {
            this.getDelegate().setDefaultAssertionStatus(enabled);
        }

        @Override
        public synchronized void setClassAssertionStatus(String className, boolean enabled) {
            this.getDelegate().setClassAssertionStatus(className, enabled);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return this.getDelegate().loadClass(name);
        }

        public int hashCode() {
            return this.getDelegate().hashCode();
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return this.getDelegate().getResources(name);
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            return this.getDelegate().getResourceAsStream(name);
        }

        @Override
        public URL getResource(String name) {
            return this.getDelegate().getResource(name);
        }

        public boolean equals(Object obj) {
            return this.getDelegate().equals(obj);
        }

        @Override
        public synchronized void clearAssertionStatus() {
            this.getDelegate().clearAssertionStatus();
        }

        public String toString() {
            return this.getDelegate().toString();
        }
    }

    private static class ControllerDelegatingController
    implements WrappingController {
        private final Controller _delegate;

        public ControllerDelegatingController(Controller delegate) {
            this._delegate = delegate;
        }

        @Override
        public boolean handleEvent(IdeAction action, Context context) {
            return this._delegate.handleEvent(action, context);
        }

        @Override
        public boolean update(IdeAction action, Context context) {
            return this._delegate.update(action, context);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof ControllerDelegatingController) {
                ControllerDelegatingController other = (ControllerDelegatingController)obj;
                return this._delegate.equals(other._delegate);
            }
            return this._delegate.equals(obj);
        }

        public int hashCode() {
            return this._delegate.hashCode();
        }

        public String toString() {
            return super.toString() + "[" + this._delegate + "]";
        }
    }

    private static final class Local
    extends IdeAction {
        private final IdeAction _action;
        private final View _view;

        Local(IdeAction action, View view) {
            super(action);
            this._action = action;
            this._view = view;
            this.setEnabled(action.isEnabled());
        }

        @Override
        public Object getValue(String key) {
            Object value = super.getValue(key);
            if (value == null) {
                value = this._action.getValue(key);
            }
            return value;
        }

        @Override
        public void putValue(String key, Object value) {
            this.putValueDirectly(key, value);
            if (this._action != null) {
                this._action.putValue(key, value);
            }
        }

        @Override
        public IdeAction newLocalAction(View view) {
            return new Local(this._action, view);
        }

        @Override
        final View getView() {
            return this._view != null ? this._view : super.getView();
        }

        @Override
        final ArrayList<Controller> getControllers() {
            ArrayList<Controller> controllers = new ArrayList<Controller>();
            controllers.addAll(this.getControllersDirectly());
            if (this._action != null) {
                controllers.addAll(this._action.getControllersDirectly());
            }
            return controllers;
        }
    }

    protected class ControllerIterator {
        private final ArrayList<Controller> _actionControllers;
        private final Iterator<Controller> _actionControllersIter;
        private boolean _triedActionViewController;
        private int _i;
        private List _controllerStack;
        private boolean _triedIdeController;
        private Controller _curController;

        protected ControllerIterator() {
            this._actionControllers = IdeAction.this.getControllers();
            this._actionControllersIter = this._actionControllers.iterator();
        }

        boolean hasNext() {
            this.tryNext();
            return this._curController != null;
        }

        Controller next() {
            this.tryNext();
            Controller controller = this._curController;
            this._curController = null;
            return controller;
        }

        private void tryNext() {
            if (this._curController == null) {
                this._curController = this.nextImpl();
            }
        }

        protected View _getView() {
            return IdeAction.this.getView();
        }

        private Controller nextImpl() {
            if (this._actionControllersIter.hasNext()) {
                return this._actionControllersIter.next();
            }
            View view = this._getView();
            if (!this._triedActionViewController) {
                Controller controller;
                this._triedActionViewController = true;
                if (view != null && (controller = view.getController()) != null) {
                    return controller;
                }
            }
            if (this._controllerStack == null) {
                IdeMainWindow mainWindow = Ide.getMainWindow();
                IdeMainWindow.ControllerContext controllerContext = mainWindow.getControllerContext();
                this._controllerStack = controllerContext.getControllerProviders(view);
            }
            int controllerStackSize = this._controllerStack.size();
            while (this._i < controllerStackSize) {
                ControllerProvider controllerProvider;
                Controller controller;
                if ((controller = (controllerProvider = (ControllerProvider)this._controllerStack.get(this._i++)).getController()) == null) continue;
                return controller;
            }
            if (!this._triedIdeController) {
                this._triedIdeController = true;
                return Ide.getIdeController();
            }
            return null;
        }
    }
}

