/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Color;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import oracle.bali.ewt.chooser.color.ColorChoice;
import oracle.bali.ewt.chooser.color.ColorGrid;
import oracle.bali.ewt.chooser.color.CustomColorPane;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.ide.Ide;
import oracle.ide.config.DTCache;
import oracle.ide.help.HelpSystem;

public class CustomColorChoice
extends ColorChoice {
    private CustomColorPane customPane;
    private static final String CUSTOM_PALETTE_KEY = "ColorChoice.CustomPalette";
    private static TwoDModel CUSTOM_PALETTE;
    private static final Color[][] BALI256_SWATCH_ARRAY;
    public static final TwoDModel DEFAULT_SWATCH_MODEL;

    public CustomColorChoice() {
        super((Icon)null, DEFAULT_SWATCH_MODEL, (Color)null);
        this.setEditAllowed(true);
        this.setTransparentAllowed(false);
        TwoDModel customPalette = CustomColorChoice.getCustomPalette();
        this.setCustomColorPalette(customPalette);
    }

    public synchronized CustomColorPane getCustomColorPane() {
        if (this.customPane == null) {
            this.customPane = super.getCustomColorPane();
            this.customPane.setColorPickerMask(1);
            this.customPane.setColorNameVisible(false);
            HelpSystem helpSystem = HelpSystem.getHelpSystem();
            if (helpSystem != null) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)this.customPane, "f1_idedcolorpaled_html");
            }
        }
        return this.customPane;
    }

    public void setClosestSelectedColor(Color color) {
        this.setSelectedColor(color);
    }

    protected static boolean isColorInPalette(Color color, TwoDModel palette) {
        int numRows = palette.getRowCount();
        int numColumns = palette.getColumnCount();
        for (int row = 0; row < numRows; ++row) {
            for (int col = 0; col < numColumns; ++col) {
                Color checkColor = (Color)palette.getData(col, row);
                if (checkColor == null || !checkColor.equals(color)) continue;
                return true;
            }
        }
        return false;
    }

    protected static synchronized TwoDModel getCustomPalette() {
        if (CUSTOM_PALETTE == null) {
            TwoDModel customModel = ColorGrid.getDefaultCustomColorPalette((TwoDModel)DEFAULT_SWATCH_MODEL);
            int numColumns = customModel.getColumnCount();
            int numRows = customModel.getRowCount();
            CUSTOM_PALETTE = new WeakArrayTwoDModel(numColumns, numRows);
            CustomColorChoice.loadPalette(CUSTOM_PALETTE);
            CUSTOM_PALETTE.addModelListener(new TwoDModelListener(){

                public void rowsAdded(TwoDModelEvent e) {
                }

                public void rowsRemoved(TwoDModelEvent e) {
                }

                public void columnsAdded(TwoDModelEvent e) {
                }

                public void columnsRemoved(TwoDModelEvent e) {
                }

                private void paletteChanged() {
                    CustomColorChoice.savePalette(CUSTOM_PALETTE);
                }

                public void invalidateRows(TwoDModelEvent e) {
                    this.paletteChanged();
                }

                public void invalidateColumns(TwoDModelEvent e) {
                    this.paletteChanged();
                }

                public void invalidateCells(TwoDModelEvent e) {
                    this.paletteChanged();
                }
            });
        }
        return CUSTOM_PALETTE;
    }

    protected static void loadPalette(TwoDModel palette) {
        int numColumns = palette.getColumnCount();
        int numRows = palette.getRowCount();
        DTCache dtCache = Ide.getDTCache();
        List paletteList = (List)dtCache.getData(CUSTOM_PALETTE_KEY);
        int listSize = paletteList == null ? 0 : paletteList.size();
        int index = 0;
        for (int row = 0; row < numRows; ++row) {
            for (int col = 0; col < numColumns; ++col) {
                Color color = Color.white;
                if (index < listSize) {
                    Integer colorInt;
                    color = (colorInt = (Integer)paletteList.get(index++)) == null ? Color.white : new Color(colorInt);
                }
                palette.setData(col, row, (Object)color);
            }
        }
    }

    protected static void savePalette(TwoDModel palette) {
        ArrayList<Integer> paletteList = new ArrayList<Integer>();
        int numColumns = palette.getColumnCount();
        int numRows = palette.getRowCount();
        for (int row = 0; row < numRows; ++row) {
            for (int col = 0; col < numColumns; ++col) {
                Color color = (Color)palette.getData(col, row);
                Integer colorInt = null;
                if (color != null) {
                    colorInt = color.getRGB();
                }
                paletteList.add(colorInt);
            }
        }
        DTCache dtCache = Ide.getDTCache();
        dtCache.putData(CUSTOM_PALETTE_KEY, paletteList);
    }

    static {
        ColorChoice.setCustomColorPaneSupported((boolean)true);
        BALI256_SWATCH_ARRAY = new Color[][]{{new Color(0xFFFFFF), new Color(0xC6C6C6), new Color(0x848484), new Color(0), new Color(0xFF0000), new Color(0xFFFF00), new Color(65280), new Color(63479), new Color(255), new Color(0xFF00FF), new Color(0x840000), new Color(0x848400), new Color(33792), new Color(33924), new Color(132), new Color(0x840084)}, {new Color(0xF7F7F7), new Color(0xFFD6D6), new Color(16768726), new Color(16773078), new Color(16775126), new Color(16252886), new Color(15204310), new Color(0xD6FFD6), new Color(14090223), new Color(0xD6FFFF), new Color(14088191), new Color(14084095), new Color(0xD6D6FF), new Color(15718143), new Color(0xFFD6FF), new Color(16766703)}, {new Color(0xE7E7E7), new Color(0xFFB5B5), new Color(16762549), new Color(16768693), new Color(16773045), new Color(0xFFFFB5), new Color(15204277), new Color(0xB5FFB5), new Color(11927518), new Color(0xB5FFFF), new Color(11921407), new Color(13031167), new Color(0xC6C6FF), new Color(14595583), new Color(0xFFB5FF), new Color(16758238)}, {new Color(0xD6D6D6), new Color(0xFFA5A5), new Color(16760229), new Color(16766629), new Color(16770964), new Color(0xFFFF94), new Color(14090132), new Color(0xA5FFA5), new Color(10878934), new Color(0xA5FFFF), new Color(10872831), new Color(10864383), new Color(0xA5A5FF), new Color(14067199), new Color(0xFFA5FF), new Color(16754134)}, {new Color(0xC6C6C6), new Color(0xFF9494), new Color(16754052), new Color(16762500), new Color(16768627), new Color(0xFFFF73), new Color(14090116), new Color(0x94FF94), new Color(9764814), new Color(0x84FFFF), new Color(9756415), new Color(9745919), new Color(0x9494FF), new Color(13538559), new Color(0xFF84FF), new Color(16749774)}, {new Color(0xB5B5B5), new Color(0xFF8484), new Color(16749683), new Color(16758115), new Color(16768611), new Color(0xFFFF42), new Color(13041507), new Color(0x73FF73), new Color(7602109), new Color(0x73FFFF), new Color(8705791), new Color(8695295), new Color(0x8484FF), new Color(13010175), new Color(0xFF73FF), new Color(16745670)}, {new Color(0xA5A5A5), new Color(0xFF6363), new Color(16743250), new Color(16756050), new Color(16766530), new Color(0xFFFF00), new Color(11927362), new Color(0x63FF63), new Color(6553525), new Color(0x52FFFF), new Color(6541055), new Color(7579135), new Color(0x7373FF), new Color(11887615), new Color(0xFF52FF), new Color(16737205)}, {new Color(0x949494), new Color(0xFF5252), new Color(16741186), new Color(16751665), new Color(16762368), new Color(0xF7F700), new Color(10288896), new Color(0x52FF52), new Color(5439405), new Color(65535), new Color(5424895), new Color(5410047), new Color(0x6363FF), new Color(11358975), new Color(0xFF42FF), new Color(16732845)}, {new Color(0x737373), new Color(0xFF4242), new Color(16734753), new Color(16745472), new Color(16233728), new Color(0xE7E700), new Color(9762560), new Color(65280), new Color(65412), new Color(63479), new Color(4376319), new Color(4359423), new Color(0x5252FF), new Color(10830591), new Color(0xFF21FF), new Color(16728741)}, {new Color(0x636363), new Color(0xFF2121), new Color(16728576), new Color(15168256), new Color(14064640), new Color(0xC6C600), new Color(8705536), new Color(59136), new Color(59251), new Color(54998), new Color(44543), new Color(3240959), new Color(0x3131FF), new Color(9708031), new Color(0xFF00FF), new Color(16720276)}, {new Color(0x525252), new Color(0xFF0000), new Color(15153408), new Color(14052096), new Color(13014016), new Color(0xB5B500), new Color(7587328), new Color(54784), new Color(54891), new Color(50886), new Color(38119), new Color(21247), new Color(0x2121FF), new Color(8651007), new Color(0xE700E7), new Color(16711812)}, {new Color(0x424242), new Color(0xE70000), new Color(12988672), new Color(11885056), new Color(10844928), new Color(0xA5A500), new Color(6530304), new Color(46336), new Color(46426), new Color(42405), new Color(33990), new Color(19175), new Color(255), new Color(7536871), new Color(0xC600C6), new Color(15138931)}, {new Color(0x313131), new Color(0xC60000), new Color(10823936), new Color(10834432), new Color(9726720), new Color(0x949400), new Color(5936128), new Color(42240), new Color(42322), new Color(38036), new Color(27557), new Color(17094), new Color(214), new Color(6488262), new Color(0xA500A5), new Color(12976227)}, {new Color(0x212121), new Color(0x940000), new Color(9707776), new Color(8667648), new Color(8676096), new Color(0x737300), new Color(5407744), new Color(33792), new Color(33858), new Color(33924), new Color(25492), new Color(12692), new Color(165), new Color(4849812), new Color(0x940094), new Color(9699402)}, {new Color(0x101010), new Color(0x730000), new Color(7542784), new Color(6500608), new Color(6507008), new Color(0x636300), new Color(3760896), new Color(25344), new Color(25393), new Color(25443), new Color(19059), new Color(8563), new Color(132), new Color(3735667), new Color(0x730073), new Color(7536697)}, {new Color(0), new Color(0x520000), new Color(5378048), new Color(5384448), new Color(5388544), new Color(0x525200), new Color(3232256), new Color(20992), new Color(21033), new Color(21074), new Color(12626), new Color(6226), new Color(82), new Color(2687058), new Color(0x520052), new Color(5373993)}};
        DEFAULT_SWATCH_MODEL = new WeakArrayTwoDModel(BALI256_SWATCH_ARRAY);
    }

    private static class WeakArrayTwoDModel
    extends ArrayTwoDModel
    implements TwoDModelListener {
        private ArrayList _listenerList = null;

        private WeakArrayTwoDModel(int columns, int rows) {
            super(columns, rows);
        }

        private WeakArrayTwoDModel(Object[][] contents) {
            super(contents);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addModelListener(TwoDModelListener listener) {
            Object object = this;
            synchronized (object) {
                if (this._listenerList == null) {
                    this._listenerList = new ArrayList(100);
                    super.addModelListener((TwoDModelListener)this);
                }
            }
            object = this._listenerList;
            synchronized (object) {
                this._listenerList.add(new WeakReference<TwoDModelListener>(listener));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeModelListener(TwoDModelListener listener) {
            Object object = this;
            synchronized (object) {
                if (this._listenerList == null) {
                    return;
                }
            }
            object = this._listenerList;
            synchronized (object) {
                for (WeakReference ref : this._listenerList) {
                    if (ref.get() != listener) continue;
                    ref.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void compactList() {
            ArrayList arrayList = this._listenerList;
            synchronized (arrayList) {
                Iterator iterator = this._listenerList.iterator();
                while (iterator.hasNext()) {
                    WeakReference ref = (WeakReference)iterator.next();
                    if (ref.get() != null) continue;
                    iterator.remove();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rowsAdded(TwoDModelEvent event) {
            ArrayList arrayList = this._listenerList;
            synchronized (arrayList) {
                for (WeakReference ref : this._listenerList) {
                    TwoDModelListener listener = (TwoDModelListener)ref.get();
                    if (listener == null) continue;
                    listener.rowsAdded(event);
                }
                this.compactList();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rowsRemoved(TwoDModelEvent event) {
            ArrayList arrayList = this._listenerList;
            synchronized (arrayList) {
                for (WeakReference ref : this._listenerList) {
                    TwoDModelListener listener = (TwoDModelListener)ref.get();
                    if (listener == null) continue;
                    listener.rowsRemoved(event);
                }
                this.compactList();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidateRows(TwoDModelEvent event) {
            ArrayList arrayList = this._listenerList;
            synchronized (arrayList) {
                for (WeakReference ref : this._listenerList) {
                    TwoDModelListener listener = (TwoDModelListener)ref.get();
                    if (listener == null) continue;
                    listener.invalidateRows(event);
                }
                this.compactList();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void columnsAdded(TwoDModelEvent event) {
            ArrayList arrayList = this._listenerList;
            synchronized (arrayList) {
                for (WeakReference ref : this._listenerList) {
                    TwoDModelListener listener = (TwoDModelListener)ref.get();
                    if (listener == null) continue;
                    listener.columnsAdded(event);
                }
                this.compactList();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void columnsRemoved(TwoDModelEvent event) {
            ArrayList arrayList = this._listenerList;
            synchronized (arrayList) {
                for (WeakReference ref : this._listenerList) {
                    TwoDModelListener listener = (TwoDModelListener)ref.get();
                    if (listener == null) continue;
                    listener.columnsRemoved(event);
                }
                this.compactList();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidateColumns(TwoDModelEvent event) {
            ArrayList arrayList = this._listenerList;
            synchronized (arrayList) {
                for (WeakReference ref : this._listenerList) {
                    TwoDModelListener listener = (TwoDModelListener)ref.get();
                    if (listener == null) continue;
                    listener.invalidateColumns(event);
                }
                this.compactList();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidateCells(TwoDModelEvent event) {
            ArrayList arrayList = this._listenerList;
            synchronized (arrayList) {
                for (WeakReference ref : this._listenerList) {
                    TwoDModelListener listener = (TwoDModelListener)ref.get();
                    if (listener == null) continue;
                    listener.invalidateCells(event);
                }
                this.compactList();
            }
        }
    }
}

