/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;

class MenuToolButtonUtils {
    private MenuToolButtonUtils() {
    }

    static void showComponentPopupMenu(Component c, JPopupMenu popup) {
        try {
            if (c.isVisible()) {
                Point pt = MenuToolButtonUtils.getPopupMenuOrigin(c, popup);
                popup.show(c, pt.x, pt.y);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static Point getPopupMenuOrigin(Component c, JPopupMenu pm) {
        Container parent;
        int x = 0;
        int y = 0;
        Dimension s = c.getSize();
        Dimension pmSize = pm.getSize();
        if (pmSize.width == 0) {
            pmSize = pm.getPreferredSize();
        }
        Point position = c.getLocationOnScreen();
        Toolkit toolkit = c.getToolkit();
        GraphicsConfiguration gc = c.getGraphicsConfiguration();
        Rectangle screenBounds = new Rectangle(toolkit.getScreenSize());
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gd = ge.getScreenDevices();
        for (int i = 0; i < gd.length; ++i) {
            GraphicsConfiguration dgc;
            if (gd[i].getType() != 0 || !(dgc = gd[i].getDefaultConfiguration()).getBounds().contains(position)) continue;
            gc = dgc;
            break;
        }
        if (gc != null) {
            screenBounds = gc.getBounds();
            Insets screenInsets = toolkit.getScreenInsets(gc);
            screenBounds.width -= Math.abs(screenInsets.left + screenInsets.right);
            screenBounds.height -= Math.abs(screenInsets.top + screenInsets.bottom);
            position.x -= Math.abs(screenInsets.left);
            position.y -= Math.abs(screenInsets.top);
        }
        if ((parent = c.getParent()) instanceof JPopupMenu) {
            int xOffset = UIManager.getInt("Menu.submenuPopupOffsetX");
            int yOffset = UIManager.getInt("Menu.submenuPopupOffsetY");
            if (c.getComponentOrientation().isLeftToRight()) {
                x = s.width + xOffset;
                if (position.x + x + pmSize.width >= screenBounds.width + screenBounds.x && screenBounds.width - s.width < 2 * (position.x - screenBounds.x)) {
                    x = 0 - xOffset - pmSize.width;
                }
            } else {
                x = 0 - xOffset - pmSize.width;
                if (position.x + x < screenBounds.x && screenBounds.width - s.width > 2 * (position.x - screenBounds.x)) {
                    x = s.width + xOffset;
                }
            }
            if (position.y + (y = yOffset) + pmSize.height >= screenBounds.height + screenBounds.y && screenBounds.height - s.height < 2 * (position.y - screenBounds.y)) {
                y = s.height - yOffset - pmSize.height;
            }
        } else {
            int xOffset = UIManager.getInt("Menu.menuPopupOffsetX");
            int yOffset = UIManager.getInt("Menu.menuPopupOffsetY");
            if (c.getComponentOrientation().isLeftToRight()) {
                x = xOffset;
                if (position.x + x + pmSize.width >= screenBounds.width + screenBounds.x && screenBounds.width - s.width < 2 * (position.x - screenBounds.x)) {
                    x = s.width - xOffset - pmSize.width;
                }
            } else {
                x = s.width - xOffset - pmSize.width;
                if (position.x + x < screenBounds.x && screenBounds.width - s.width > 2 * (position.x - screenBounds.x)) {
                    x = xOffset;
                }
            }
            if (position.y + (y = s.height + yOffset) + pmSize.height >= screenBounds.height && screenBounds.height - s.height < 2 * (position.y - screenBounds.y)) {
                y = 0 - yOffset - pmSize.height;
            }
        }
        return new Point(x, y);
    }
}

