/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;

public final class RotatingIcon
implements Icon {
    private final Icon _icon;
    private double _theta;

    public RotatingIcon(Icon icon) {
        this._icon = icon;
    }

    @Override
    public void paintIcon(Component component, Graphics g, int xPos, int yPos) {
        int iconWidth = this.getIconWidth();
        int r = iconWidth / 2;
        Graphics2D graphics2D = (Graphics2D)g;
        graphics2D.rotate(this._theta, r + xPos, r + yPos);
        this._icon.paintIcon(component, graphics2D, xPos, yPos);
        graphics2D.rotate(-this._theta, r + xPos, r + yPos);
    }

    @Override
    public int getIconWidth() {
        return Math.max(this._icon.getIconWidth(), this._icon.getIconHeight());
    }

    @Override
    public int getIconHeight() {
        return this.getIconWidth();
    }

    public void setRotation(double theta) {
        this._theta = theta;
    }
}

