/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dialogs.filter;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.ide.config.FileTypesRecognizer;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.filter.DirectoryExcludeFilter;
import oracle.ide.dialogs.filter.FileFilter;
import oracle.ide.net.URLFilter;
import oracle.ide.net.WildcardURLFilter;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;

public class FileTypeIncludeFilter
extends DirectoryExcludeFilter
implements FileFilter,
Copyable {
    private List<String> _userAddedExtensions = new ArrayList<String>();
    private boolean _includeAllFiles = true;
    private List<String> _selectedExtensions = new ArrayList<String>();
    private CheckBoxListModel _listModel = new CheckBoxListModel();
    private final List<URLFilter> _allSelectedFilters = new ArrayList<URLFilter>();

    public void populateListModel() {
        if (this._listModel.getSize() > 0) {
            return;
        }
        ArrayList<String> collected = new ArrayList<String>(25);
        for (File fileExtension : FileTypesRecognizer.allMappedExtensionsToNodes()) {
            String extension = fileExtension.getPath();
            if (collected.contains(extension)) continue;
            collected.add(extension);
            FileExtension textPair = new FileExtension(extension);
            FilterInfo filterInfo = new FilterInfo(textPair.getFilterText(), !FileTypesRecognizer.isCustomMappedExtension(extension));
            this._listModel.addElement((Object)filterInfo, null, true, false, textPair.getDisplayText());
        }
        Iterator<String> iterator = this._userAddedExtensions.iterator();
        while (iterator.hasNext()) {
            FileExtension ext = new FileExtension(iterator.next());
            if (this._listModel.findElementByText(ext.getDisplayText()) != -1) {
                iterator.remove();
                continue;
            }
            FilterInfo filterInfo = new FilterInfo(ext.getFilterText(), false);
            this._listModel.addElement((Object)filterInfo, null, true, false, ext.getDisplayText());
        }
        for (String selExt : this._selectedExtensions) {
            int location = this._listModel.findElementByText(selExt);
            if (location == -1) continue;
            this._listModel.setElementSelected(location);
        }
        this._listModel.sort();
    }

    public List<String> getUserAddedExtensions() {
        return this._userAddedExtensions;
    }

    public void setUserAddedExtensions(List<String> list) {
        this._userAddedExtensions = list;
    }

    public CheckBoxListModel getListModel() {
        return this._listModel;
    }

    public void setListModel(CheckBoxListModel listModel) {
        this._listModel = listModel;
    }

    public boolean getIncludeAllFiles() {
        return this._includeAllFiles;
    }

    public void setIncludeAllFiles(boolean includeAllFiles) {
        this._includeAllFiles = includeAllFiles;
    }

    @Override
    public List<URLFilter> getList() {
        if (this._includeAllFiles) {
            return null;
        }
        return this._allSelectedFilters;
    }

    public static boolean equals(FileTypeIncludeFilter f1, FileTypeIncludeFilter f2) {
        if (!DirectoryExcludeFilter.equals(f1, f2)) {
            return false;
        }
        if (f1.getIncludeAllFiles() != f2.getIncludeAllFiles()) {
            return false;
        }
        if (!f1.getUserAddedExtensions().equals(f2.getUserAddedExtensions())) {
            return false;
        }
        if (f1.getList() != null ? !f1.getList().equals(f2.getList()) : f2.getList() != null) {
            return false;
        }
        return f1.getListModel().equals((Object)f2.getListModel());
    }

    public void clearAllSelectedFilters() {
        this._allSelectedFilters.clear();
    }

    public void setSelectedFilters() {
        List selectedFilterList = this._listModel.getSelectionList();
        if (selectedFilterList != null) {
            for (FilterInfo filterInfo : selectedFilterList) {
                this._allSelectedFilters.add(filterInfo.getURLFilter());
            }
        }
        this._selectedExtensions.clear();
        int len = this._listModel.getSize();
        for (int i = 0; i < len; ++i) {
            if (!this._listModel.isElementSelected(i)) continue;
            this._selectedExtensions.add(this._listModel.findTextForElement(i));
        }
        List userDefinedList = this.parseUserDefinedFilterString();
        this._allSelectedFilters.addAll(userDefinedList);
    }

    public void removeUserDefinedValueFromList(int index) {
        String text = this._listModel.findTextForElement(index);
        if (text.startsWith("*.") && !WildcardURLFilter.hasWildcard((String)text.substring(2))) {
            text = text.substring(1);
        }
        this._userAddedExtensions.remove(text);
        this._listModel.removeElementByIndex(index);
    }

    public boolean addUserDefinedValueToList(String value) {
        FileExtension ext = new FileExtension(value);
        if (this._userAddedExtensions.contains(ext.getFilterText())) {
            return false;
        }
        this._userAddedExtensions.add(ext.getFilterText());
        FilterInfo filterInfo = new FilterInfo(ext.getFilterText(), false);
        this._listModel.addElement((Object)filterInfo, null, true, true, ext.getDisplayText());
        this._listModel.sort();
        return true;
    }

    public List<String> getSelectedExtensions() {
        return this._selectedExtensions;
    }

    public void setSelectedExtensions(List<String> selectedExtensions) {
        this._selectedExtensions = selectedExtensions;
        for (String extText : this._selectedExtensions) {
            FileExtension ext = new FileExtension(extText);
            FilterInfo filterInfo = new FilterInfo(ext.getFilterText(), false);
            this._allSelectedFilters.add(filterInfo.getURLFilter());
        }
    }

    public boolean isListElementLocked(int row) {
        FilterInfo filterInfo = (FilterInfo)this._listModel.getUserObjectAt(row);
        return filterInfo.isSystemDefined();
    }

    @Override
    public Object copyTo(Object target) {
        FileTypeIncludeFilter copy = target != null ? (FileTypeIncludeFilter)target : new FileTypeIncludeFilter();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(FileTypeIncludeFilter copy) {
        copy.setIncludeAllFiles(this.getIncludeAllFiles());
        copy.setRecurseDirectories(this.getRecurseDirectories());
        copy.setApplyToDirectory(this.getApplyToDirectory());
        copy.setUserDefinedExclusions(this.getUserDefinedExclusions());
        ModelUtil.deepCopy(this._userAddedExtensions, copy._userAddedExtensions);
        ModelUtil.deepCopy(this._allSelectedFilters, copy._allSelectedFilters);
        ModelUtil.deepCopy(this._selectedExtensions, copy._selectedExtensions);
        if (this._listModel != null) {
            this._listModel.copyTo((Object)copy._listModel);
        }
    }

    private static class FileExtension {
        private final String _filterText;
        private final String _displayText;

        public FileExtension(String ext) {
            if (ext.startsWith("*.") && !WildcardURLFilter.hasWildcard((String)ext.substring(2))) {
                this._displayText = ext;
                this._filterText = ext.substring(1);
            } else if (ext.startsWith(".") && !WildcardURLFilter.hasWildcard((String)ext)) {
                this._displayText = "*" + ext;
                this._filterText = ext;
            } else {
                this._displayText = ext;
                this._filterText = ext;
            }
        }

        public String getFilterText() {
            return this._filterText;
        }

        public String getDisplayText() {
            return this._displayText;
        }
    }

    public static class FilterInfo {
        private URLFilter _urlFilter;
        private boolean _systemDefined;

        public FilterInfo(String filterText, boolean systemDefined) {
            this._urlFilter = DirectoryExcludeFilter.createURLFilter(filterText, 0);
            this._systemDefined = systemDefined;
        }

        public URLFilter getURLFilter() {
            return this._urlFilter;
        }

        public boolean isSystemDefined() {
            return this._systemDefined;
        }
    }
}

