/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import oracle.ide.Ide;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.IdeAction;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.util.BitField;
import oracle.ide.util.JDK;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.SwingUtils;

public final class KeyUtil {
    private static final JPanel _actionKeyPanel = new JPanel();
    private static String ACCELERATOR_DELIMITER = null;

    public static String toString(KeyStroke ks) {
        if (ks == null) {
            return "";
        }
        int keyCode = ks.getKeyCode();
        if (keyCode == 0) {
            return "";
        }
        int keyMod = ks.getModifiers();
        StringBuffer ret = new StringBuffer();
        if (keyMod != 0) {
            ret.append(KeyUtil.getKeyModifiersText(keyMod) + KeyUtil.getAccelDelimiter());
        }
        ret.append(KeyEvent.getKeyText(ks.getKeyCode()));
        return ret.toString();
    }

    static String toSortableString(KeyStroke ks) {
        if (ks == null) {
            return "";
        }
        int keyCode = ks.getKeyCode();
        if (keyCode == 0) {
            return "";
        }
        int keyMod = ks.getModifiers();
        StringBuffer ret = new StringBuffer();
        ret.append(KeyEvent.getKeyText(ks.getKeyCode()));
        if (keyMod != 0) {
            ret.append(KeyUtil.getKeyModifiersText(keyMod));
        }
        return ret.toString();
    }

    private static String getAccelDelimiter() {
        if (ACCELERATOR_DELIMITER == null && ((ACCELERATOR_DELIMITER = UIManager.getString("MenuItem.acceleratorDelimiter")) == null || ACCELERATOR_DELIMITER.length() == 0)) {
            ACCELERATOR_DELIMITER = "+";
        }
        return ACCELERATOR_DELIMITER;
    }

    private static String getKeyModifiersText(int modifiers) {
        if (!JDK.HAS_BUG_GETKEYMODIFIERSTEXT) {
            return KeyEvent.getKeyModifiersText(modifiers);
        }
        StringBuffer buf = new StringBuffer();
        String accelDelimiter = KeyUtil.getAccelDelimiter();
        if ((modifiers & 4) != 0) {
            buf.append(Toolkit.getProperty("AWT.meta", "Meta"));
            buf.append(accelDelimiter);
        }
        if ((modifiers & 2) != 0) {
            buf.append(Toolkit.getProperty("AWT.control", "Ctrl"));
            buf.append(accelDelimiter);
        }
        if ((modifiers & 8) != 0) {
            buf.append(Toolkit.getProperty("AWT.alt", "Alt"));
            buf.append(accelDelimiter);
        }
        if ((modifiers & 1) != 0) {
            buf.append(Toolkit.getProperty("AWT.shift", "Shift"));
            buf.append(accelDelimiter);
        }
        if ((modifiers & 0x20) != 0) {
            buf.append(Toolkit.getProperty("AWT.altGraph", "Alt Graph"));
            buf.append(accelDelimiter);
        }
        if (accelDelimiter.length() > 0 && buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    public static boolean isActionKey(KeyStroke ks) {
        KeyEvent ke = new KeyEvent(_actionKeyPanel, ks.isOnKeyRelease() ? 401 : 402, 0L, ks.getModifiers(), ks.getKeyCode(), ks.getKeyChar());
        return ke.isActionKey();
    }

    public static boolean isModifierKey(int keyCode) {
        return keyCode == 17 || keyCode == 16 || keyCode == 18 || keyCode == 65406 || keyCode == 157;
    }

    public static boolean isModifierKey(KeyStroke keyStroke) {
        return KeyUtil.isModifierKey(keyStroke.getKeyCode());
    }

    public static void removeKeyStrokesFromInputMaps(JComponent component, KeyStroke[] keyStrokes) {
        SwingUtils.removeKeyStrokesFromInputMaps((JComponent)component, (KeyStroke[])keyStrokes);
    }

    public static void removeKeyStrokesFromInputMap(JComponent component, KeyStroke[] keyStrokes, int mapType) {
        SwingUtils.removeKeyStrokesFromInputMap((JComponent)component, (KeyStroke[])keyStrokes, (int)mapType);
    }

    public static String getAcceleratorTooltip(int cmdID) {
        IdeSettings ideSettings = Ide.getSettings();
        KeyStrokeOptions keyStrokeOptions = ideSettings.getKeyStrokeOptions();
        KeyStrokeMap keyMap = keyStrokeOptions.getGlobalKeyMap();
        return KeyUtil.getAcceleratorTooltip(keyMap, cmdID);
    }

    public static String getAcceleratorTooltip(KeyStrokeMap keyMap, int cmdID) {
        KeyStroke accelerator = KeyUtil.getBestAccelerator(keyMap, cmdID);
        return accelerator != null ? KeyUtil.toString(accelerator) : "";
    }

    public static String buildTooltip(int cmdID) {
        IdeAction ideAction = IdeAction.find(cmdID);
        return ideAction != null ? KeyUtil.buildToolTip(ideAction) : "";
    }

    public static String buildToolTip(IdeAction ideAction) {
        String name;
        Object desc = ideAction.getValue("ShortDescription");
        if (desc == null) {
            desc = ideAction.getValue("Name");
        }
        String string = name = desc != null ? desc.toString() : null;
        if (!ModelUtil.hasLength((String)name)) {
            return null;
        }
        String accel = KeyUtil.getAcceleratorTooltip(ideAction.getCommandId());
        return ModelUtil.hasLength((String)accel) ? name + " (" + accel + ")" : name;
    }

    private static void removeCtrlTabFromTraversalKeys(Component component, int id) {
        Set<AWTKeyStroke> focusTraversalKeys = component.getFocusTraversalKeys(id);
        HashSet<AWTKeyStroke> newSet = new HashSet<AWTKeyStroke>();
        for (AWTKeyStroke awtKeyStroke : focusTraversalKeys) {
            if (awtKeyStroke.getKeyCode() == 9 && BitField.isSet(awtKeyStroke.getModifiers(), 2)) continue;
            newSet.add(awtKeyStroke);
        }
        component.setFocusTraversalKeys(id, newSet);
    }

    public static void removeCtrlTabFromTraversalKeys(Component component) {
        KeyUtil.removeCtrlTabFromTraversalKeys(component, 0);
        KeyUtil.removeCtrlTabFromTraversalKeys(component, 1);
    }

    public static KeyStroke getBestAccelerator(KeyStrokeMap ksm, int nCmdID) {
        KeyStroke bestAccelerator = null;
        List<KeyStrokes> list = ksm.getKeyStrokesFor(nCmdID);
        if (!list.isEmpty()) {
            for (KeyStrokes kss : list) {
                KeyStroke accelerator;
                if (kss.getLength() != 1 || (accelerator = kss.getKeyStroke(0)) == null) continue;
                if (bestAccelerator == null) {
                    bestAccelerator = accelerator;
                    continue;
                }
                int bestKeyClass = KeyUtil.getKeyClass(bestAccelerator);
                int keyClass = KeyUtil.getKeyClass(accelerator);
                if (keyClass > bestKeyClass) {
                    bestAccelerator = accelerator;
                    continue;
                }
                if (keyClass != bestKeyClass) continue;
                int bestModifiers = bestAccelerator.getModifiers();
                int bestModCount = KeyUtil.countModifiers(bestModifiers);
                int modifiers = accelerator.getModifiers();
                int modCount = KeyUtil.countModifiers(modifiers);
                if (modCount >= bestModCount) continue;
                bestAccelerator = accelerator;
            }
        }
        return bestAccelerator;
    }

    private static int getKeyClass(KeyStroke keyStroke) {
        int keyCode = keyStroke.getKeyCode();
        return 112 <= keyCode && keyCode <= 123 ? 2 : (65 <= keyCode && keyCode <= 90 ? 1 : 0);
    }

    private static int countModifiers(int modifiers) {
        boolean isAltDown = BitField.isSet(modifiers, 8);
        boolean isCtrlDown = BitField.isSet(modifiers, 2);
        boolean isShiftDown = BitField.isSet(modifiers, 1);
        boolean isMetaDown = BitField.isSet(modifiers, 4);
        return (isAltDown ? 1 : 0) + (isCtrlDown ? 1 : 0) + (isShiftDown ? 1 : 0) + (isMetaDown ? 1 : 0);
    }
}

