/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controller;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.ideimpl.controller.CommandExecutionEvent;
import oracle.ideimpl.controller.CommandExecutionListener;

public class CommandExecutionTracker {
    private static CommandExecutionTracker commandExecutionTracker;
    private int executionCount;
    private Map<Thread, Deque<CommandExecutionEvent>> stacks = new HashMap<Thread, Deque<CommandExecutionEvent>>();
    private CopyOnWriteArrayList<CommandExecutionListener> listeners = new CopyOnWriteArrayList();

    private CommandExecutionTracker() {
    }

    public static synchronized CommandExecutionTracker commandExecutionTracker() {
        if (commandExecutionTracker == null) {
            commandExecutionTracker = new CommandExecutionTracker();
        }
        return commandExecutionTracker;
    }

    public void addCommandExecutionListener(CommandExecutionListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listeners.addIfAbsent(listener);
    }

    public void removeCommandExecutionListener(CommandExecutionListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listeners.remove(listener);
    }

    public synchronized void start(String description) {
        Deque<CommandExecutionEvent> stack = this.stacks.get(Thread.currentThread());
        if (stack == null) {
            stack = new ArrayDeque<CommandExecutionEvent>();
            this.stacks.put(Thread.currentThread(), stack);
        }
        CommandExecutionEvent event = new CommandExecutionEvent(this, description, this.executionCount++);
        stack.push(event);
        this.fireCommandStarted(event);
    }

    public void end() {
        Deque<CommandExecutionEvent> stack = this.stacks.get(Thread.currentThread());
        if (stack == null) {
            throw new IllegalStateException("no command executing");
        }
        CommandExecutionEvent event = stack.pop();
        if (stack.isEmpty()) {
            this.stacks.remove(Thread.currentThread());
        }
        event = new CommandExecutionEvent(this, event.getDescription(), --this.executionCount);
        this.fireCommandEnded(event);
    }

    private void fireCommandStarted(CommandExecutionEvent event) {
        for (CommandExecutionListener listener : this.listeners) {
            listener.commandStarting(event);
        }
    }

    private void fireCommandEnded(CommandExecutionEvent event) {
        for (CommandExecutionListener listener : this.listeners) {
            listener.commandEnded(event);
        }
    }
}

