/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.config.SettingsCustomizations;
import oracle.ide.config.SettingsFieldCustomizations;
import oracle.ide.config.SettingsUICustomizationsHook;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.ContextMenuListenersHook;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorConstants;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.util.MnemonicSolver;
import oracle.ideimpl.editor.DeclarativeEditorAddin;
import oracle.ideimpl.editor.DefaultEditorsPrefs;
import oracle.ideimpl.editor.EditorAddinRegistry;

public abstract class DefaultEditorManager
extends EditorManager {
    private static final boolean DEBUG_TRACE_VIEW_CHANGES = Boolean.valueOf(Ide.getProperty("DEBUG_TRACE_VIEW_CHANGES", "false"));
    public static final int MAX_SHORTCUTS = 9;
    public static final int EDITOR_EVENT_OPENED = 1;
    public static final int EDITOR_EVENT_ACTIVATED = 2;
    public static final int EDITOR_EVENT_DEACTIVATED = 3;
    public static final int EDITOR_EVENT_CLOSED = 4;
    public static final int CLOSE_OTHERS_CMD_ID = Ide.findOrCreateCmdID("CLOSE_OTHERS_CMD_ID");
    public static final int SYSTEM_MENU_CMD_ID = Ide.findOrCreateCmdID("SYSTEM_MENU_CMD_ID");
    public static final int NEXT_PANE_CMD_ID = Ide.findOrCreateCmdID("NEXT_PANE_CMD_ID");
    public static final int PREV_PANE_CMD_ID = Ide.findOrCreateCmdID("PREV_PANE_CMD_ID");
    public static final int SPLIT_DOCUMENT_CMD_ID = Ide.findOrCreateCmdID("SPLIT_DOCUMENT_CMD_ID");
    public static final int SPLIT_DOCUMENT_VER_CMD_ID = Ide.findOrCreateCmdID("SPLIT_DOCUMENT_VER_CMD_ID");
    public static final int UNSPLIT_DOCUMENT_CMD_ID = Ide.findOrCreateCmdID("UNSPLIT_DOCUMENT_CMD_ID");
    public static final int DETACH_DOCUMENT_CMD_ID = Ide.findOrCreateCmdID("DETACH_DOCUMENT_CMD_ID");
    public static final int REGROUP_DOCUMENTS_CMD_ID = Ide.findOrCreateCmdID("REGROUP_DOCUMENTS_CMD_ID");
    public static final int NAVIGATE_LRU_FILES_CMD_ID = Ide.findOrCreateCmdID("NAVIGATE_LRU_FILES_CMD_ID");
    public static final int MAXIMIZE_TAB_GROUP_CMD_ID = Ide.findOrCreateCmdID("MAXIMIZE_TAB_GROUP_CMD_ID");
    public static final int RESTORE_TAB_GROUPS_CMD_ID = Ide.findOrCreateCmdID("RESTORE_TAB_GROUPS_CMD_ID");
    public static final int TOGGLE_MAXIMIZE_RESTORE_TAB_GROUP_CMD_ID = Ide.findOrCreateCmdID("TOGGLE_MAXIMIZE_RESTORE_TAB_GROUP_CMD_ID");
    protected EditorAddinRegistry _editorAddinRegistry = new EditorAddinRegistry();
    private ContextMenu CONTEXT_MENU;
    private final ArrayList _editorListeners = new ArrayList(3);

    private static void traceEditorEvent(int eventID, Editor editor) {
        if (DEBUG_TRACE_VIEW_CHANGES) {
            String eventText = eventID == 1 ? "EDITOR_EVENT_OPENED" : (eventID == 2 ? "EDITOR_EVENT_ACTIVATED" : (eventID == 3 ? "EDITOR_EVENT_DEACTIVATED" : (eventID == 4 ? "EDITOR_EVENT_CLOSED" : "???")));
            String editorId = editor == null ? "null" : editor.getId();
            System.out.println("fireEditorEvent( " + eventText + ", " + editorId + ")");
        }
    }

    @Override
    public void addEditorListener(EditorListener listener) {
        this._editorListeners.add(listener);
    }

    @Override
    public void extend(EditorAddin editorAddin, Class[] types) {
        this._editorAddinRegistry.extend(editorAddin, types);
    }

    @Override
    @Deprecated
    public EditorAddin getBestEditorAddin(Node node) {
        EditorAddin ret = this.getDefaultAddinPreference(this.getAddins(node), node.getClass().getName());
        if (ret == null) {
            ret = this.getDefaultAddin(node);
        }
        return ret;
    }

    @Override
    public EditorAddin getBestEditorAddin(Context context) {
        EditorAddin ret = this.getDefaultAddinPreference(context);
        if (ret == null) {
            ret = this.getDefaultAddin(context);
        }
        return ret;
    }

    @Override
    @Deprecated
    public EditorAddin getDefaultAddin(Element element) {
        EditorAddin ret = null;
        List addins = this.getAddins(element);
        if (!addins.isEmpty()) {
            ret = (EditorAddin)addins.get(0);
        }
        return ret;
    }

    @Override
    public EditorAddin getDefaultAddin(Context context) {
        EditorAddin ret = null;
        List<EditorAddin> addins = this.getAddins(context);
        if (!addins.isEmpty()) {
            ret = addins.get(0);
        }
        return ret;
    }

    @Override
    public EditorAddin getEditorAddin(Class cls) {
        return this._editorAddinRegistry.getEditorAddin(cls);
    }

    @Override
    @Deprecated
    public Class[] getStaticElementTypes() {
        return this._editorAddinRegistry.getStaticElementTypes().toArray(new Class[0]);
    }

    @Override
    public String[] getStaticElementClassNames() {
        return this._editorAddinRegistry.getStaticElementClassNames().toArray(new String[0]);
    }

    @Override
    public boolean isEditorRegistered(Class cls) {
        return this._editorAddinRegistry.isEditorRegistered(cls);
    }

    @Override
    public void register(EditorAddin editorAddin, Class[] types) {
        this.extend(editorAddin, types);
    }

    @Override
    public void registerDynamic(EditorAddin editorAddin) {
        this._editorAddinRegistry.registerDynamic(editorAddin);
    }

    @Override
    public void removeEditorListener(EditorListener listener) {
        this._editorListeners.remove(listener);
    }

    @Override
    public void unregister(EditorAddin editorAddin) {
        this._editorAddinRegistry.unregister(editorAddin);
    }

    @Override
    public void unregisterDynamic(EditorAddin editorAddin) {
        this._editorAddinRegistry.unregisterDynamic(editorAddin);
    }

    final void fireEditorEvent(int eventID, Editor editor) {
        DefaultEditorManager.traceEditorEvent(eventID, editor);
        List dup = (List)this._editorListeners.clone();
        for (int i = 0; i < dup.size(); ++i) {
            EditorListener editorListener = (EditorListener)dup.get(i);
            try {
                switch (eventID) {
                    case 1: {
                        long startTime = System.nanoTime();
                        editorListener.editorOpened(editor);
                        long endTime = System.nanoTime();
                        PerformanceLogger.get().log("EditorListener.editorOpened", editorListener.getClass().getName(), endTime - startTime);
                        break;
                    }
                    case 2: {
                        long startTime = System.nanoTime();
                        editorListener.editorActivated(editor);
                        long endTime = System.nanoTime();
                        PerformanceLogger.get().log("EditorListener.editorActivated", editorListener.getClass().getName(), endTime - startTime);
                        break;
                    }
                    case 3: {
                        long startTime = System.nanoTime();
                        editorListener.editorDeactivated(editor);
                        long endTime = System.nanoTime();
                        PerformanceLogger.get().log("EditorListener.editorDeactivated", editorListener.getClass().getName(), endTime - startTime);
                        break;
                    }
                    case 4: {
                        long startTime = System.nanoTime();
                        editorListener.editorClosed(editor);
                        long endTime = System.nanoTime();
                        PerformanceLogger.get().log("EditorListener.editorClosed", editorListener.getClass().getName(), endTime - startTime);
                        break;
                    }
                }
                continue;
            }
            catch (Exception e) {
                FeedbackManager.reportException(e);
            }
        }
    }

    public static final String getRoleOverrideEditorName(String nodeClassName) {
        SettingsFieldCustomizations fields;
        String result = null;
        SettingsCustomizations settings = null;
        SettingsUICustomizationsHook hook = (SettingsUICustomizationsHook)ExtensionRegistry.getExtensionRegistry().getHook(SettingsUICustomizationsHook.ELEMENT);
        if (hook != null && (settings = hook.getSettingsCustomizations()) != null && (fields = settings.getFieldCustomizations("/preferences/DefaultEditors/" + nodeClassName)) != null) {
            result = fields.getValue();
        }
        return result;
    }

    private EditorAddin getDefaultAddinPreference(Context context) {
        return this.getDefaultAddinPreference(this.getAddins(context), context.getNode().getClass().getName());
    }

    private EditorAddin getDefaultAddinPreference(Collection<EditorAddin> editorAddins, String nodeClassName) {
        EditorAddin result = null;
        DefaultEditorsPrefs defaultEditorPrefs = DefaultEditorsPrefs.getInstance(Preferences.getPreferences());
        String editorType = defaultEditorPrefs.getEditorType(nodeClassName);
        if (editorType == null) {
            editorType = DefaultEditorManager.getRoleOverrideEditorName(nodeClassName);
        }
        if (editorType == null) {
            for (EditorAddin editorAddin : editorAddins) {
                if (!editorAddin.isDefault()) continue;
                result = editorAddin;
                break;
            }
        } else {
            for (EditorAddin editorAddin : this._editorAddinRegistry.declarativeAddinsFrom(this._editorAddinRegistry.declarativeEditors(nodeClassName))) {
                if (!editorType.equals(DefaultEditorManager.getEditorClassNameFromEditorAddin(editorAddin))) continue;
                return editorAddin;
            }
            for (EditorAddin editorAddin : editorAddins) {
                if (!editorType.equals(DefaultEditorManager.getEditorClassNameFromEditorAddin(editorAddin))) continue;
                result = editorAddin;
                break;
            }
        }
        return result;
    }

    private void logDefaultEditor(String nodeClassName, String editorType) {
        Logger.getAnonymousLogger().info("Default Editor Log: Node  " + nodeClassName + " > Default Editor " + editorType);
    }

    private static final String getEditorClassNameFromEditorAddin(EditorAddin editorAddin) {
        if (editorAddin instanceof DeclarativeEditorAddin) {
            return ((DeclarativeEditorAddin)editorAddin).getEditorMetaClass().getClassName();
        }
        return editorAddin.getEditorClass().getName();
    }

    @Deprecated
    List getAddins(Element element) {
        return this._editorAddinRegistry.getAddins(element);
    }

    @Override
    public List<EditorAddin> getAddins(Context context) {
        return Collections.unmodifiableList(this._editorAddinRegistry.getAddins(context));
    }

    @Override
    public final synchronized ContextMenu getContextMenu() {
        if (this.CONTEXT_MENU == null) {
            this.CONTEXT_MENU = new ContextMenu(new MnemonicSolver());
            this.CONTEXT_MENU.addContextMenuListener(new ContextMenuListener(){

                @Override
                public void menuWillShow(ContextMenu popup) {
                    JMenuItem navigateItem;
                    DefaultEditorManager.this.recreateBasicContextMenuActions();
                    popup.add((Component)EditorConstants.CUT_ITEM, MenuConstants.SECTION_EDIT_CTXT_MENU, true);
                    popup.add((Component)EditorConstants.COPY_ITEM, MenuConstants.SECTION_EDIT_CTXT_MENU, true);
                    popup.add((Component)EditorConstants.PASTE_ITEM, MenuConstants.SECTION_EDIT_CTXT_MENU, true);
                    popup.add((Component)EditorConstants.ALL_ITEM, MenuConstants.SECTION_EDIT_CTXT_MENU, true);
                    if (EditorConstants.NAVIGATE_ITEM == null) {
                        EditorConstants.NAVIGATE_ITEM = DefaultEditorManager.this.CONTEXT_MENU.createMenuItem(IdeAction.find(57), MenuConstants.WEIGHT_NAVIGATE_SELECT_IN_NAVIGATOR);
                    }
                    if ((navigateItem = EditorConstants.NAVIGATE_ITEM) != null) {
                        IdeAction navigateAction = (IdeAction)navigateItem.getAction();
                        navigateAction.updateAction(popup.getContext());
                        popup.add((Component)navigateItem, MenuConstants.SECTION_NAVIGATE_CTXT_MENU, true);
                    }
                }

                @Override
                public void menuWillHide(ContextMenu popup) {
                }

                @Override
                public boolean handleDefaultAction(Context context) {
                    return false;
                }
            });
            IdeAction action = IdeAction.find(57);
            EditorConstants.NAVIGATE_ITEM = this.CONTEXT_MENU.createMenuItem(action, MenuConstants.WEIGHT_NAVIGATE_SELECT_IN_NAVIGATOR);
            action = IdeAction.find(5);
            EditorConstants.UNDO_ITEM = this.CONTEXT_MENU.createMenuItem(action, 1.0f);
            action = IdeAction.find(6);
            EditorConstants.REDO_ITEM = this.CONTEXT_MENU.createMenuItem(action, MenuConstants.WEIGHT_EDIT_REDO);
            action = IdeAction.find(17);
            EditorConstants.CUT_ITEM = this.CONTEXT_MENU.createMenuItem(action, MenuConstants.WEIGHT_EDIT_CUT);
            action = IdeAction.find(18);
            EditorConstants.COPY_ITEM = this.CONTEXT_MENU.createMenuItem(action, MenuConstants.WEIGHT_EDIT_COPY);
            action = IdeAction.find(19);
            EditorConstants.PASTE_ITEM = this.CONTEXT_MENU.createMenuItem(action, MenuConstants.WEIGHT_EDIT_PASTE);
            action = IdeAction.find(78);
            EditorConstants.EXTENDED_PASTE_ITEM = this.CONTEXT_MENU.createMenuItem(action, MenuConstants.WEIGHT_EDIT_EXTENDED_PASTE);
            action = IdeAction.find(22);
            EditorConstants.ALL_ITEM = this.CONTEXT_MENU.createMenuItem(action, MenuConstants.WEIGHT_EDIT_SELECT_ALL);
            ContextMenuListenersHook hook = (ContextMenuListenersHook)ExtensionRegistry.getExtensionRegistry().getHook(ContextMenuListenersHook.ELEMENT);
            if (hook != null) {
                this.CONTEXT_MENU.addContextMenuListener(hook.getListener("editor"));
            }
        }
        return this.CONTEXT_MENU;
    }

    @Override
    public boolean hasEditors(Element element) {
        return this._editorAddinRegistry.hasAddins(element, null);
    }

    @Override
    public boolean hasEditors(Context context) {
        return this._editorAddinRegistry.hasAddins(context.getElement(), context);
    }

    @Override
    @Deprecated
    public EditorAddin[] getStaticAddins(Class elementClass) {
        EditorAddin[] result = this._editorAddinRegistry.getStaticAddins(elementClass).toArray(new EditorAddin[0]);
        return result;
    }

    @Override
    public EditorAddin[] getStaticAddins(String elementClassName) {
        return this._editorAddinRegistry.getStaticAddins(elementClassName).toArray(new EditorAddin[0]);
    }

    private void recreateBasicContextMenuActions() {
        IdeAction action = null;
        if (EditorConstants.CUT_ITEM == null) {
            action = IdeAction.find(17);
            if (action == null) {
                Logger.getAnonymousLogger().warning("Create action is null IdeConstants.CUT_CMD_ID");
                Thread.dumpStack();
            }
            EditorConstants.CUT_ITEM = this.CONTEXT_MENU.createMenuItem(action, MenuConstants.WEIGHT_EDIT_CUT);
        }
        if (EditorConstants.COPY_ITEM == null) {
            action = IdeAction.find(18);
            if (action == null) {
                Logger.getAnonymousLogger().warning("Create action is null IdeConstants.COPY_CMD_ID");
                Thread.dumpStack();
            }
            EditorConstants.COPY_ITEM = this.CONTEXT_MENU.createMenuItem(action, MenuConstants.WEIGHT_EDIT_COPY);
        }
        if (EditorConstants.PASTE_ITEM == null) {
            action = IdeAction.find(19);
            if (action == null) {
                Logger.getAnonymousLogger().warning("Create action is null IdeConstants.PASTE_CMD_ID");
                Thread.dumpStack();
            }
            EditorConstants.PASTE_ITEM = this.CONTEXT_MENU.createMenuItem(action, MenuConstants.WEIGHT_EDIT_PASTE);
        }
        if (EditorConstants.ALL_ITEM == null) {
            action = IdeAction.find(22);
            if (action == null) {
                Logger.getAnonymousLogger().warning("Create action is null IdeConstants.SELECT_ALL_CMD_ID");
                Thread.dumpStack();
            }
            EditorConstants.ALL_ITEM = this.CONTEXT_MENU.createMenuItem(action, MenuConstants.WEIGHT_EDIT_SELECT_ALL);
        }
    }
}

