/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.text.MessageFormat;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.Extension;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.ExtensionQueue;
import oracle.ide.extension.feature.Feature;
import oracle.ide.resource.IdeArb;
import oracle.ideimpl.extension.ExemptedRunnable;
import oracle.ideimpl.extension.ExtensionManagerImpl;
import oracle.ideimpl.extension.IDEExtension;
import oracle.javatools.dialogs.progress.ProgressPanel;

public class ExtensionLoaderThread
extends SwingWorker<Void, Integer> {
    private final ExtensionQueue m_extensionQueue;
    private final ProgressPanel m_panel;

    public ExtensionLoaderThread(ExtensionQueue queue, ProgressPanel area) {
        this.m_extensionQueue = queue;
        this.m_panel = area;
    }

    @Override
    protected Void doInBackground() throws Exception {
        if (this.m_extensionQueue.size() > 0) {
            double progressIncrement = 100.0 / (double)this.m_extensionQueue.size();
            double progress = 0.0;
            for (final Extension ext : this.m_extensionQueue) {
                ExtensionRegistry registry;
                if (this.m_panel != null) {
                    final Feature feature = ExtensionRegistry.getExtensionRegistry().getFeatureRegistry().getFeatureForExtension(ext.getID());
                    SwingUtilities.invokeLater(new ExemptedRunnable(){

                        @Override
                        public void run() {
                            ExtensionLoaderThread.this.m_panel.setNote(MessageFormat.format(IdeArb.getString(524), feature != null ? feature.getDisplayName() : ext.getName()));
                        }
                    });
                }
                if ((registry = ExtensionRegistry.getExtensionRegistry()) instanceof ExtensionManagerImpl && ((IDEExtension)ext).getState() != IDEExtension.State.FULLY_LOADED) {
                    ((ExtensionManagerImpl)registry).__loadExtensionHooks(ext);
                }
                this.setProgress((int)Math.floor(progress += progressIncrement));
            }
        }
        return null;
    }

    @Override
    protected void done() {
        try {
            this.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException unexpected) {
            Logger logger = Logger.getLogger("oracle.ide.extension.load");
            logger.log(Level.SEVERE, "Unexpected exception encountered during extension loading", unexpected.getCause());
            throw new RuntimeException("Unexpected exception encountered during extension loading", unexpected.getCause());
        }
    }
}

