/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.util.MetaClass;
import oracle.ide.model.HeadlessAwareMetaClassWrapper;

public class SingletonProviderHook
extends ExtensionHook {
    public static final ElementName HOOK_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "singleton-provider-hook");
    private static final Map<String, HeadlessAwareMetaClassWrapper> _singletonCache = new LinkedHashMap<String, HeadlessAwareMetaClassWrapper>();
    public static final ElementName SINGLETON_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "singleton");
    private static final SingletonVisitor _singletonVisitor = new SingletonVisitor();

    public void start(ElementStartContext context) {
        context.registerChildVisitor(SINGLETON_ELEMENT, (ElementVisitor)_singletonVisitor);
    }

    public Map<String, HeadlessAwareMetaClassWrapper> getMetaClasses() {
        return Collections.unmodifiableMap(_singletonCache);
    }

    private static class SingletonVisitor
    extends ElementVisitor {
        private static final String BASE_CLASS_ATTR = "base-class";
        private static final String IMPL_CLASS_ATTR = "impl-class";
        private static final String HEADLESS_ATTR = "headless";

        private SingletonVisitor() {
        }

        public void start(ElementStartContext context) {
            String baseClass = context.getAttributeValue(BASE_CLASS_ATTR);
            String implClass = context.getAttributeValue(IMPL_CLASS_ATTR);
            String headless = context.getAttributeValue(HEADLESS_ATTR);
            if (baseClass == null || (baseClass = baseClass.trim()).length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Missing required attribute 'base-class'.");
                return;
            }
            if (implClass == null || (implClass = implClass.trim()).length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Missing required attribute 'impl-class'.");
                return;
            }
            if (headless == null || (headless = headless.trim()).length() == 0) {
                headless = "true";
            }
            MetaClass metaClass = new MetaClass(this.getMetaClassLoader((ElementContext)context), implClass);
            _singletonCache.put(baseClass, new HeadlessAwareMetaClassWrapper(metaClass, Boolean.valueOf(headless)));
        }
    }
}

